/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.Properties;

public class PropertiesLoader {
    private static final String INCLUDES_PROPERTY = "${includes}";
    private static final String OPTIONALS_PROPERTY = "${optionals}";
    private static final String OVERRIDE_PREFIX = "karaf.override.";

    public static Properties loadConfigProperties(File file) throws Exception {
        URL configPropURL;
        try {
            configPropURL = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        final Properties configProps = PropertiesLoader.loadPropertiesFile(configPropURL, false);
        PropertiesLoader.copySystemProperties(configProps);
        configProps.substitute((InterpolationHelper.SubstitutionCallback)new InterpolationHelper.BundleContextSubstitutionCallback(null){

            public String getValue(String key) {
                String value = super.getValue(key);
                if (value == null) {
                    return PropertiesLoader.lookupVirtualProperty(configProps, key);
                }
                return value;
            }
        });
        return configProps;
    }

    public static void loadSystemProperties(File file) throws IOException {
        Properties props = null;
        try {
            URL configPropURL = file.toURI().toURL();
            props = PropertiesLoader.loadPropertiesFile(configPropURL, true);
        }
        catch (Exception ex) {
            return;
        }
        InterpolationHelper.BundleContextSubstitutionCallback callback = new InterpolationHelper.BundleContextSubstitutionCallback(null);
        Enumeration e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.startsWith(OVERRIDE_PREFIX)) {
                String overrideName = name.substring(OVERRIDE_PREFIX.length());
                String value = props.getProperty(name);
                System.setProperty(overrideName, InterpolationHelper.substVars((String)value, (String)name, null, (Map)props, (InterpolationHelper.SubstitutionCallback)callback));
                continue;
            }
            String value = System.getProperty(name, props.getProperty(name));
            System.setProperty(name, InterpolationHelper.substVars((String)value, (String)name, null, (Map)props, (InterpolationHelper.SubstitutionCallback)callback));
        }
    }

    public static void copySystemProperties(Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.startsWith("karaf.") && !key.startsWith("org.osgi.framework.")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }

    public static Properties loadPropertiesOrFail(File configFile) {
        try {
            URL configPropURL = configFile.toURI().toURL();
            return PropertiesLoader.loadPropertiesFile(configPropURL, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading properties from " + configFile, e);
        }
    }

    public static Properties loadPropertiesFile(URL configPropURL, boolean failIfNotFound) throws Exception {
        Properties configProps = new Properties(null, false);
        try {
            configProps.load(configPropURL);
        }
        catch (FileNotFoundException ex) {
            if (failIfNotFound) {
                throw ex;
            }
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            return configProps;
        }
        PropertiesLoader.loadIncludes(INCLUDES_PROPERTY, true, configPropURL, configProps);
        PropertiesLoader.loadIncludes(OPTIONALS_PROPERTY, false, configPropURL, configProps);
        PropertiesLoader.trimValues(configProps);
        return configProps;
    }

    private static void loadIncludes(String propertyName, boolean mandatory, URL configPropURL, Properties configProps) throws Exception {
        StringTokenizer st;
        String includes = (String)configProps.get((Object)propertyName);
        if (includes != null && (st = new StringTokenizer(includes, "\" ", true)).countTokens() > 0) {
            String location;
            do {
                if ((location = PropertiesLoader.nextLocation(st)) == null) continue;
                URL url = new URL(configPropURL, location);
                Properties props = PropertiesLoader.loadPropertiesFile(url, mandatory);
                configProps.putAll((Map)props);
            } while (location != null);
        }
        configProps.remove((Object)propertyName);
    }

    private static void trimValues(Properties configProps) {
        for (String key : configProps.keySet()) {
            configProps.put(key, ((String)configProps.get((Object)key)).trim());
        }
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuilder tokBuf = new StringBuilder(10);
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            block8: while (st.hasMoreTokens() && !exit) {
                String tok;
                switch (tok = st.nextToken(tokenList)) {
                    case "\"": {
                        boolean bl = inQuote = !inQuote;
                        if (inQuote) {
                            tokenList = "\"";
                            continue block8;
                        }
                        tokenList = "\" ";
                        continue block8;
                    }
                    case " ": {
                        if (!tokStarted) continue block8;
                        retVal = tokBuf.toString();
                        tokStarted = false;
                        tokBuf = new StringBuilder(10);
                        exit = true;
                        continue block8;
                    }
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    private static String lookupVirtualProperty(Properties properties, Object key) {
        String keyString = String.valueOf(key);
        if (keyString.startsWith("jre-")) {
            String versionString = keyString.substring("jre-".length());
            Integer versionInt = PropertiesLoader.toJavaIntVersion(properties, versionString);
            if (versionInt == null) {
                return null;
            }
            for (int i = versionInt - 1; i >= 9; --i) {
                String testedKey = "jre-" + i;
                String otherValue = properties.getProperty(testedKey);
                if (otherValue == null) continue;
                return otherValue;
            }
        } else if (keyString.startsWith("eecap-")) {
            String versionString = keyString.substring("eecap-".length());
            Integer versionInt = PropertiesLoader.toJavaIntVersion(properties, versionString);
            if (versionInt == null) {
                return null;
            }
            String tenToLastVersion = IntStream.rangeClosed(10, versionInt).boxed().map(Object::toString).collect(Collectors.joining(",", ",", ""));
            return "osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"1.0,1.1,1.2\",osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0,1.1,1.2,1.3,1.4,1.5,1.6,1.7,1.8,9" + tenToLastVersion + "\",osgi.ee; osgi.ee=\"JavaSE/compact1\"; version:List<Version>=\"1.8,9" + tenToLastVersion + "\",osgi.ee; osgi.ee=\"JavaSE/compact2\"; version:List<Version>=\"1.8,9" + tenToLastVersion + "\",osgi.ee; osgi.ee=\"JavaSE/compact3\"; version:List<Version>=\"1.8,9" + tenToLastVersion + "\"";
        }
        return null;
    }

    private static Integer toJavaIntVersion(Properties properties, String versionString) {
        int versionInt;
        String forcedVersion = properties.getProperty("java.specification.version");
        if (forcedVersion != null && !forcedVersion.equals(versionString)) {
            return null;
        }
        try {
            versionInt = Integer.parseInt(versionString);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (versionInt < 9) {
            return null;
        }
        return versionInt;
    }
}

