/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.karaf.main.util.BootstrapLogManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.launch.Framework;

public class KarafActivatorManager {
    public static final String KARAF_ACTIVATOR = "Karaf-Activator";
    Logger LOG = Logger.getLogger(this.getClass().getName());
    private List<BundleActivator> karafActivators = new ArrayList<BundleActivator>();
    private final ClassLoader classLoader;
    private final Framework framework;

    public KarafActivatorManager(ClassLoader classLoader, Framework framework) {
        this.classLoader = classLoader;
        this.framework = framework;
        try {
            this.LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startKarafActivators() throws IOException {
        Enumeration<URL> urls = this.classLoader.getResources("META-INF/MANIFEST.MF");
        while (urls != null && urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String className = null;
            InputStream is = url.openStream();
            try {
                Manifest mf = new Manifest(is);
                className = mf.getMainAttributes().getValue(KARAF_ACTIVATOR);
                if (className == null) continue;
                BundleActivator activator = (BundleActivator)this.classLoader.loadClass(className).newInstance();
                activator.start(this.framework.getBundleContext());
                this.karafActivators.add(activator);
            }
            catch (Throwable e) {
                if (className == null) continue;
                System.err.println("Error starting karaf activator " + className + ": " + e.getMessage());
                this.LOG.log(Level.WARNING, "Error starting karaf activator " + className + " from url " + url, e);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException mf) {}
            }
        }
    }

    void stopKarafActivators() {
        for (BundleActivator activator : this.karafActivators) {
            try {
                activator.stop(this.framework.getBundleContext());
            }
            catch (Throwable e) {
                this.LOG.log(Level.WARNING, "Error stopping karaf activator " + activator.getClass().getName(), e);
            }
        }
    }
}

