/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientConfig {
    private static final String ROLE_DELIMITER = ",";
    private static final String GROUP_PREFIX = "_g_:";
    private String host;
    private int port;
    private String user;
    private String password;
    private int level;
    private int retryAttempts;
    private int retryDelay;
    private long idleTimeout;
    private boolean batch;
    private String file = null;
    private String keyFile = null;
    private String command;
    private boolean interactiveMode = false;

    public ClientConfig(String[] args) throws IOException {
        Properties shellCfg = ClientConfig.loadProps(new File(System.getProperty("karaf.etc"), "org.apache.karaf.shell.cfg"), null);
        Properties customCfg = ClientConfig.loadProps(new File(System.getProperty("karaf.etc"), "custom.properties"), null);
        this.host = shellCfg.getProperty("sshHost", "localhost");
        this.host = ClientConfig.expandEnvVars(this.host);
        String portString = shellCfg.getProperty("sshPort", "8101");
        portString = ClientConfig.expandEnvVars(portString);
        if (this.host.contains("${")) {
            this.host = ClientConfig.replaceVariable(this.host, "localhost", customCfg);
        }
        if (this.host.contains("0.0.0.0")) {
            this.host = "localhost";
        }
        if (portString.contains("${")) {
            portString = ClientConfig.replaceVariable(portString, "8101", customCfg);
        }
        this.port = Integer.parseInt(portString);
        this.level = Integer.parseInt(shellCfg.getProperty("logLevel", "0"));
        this.retryAttempts = 0;
        this.retryDelay = 2;
        this.idleTimeout = Long.parseLong(shellCfg.getProperty("sshIdleTimeout", "1800000"));
        this.batch = false;
        this.file = null;
        this.user = null;
        this.password = null;
        StringBuilder commandBuilder = new StringBuilder();
        boolean endOfOptionsMarkerReached = false;
        for (int i = 0; i < args.length; ++i) {
            if (!endOfOptionsMarkerReached && args[i].charAt(0) == '-') {
                if (args[i].equals("-a")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the port");
                        System.exit(1);
                        continue;
                    }
                    this.port = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the host");
                        System.exit(1);
                        continue;
                    }
                    this.host = args[i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the user");
                        System.exit(1);
                        continue;
                    }
                    this.user = args[i];
                    this.interactiveMode = true;
                    this.password = null;
                    continue;
                }
                if (args[i].equals("-v")) {
                    ++this.level;
                    continue;
                }
                if (args[i].equals("-l")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the log level");
                        System.exit(1);
                        continue;
                    }
                    int levelValue = Integer.parseInt(args[i]);
                    if (levelValue < 0 || levelValue > 4) {
                        System.err.println("log level can only be 0, 1, 2, 3, or 4");
                        System.exit(1);
                        continue;
                    }
                    this.level = levelValue;
                    continue;
                }
                if (args[i].equals("-r")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the attempts");
                        System.exit(1);
                        continue;
                    }
                    this.retryAttempts = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-d")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the delay in seconds");
                        System.exit(1);
                        continue;
                    }
                    this.retryDelay = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-b")) {
                    this.batch = true;
                    continue;
                }
                if (args[i].equals("-f")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the commands file");
                        System.exit(1);
                        continue;
                    }
                    this.file = args[i];
                    continue;
                }
                if (args[i].equals("-k")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the key file");
                        System.exit(1);
                        continue;
                    }
                    this.keyFile = args[i];
                    continue;
                }
                if (args[i].equals("-t")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the idle timeout");
                        System.exit(1);
                        continue;
                    }
                    this.idleTimeout = Long.parseLong(args[i]);
                    continue;
                }
                if (args[i].equals("--help")) {
                    ClientConfig.showHelp();
                    continue;
                }
                if (args[i].equals("--")) {
                    endOfOptionsMarkerReached = true;
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.err.println("Run with --help for usage");
                System.exit(1);
                continue;
            }
            commandBuilder.append(args[i]);
            commandBuilder.append(' ');
        }
        this.command = commandBuilder.toString();
        LinkedHashMap<String, String> usersCfg = new LinkedHashMap<String, String>();
        ClientConfig.loadProps(new File(System.getProperty("karaf.etc") + "/users.properties"), usersCfg);
        if (!usersCfg.isEmpty()) {
            LinkedHashSet<String> users = new LinkedHashSet<String>();
            for (String user : usersCfg.keySet()) {
                if (user.startsWith(GROUP_PREFIX)) continue;
                users.add(user);
            }
            if (this.user == null && users.iterator().hasNext()) {
                this.user = (String)users.iterator().next();
            }
            if (this.interactiveMode) {
                this.password = null;
            } else {
                this.password = (String)usersCfg.get(this.user);
                if (this.password != null && this.password.contains(ROLE_DELIMITER)) {
                    this.password = this.password.substring(0, this.password.indexOf(ROLE_DELIMITER));
                }
            }
        }
    }

    private static void showHelp() {
        System.out.println("Apache Karaf client");
        System.out.println("  -a [port]     specify the port to connect to");
        System.out.println("  -h [host]     specify the host to connect to");
        System.out.println("  -u [user]     specify the user name");
        System.out.println("  --help        shows this help message");
        System.out.println("  -v            raise verbosity");
        System.out.println("  -l            set client logging level. Set to 0 for ERROR logging and up to 4 for TRACE");
        System.out.println("  -r [attempts] retry connection establishment (up to attempts times)");
        System.out.println("  -d [delay]    intra-retry delay (defaults to 2 seconds)");
        System.out.println("  -b            batch mode, specify multiple commands via standard input");
        System.out.println("  -f [file]     read commands from the specified file");
        System.out.println("  -k [keyFile]  specify the private keyFile location when using key login, need have BouncyCastle registered as security provider using this flag");
        System.out.println("  -t [timeout]  define the client idle timeout");
        System.out.println("  [commands] [--]   commands to run");
        System.out.println("If no commands are specified, the client will be put in an interactive mode");
        System.exit(0);
    }

    private static String replaceVariable(String input, String defaultValue, Properties customCfg) {
        try {
            int indexOfDollar = input.indexOf(36);
            int indexOfClosingBrace = input.indexOf(125, indexOfDollar + 1);
            String varName = input.substring(indexOfDollar + 2, indexOfClosingBrace);
            String varValue = customCfg.getProperty(varName, defaultValue);
            return input.replace("${" + varName + "}", varValue);
        }
        catch (Exception e) {
            return input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProps(File file, final Map<String, String> additionalStorage) {
        Properties props = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                if (additionalStorage != null) {
                    additionalStorage.put((String)key, (String)value);
                }
                return super.put(key, value);
            }
        };
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            props.load(is);
        }
        catch (Exception e) {
            System.err.println("Warning: could not load properties from: " + file + ", Reason: " + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    private static String expandEnvVars(String text) {
        Map<String, String> envMap = System.getenv();
        String pattern = "\\$\\{([A-Za-z0-9]+)\\}";
        Pattern expr = Pattern.compile(pattern);
        Matcher matcher = expr.matcher(text);
        while (matcher.find()) {
            String envValue = envMap.get(matcher.group(1).toUpperCase());
            if (envValue == null) continue;
            envValue = envValue.replace("\\", "\\\\");
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            text = subexpr.matcher(text).replaceAll(envValue);
        }
        return text;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getLevel() {
        return this.level;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public String getFile() {
        return this.file;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }
}

