/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.mbean.simple;

import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.examples.mbean.api.Booking;
import org.apache.karaf.examples.mbean.api.BookingService;
import org.apache.karaf.examples.mbean.simple.BookingMBean;

public class BookingMBeanImpl
extends StandardMBean
implements BookingMBean {
    private BookingService bookingService;

    public BookingMBeanImpl() throws NotCompliantMBeanException {
        super(BookingMBean.class);
    }

    @Override
    public TabularData getBookings() throws MBeanException {
        try {
            CompositeType bookingType = new CompositeType("booking", "Booking", new String[]{"id", "flight", "customer"}, new String[]{"ID", "Flight", "Customer"}, new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING});
            TabularType tabularType = new TabularType("bookings", "Bookings", bookingType, new String[]{"id"});
            TabularDataSupport tabularData = new TabularDataSupport(tabularType);
            for (Booking booking : this.bookingService.list()) {
                CompositeDataSupport compositeData = new CompositeDataSupport(bookingType, new String[]{"id", "flight", "customer"}, new Object[]{booking.getId(), booking.getFlight(), booking.getCustomer()});
                tabularData.put(compositeData);
            }
            return tabularData;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void add(long id, String flight, String customer) throws MBeanException {
        Booking booking = new Booking();
        booking.setId(Long.valueOf(id));
        booking.setFlight(flight);
        booking.setCustomer(customer);
        this.bookingService.add(booking);
    }

    @Override
    public void remove(long id) throws MBeanException {
        this.bookingService.remove(Long.valueOf(id));
    }

    public BookingService getBookingService() {
        return this.bookingService;
    }

    public void setBookingService(BookingService bookingService) {
        this.bookingService = bookingService;
    }
}

