/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.jms.command;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Service
@Command(scope="example", name="consume", description="Consume a message from a JMS queue")
public class ConsumeCommand
implements Action {
    @Argument(index=0, name="queue", description="Name of the queue", required=true, multiValued=false)
    String queue;
    @Reference
    ConnectionFactory connectionFactory;

    public Object execute() throws Exception {
        Connection connection = this.connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(this.queue);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        TextMessage message = (TextMessage)consumer.receive(60000L);
        if (message == null) {
            throw new IllegalStateException("No message received");
        }
        System.out.println(message.getText());
        return null;
    }
}

