/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.util.StreamUtils;
import org.apache.karaf.util.filesstream.FilesStream;
import org.apache.karaf.util.jaas.JaasHelper;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellCommand
implements Command {
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String EXEC_INIT_SCRIPT = "karaf.exec.init.script";
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellCommand.class);
    private static final Class[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private ServerSession session;
    private SessionFactory sessionFactory;
    private Environment env;

    public ShellCommand(SessionFactory sessionFactory, String command) {
        this.sessionFactory = sessionFactory;
        this.command = command;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(ChannelSession channelSession, Environment environment) throws IOException {
        this.session = channelSession.getServerSession();
        this.env = environment;
        new Thread(this::run).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int exitStatus = 0;
        try {
            Session session = this.sessionFactory.create(this.in, new PrintStream(this.out), new PrintStream(this.err));
            for (Map.Entry e : this.env.getEnv().entrySet()) {
                session.put((String)e.getKey(), e.getValue());
            }
            try {
                Object result;
                Subject subject;
                Subject subject2 = subject = this.session != null ? (Subject)this.session.getAttribute(KarafJaasAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                if (subject != null) {
                    try {
                        result = JaasHelper.doAs(subject, () -> {
                            String scriptFileName = System.getProperty(EXEC_INIT_SCRIPT);
                            if (scriptFileName == null) {
                                scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
                            }
                            this.executeScript(scriptFileName, session);
                            return session.execute((CharSequence)this.command);
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                } else {
                    String scriptFileName = System.getProperty(EXEC_INIT_SCRIPT);
                    if (scriptFileName == null) {
                        scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
                    }
                    this.executeScript(scriptFileName, session);
                    result = session.execute((CharSequence)this.command);
                }
                if (result != null && result instanceof Integer) {
                    exitStatus = (Integer)result;
                }
            }
            catch (Throwable t) {
                exitStatus = 1;
                ShellUtil.logException((Session)session, (Throwable)t);
            }
        }
        catch (Exception e) {
            try {
                exitStatus = 1;
                LOGGER.error("Unable to start shell", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.callback.onExit(exitStatus);
                StreamUtils.close(this.in, this.out, this.err);
                throw throwable;
            }
            this.callback.onExit(exitStatus);
            StreamUtils.close(this.in, this.out, this.err);
        }
        this.callback.onExit(exitStatus);
        StreamUtils.close(this.in, this.out, this.err);
    }

    public void destroy(ChannelSession channelSession) throws Exception {
    }

    private void executeScript(String names, Session session) {
        FilesStream.stream(names).forEach(p -> this.doExecuteScript(session, (Path)p));
    }

    private void doExecuteScript(Session session, Path scriptFileName) {
        block2: {
            try {
                String script = String.join((CharSequence)"\n", Files.readAllLines(scriptFileName));
                session.execute((CharSequence)script);
            }
            catch (Exception e) {
                LOGGER.debug("Error in initialization script {}", (Object)scriptFileName, (Object)e);
                if (e instanceof InterruptedException) break block2;
                System.err.println("Error in initialization script: " + scriptFileName + ": " + e.getMessage());
            }
        }
    }
}

