/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.instance.core.Instance;
import org.apache.karaf.instance.core.InstanceService;
import org.apache.karaf.instance.core.InstanceSettings;
import org.apache.karaf.instance.core.internal.InstanceImpl;
import org.apache.karaf.instance.main.Execute;
import org.apache.karaf.jpm.Process;
import org.apache.karaf.jpm.impl.ProcessBuilderFactoryImpl;
import org.apache.karaf.jpm.impl.ScriptUtils;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.apache.karaf.util.StreamUtils;
import org.apache.karaf.util.config.PropertiesLoader;
import org.apache.karaf.util.locks.FileLockUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceServiceImpl
implements InstanceService {
    public static final String STORAGE_FILE = "instance.properties";
    public static final String BACKUP_EXTENSION = ".bak";
    private static final String FEATURES_CFG = "etc/org.apache.karaf.features.cfg";
    private static final String RESOURCE_BASE = "org/apache/karaf/instance/resources/";
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceServiceImpl.class);
    private static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    private static final String KARAF_SHUTDOWN_PORT = "karaf.shutdown.port";
    private static final String KARAF_SHUTDOWN_HOST = "karaf.shutdown.host";
    private static final String KARAF_SHUTDOWN_PORT_FILE = "karaf.shutdown.port.file";
    private static final String KARAF_SHUTDOWN_COMMAND = "karaf.shutdown.command";
    private static final String KARAF_SHUTDOWN_TIMEOUT = "karaf.shutdown.timeout";
    private static final String DEFAULT_SHUTDOWN_COMMAND = "SHUTDOWN";
    public static final String DEFAULT_JAVA_OPTS = "-Xmx512M -Dcom.sun.management.jmxremote -XX:+UnlockDiagnosticVMOptions";
    private LinkedHashMap<String, InstanceImpl> proxies = new LinkedHashMap();
    private File storageLocation;
    private long stopTimeout = 30000L;

    public InstanceServiceImpl() {
        String prop = System.getProperty("karaf.instances");
        if (prop != null) {
            this.storageLocation = new File(prop);
        }
    }

    public File getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(File storage) {
        this.storageLocation = storage;
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(long stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    private State loadData(Properties storage) {
        State state = new State();
        int count = InstanceServiceImpl.getInt(storage, "count", 0);
        state.defaultSshPortStart = InstanceServiceImpl.getInt(storage, "ssh.port", state.defaultSshPortStart);
        state.defaultRmiRegistryPortStart = InstanceServiceImpl.getInt(storage, "rmi.registry.port", state.defaultRmiRegistryPortStart);
        state.defaultRmiServerPortStart = InstanceServiceImpl.getInt(storage, "rmi.server.port", state.defaultRmiServerPortStart);
        state.instances = new LinkedHashMap<String, InstanceState>();
        for (int i = 0; i < count; ++i) {
            InstanceState instance = new InstanceState();
            instance.name = InstanceServiceImpl.getString(storage, "item." + i + ".name", null);
            instance.loc = InstanceServiceImpl.getString(storage, "item." + i + ".loc", null);
            instance.opts = InstanceServiceImpl.getString(storage, "item." + i + ".opts", null);
            instance.pid = InstanceServiceImpl.getInt(storage, "item." + i + ".pid", 0);
            instance.root = InstanceServiceImpl.getBool(storage, "item." + i + ".root", false);
            state.instances.put(instance.name, instance);
        }
        for (InstanceState instance : state.instances.values()) {
            if (this.proxies.containsKey(instance.name)) continue;
            this.proxies.put(instance.name, new InstanceImpl(this, instance.name));
        }
        ArrayList<String> names = new ArrayList<String>(this.proxies.keySet());
        for (String name : names) {
            if (state.instances.containsKey(name)) continue;
            this.proxies.remove(name);
        }
        return state;
    }

    private void saveData(State state, Properties storage) {
        storage.put("ssh.port", Integer.toString(state.defaultSshPortStart));
        storage.put("rmi.registry.port", Integer.toString(state.defaultRmiRegistryPortStart));
        storage.put("rmi.server.port", Integer.toString(state.defaultRmiServerPortStart));
        storage.put("count", Integer.toString(state.instances.size()));
        int i = 0;
        for (InstanceState instance : state.instances.values()) {
            storage.put("item." + i + ".name", instance.name);
            storage.put("item." + i + ".root", Boolean.toString(instance.root));
            storage.put("item." + i + ".loc", instance.loc);
            storage.put("item." + i + ".pid", Integer.toString(instance.pid));
            storage.put("item." + i + ".opts", instance.opts != null ? instance.opts : "");
            ++i;
        }
        while (storage.containsKey("item." + i + ".name")) {
            storage.remove("item." + i + ".name");
            storage.remove("item." + i + ".root");
            storage.remove("item." + i + ".loc");
            storage.remove("item." + i + ".pid");
            storage.remove("item." + i + ".opts");
            ++i;
        }
    }

    private static boolean getBool(Properties storage, String name, boolean def) {
        Object value = storage.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return def;
    }

    private static int getInt(Properties storage, String name, int def) {
        Object value = storage.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            return Integer.parseInt(value.toString());
        }
        return def;
    }

    private static String getString(Properties storage, String name, String def) {
        Object value = storage.get(name);
        return value != null ? value.toString() : def;
    }

    synchronized <T> T execute(Task<State, T> callback, boolean writeToFile) {
        File storageFile = new File(this.storageLocation, STORAGE_FILE);
        if (!storageFile.exists()) {
            storageFile.getParentFile().mkdirs();
            try {
                storageFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (storageFile.exists()) {
            if (!storageFile.isFile()) {
                throw new IllegalStateException("Instance storage location should be a file: " + storageFile);
            }
            try {
                return (T)FileLockUtils.execute(storageFile, properties -> {
                    State state = this.loadData((Properties)properties);
                    Object t = callback.call(state);
                    if (writeToFile) {
                        this.saveData(state, (Properties)properties);
                    }
                    return t;
                }, writeToFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Instance storage location does not exist: " + storageFile);
    }

    private static void logInfo(String message, boolean printOutput, Object ... args) {
        if (LOGGER.isInfoEnabled() || printOutput) {
            String formatted = String.format(message, args);
            LOGGER.info(formatted);
            if (printOutput) {
                InstanceServiceImpl.println(formatted);
            }
        }
    }

    private static void logDebug(String message, boolean printOutput, Object ... args) {
        if (LOGGER.isDebugEnabled() || printOutput) {
            String formatted = String.format(message, args);
            LOGGER.debug(formatted);
            if (printOutput) {
                InstanceServiceImpl.println(formatted);
            }
        }
    }

    @Override
    public synchronized Instance createInstance(String name, InstanceSettings settings, boolean printOutput) throws Exception {
        return this.execute(state -> {
            String javaOpts;
            int rmiServerPort;
            int sshPort;
            String loc;
            File karafBase;
            if (state.instances.get(name) != null) {
                throw new IllegalArgumentException("Instance '" + name + "' already exists");
            }
            if (!settings.getProfiles().isEmpty()) {
                try {
                    ProfileApplier.verify();
                }
                catch (NoClassDefFoundError error) {
                    throw new IllegalArgumentException("Profile service package is not available");
                }
            }
            if (!(karafBase = new File(loc = settings.getLocation() != null ? settings.getLocation() : name)).isAbsolute()) {
                karafBase = new File(this.storageLocation, loc);
            }
            if ((sshPort = settings.getSshPort()) <= 0) {
                sshPort = ++state.defaultSshPortStart;
            }
            String sshHost = settings.getAddress();
            int rmiRegistryPort = settings.getRmiRegistryPort();
            if (rmiRegistryPort <= 0) {
                rmiRegistryPort = ++state.defaultRmiRegistryPortStart;
            }
            if ((rmiServerPort = settings.getRmiServerPort()) <= 0) {
                rmiServerPort = ++state.defaultRmiServerPortStart;
            }
            InstanceServiceImpl.logInfo("Creating new instance on SSH port %d and registry port %d / RMI server port %d at: %s", printOutput, sshPort, rmiRegistryPort, rmiServerPort, karafBase);
            this.mkdir(karafBase, "bin", printOutput);
            this.mkdir(karafBase, "etc", printOutput);
            this.mkdir(karafBase, "etc/scripts", printOutput);
            this.mkdir(karafBase, "system", printOutput);
            this.mkdir(karafBase, "deploy", printOutput);
            this.mkdir(karafBase, "data", printOutput);
            HashMap<String, URL> textResources = new HashMap<String, URL>(settings.getTextResources());
            HashMap<String, URL> binaryResources = new HashMap<String, URL>(settings.getBinaryResources());
            String[] resources = new String[]{"etc/all.policy", "etc/config.properties", "etc/custom.properties", "etc/distribution.info", "etc/equinox-debug.properties", "etc/java.util.logging.properties", "etc/jmx.acl.cfg", "etc/jmx.acl.java.lang.Memory.cfg", "etc/jmx.acl.org.apache.karaf.bundle.cfg", "etc/jmx.acl.org.apache.karaf.config.cfg", "etc/jmx.acl.org.apache.karaf.security.jmx.cfg", "etc/jmx.acl.osgi.compendium.cm.cfg", "etc/jre.properties", "etc/keys.properties", "etc/org.apache.felix.eventadmin.impl.EventAdmin.cfg", "etc/org.apache.felix.fileinstall-deploy.cfg", "etc/org.apache.karaf.command.acl.bundle.cfg", "etc/org.apache.karaf.command.acl.config.cfg", "etc/org.apache.karaf.command.acl.feature.cfg", "etc/org.apache.karaf.command.acl.jaas.cfg", "etc/org.apache.karaf.command.acl.kar.cfg", "etc/org.apache.karaf.command.acl.scope_bundle.cfg", "etc/org.apache.karaf.command.acl.shell.cfg", "etc/org.apache.karaf.command.acl.system.cfg", "etc/org.apache.karaf.features.repos.cfg", "etc/org.apache.karaf.jaas.cfg", "etc/org.apache.karaf.kar.cfg", "etc/org.apache.karaf.log.cfg", "etc/org.ops4j.pax.logging.cfg", "etc/org.ops4j.pax.url.mvn.cfg", "etc/shell.init.script", "etc/users.properties", "etc/scripts/shell.completion.script", FEATURES_CFG};
            this.copyResourcesToDir(resources, karafBase, textResources, printOutput);
            this.addFeaturesFromSettings(new File(karafBase, FEATURES_CFG), settings);
            File rootEtc = new File(System.getProperty("karaf.etc"));
            this.copy(new File(rootEtc, "startup.properties"), new File(karafBase, "etc/startup.properties"));
            File rootOverrides = new File(rootEtc, "overrides.properties");
            if (rootOverrides.exists()) {
                this.copy(rootOverrides, new File(karafBase, "etc/overrides.properties"));
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("${SUBST-KARAF-NAME}", name);
            props.put("${SUBST-KARAF-HOME}", System.getProperty("karaf.home"));
            props.put("${SUBST-KARAF-BASE}", karafBase.getPath());
            props.put("${SUBST-SSH-PORT}", Integer.toString(sshPort));
            props.put("${SUBST-SSH-HOST}", sshHost);
            props.put("${SUBST-RMI-REGISTRY-PORT}", Integer.toString(rmiRegistryPort));
            props.put("${SUBST-RMI-SERVER-PORT}", Integer.toString(rmiServerPort));
            String[] filteredResources = new String[]{"etc/system.properties", "etc/org.apache.karaf.shell.cfg", "etc/org.apache.karaf.management.cfg", "bin/karaf", "bin/start", "bin/stop", "bin/karaf.bat", "bin/start.bat", "bin/stop.bat"};
            this.copyFilteredResourcesToDir(filteredResources, karafBase, textResources, props, printOutput);
            try {
                this.makeFileExecutable(new File(karafBase, "bin/karaf"));
                this.makeFileExecutable(new File(karafBase, "bin/start"));
                this.makeFileExecutable(new File(karafBase, "bin/stop"));
            }
            catch (IOException e) {
                LOGGER.debug("Could not set file mode on scripts.", (Throwable)e);
            }
            for (String resource : textResources.keySet()) {
                this.copyFilteredResourceToDir(resource, karafBase, textResources, props, printOutput);
            }
            for (String resource : binaryResources.keySet()) {
                this.copyBinaryResourceToDir(resource, karafBase, binaryResources, printOutput);
            }
            if (!settings.getProfiles().isEmpty()) {
                ProfileApplier.applyProfiles(karafBase, settings.getProfiles(), printOutput);
            }
            if ((javaOpts = settings.getJavaOpts()) == null || javaOpts.length() == 0) {
                javaOpts = DEFAULT_JAVA_OPTS;
            }
            InstanceState is = new InstanceState();
            is.name = name;
            is.loc = karafBase.toString();
            is.opts = javaOpts;
            state.instances.put(name, is);
            InstanceImpl instance = new InstanceImpl(this, name);
            this.proxies.put(name, instance);
            return instance;
        }, true);
    }

    void addFeaturesFromSettings(File featuresCfg, InstanceSettings settings) throws IOException {
        FileLockUtils.execute(featuresCfg, properties -> {
            InstanceServiceImpl.appendToPropList(properties, "featuresBoot", settings.getFeatures());
            InstanceServiceImpl.appendToPropList(properties, "featuresRepositories", settings.getFeatureURLs());
        }, true);
    }

    private static void appendToPropList(Properties p, String key, List<String> elements) {
        if (elements == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(((String)p.get(key)).trim());
        for (String f : elements) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f);
        }
        p.put(key, sb.toString());
    }

    @Override
    public Instance[] getInstances() {
        return this.execute(state -> this.proxies.values().toArray(new Instance[this.proxies.size()]), false);
    }

    @Override
    public Instance getInstance(String name) {
        return this.execute(state -> this.proxies.get(name), false);
    }

    public void startInstance(String name, String javaOpts) {
        this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            this.checkPid(instance);
            if (instance.pid != 0) {
                throw new IllegalStateException("Instance already started");
            }
            this.doStart(instance, name, javaOpts);
            return null;
        }, true);
    }

    private void doStart(InstanceState instance, String name, String javaOpts) throws IOException {
        String jdkOpts;
        String karafOptsEnv;
        String opts = javaOpts;
        if (opts == null || opts.length() == 0) {
            opts = instance.opts;
        }
        if (opts == null || opts.length() == 0) {
            opts = DEFAULT_JAVA_OPTS;
        }
        String karafOpts = System.getProperty("karaf.opts", (karafOptsEnv = System.getenv("KARAF_OPTS")) != null ? karafOptsEnv : "");
        String location = instance.loc;
        File libDir = new File(System.getProperty("karaf.home"), "lib");
        File bootLibDir = new File(libDir, "boot");
        File childLibDir = new File(location, "lib");
        StringBuilder classpath = this.classpathFromLibDir(bootLibDir);
        StringBuilder childClasspath = this.classpathFromLibDir(childLibDir);
        if (childClasspath.length() > 0 && !bootLibDir.equals(childLibDir)) {
            classpath.append(System.getProperty("path.separator"));
            classpath.append((CharSequence)childClasspath);
        }
        if (!System.getProperty("java.version").startsWith("1.")) {
            StringBuilder jdk9Classpath = this.classpathFromLibDir(new File(new File(System.getProperty("karaf.home"), "lib"), "jdk9plus"));
            if (jdk9Classpath.length() > 0) {
                classpath.append(System.getProperty("path.separator"));
                classpath.append((CharSequence)jdk9Classpath);
            }
            jdkOpts = " --add-reads=java.xml=java.logging --add-exports=java.base/org.apache.karaf.specs.locator=java.xml,ALL-UNNAMED --patch-module java.base=lib/endorsed/org.apache.karaf.specs.locator-" + System.getProperty("karaf.version") + ".jar --patch-module java.xml=lib/endorsed/org.apache.karaf.specs.java.xml-" + System.getProperty("karaf.version") + ".jar --add-opens java.base/java.security=ALL-UNNAMED --add-opens java.base/java.net=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.naming/javax.naming.spi=ALL-UNNAMED --add-opens java.rmi/sun.rmi.transport.tcp=ALL-UNNAMED --add-exports=java.base/sun.net.www.protocol.file=ALL-UNNAMED --add-exports=java.base/sun.net.www.protocol.ftp=ALL-UNNAMED --add-exports=java.base/sun.net.www.protocol.http=ALL-UNNAMED --add-exports=java.base/sun.net.www.protocol.https=ALL-UNNAMED --add-exports=java.base/sun.net.www.protocol.jar=ALL-UNNAMED --add-exports=java.base/sun.net.www.content.text=ALL-UNNAMED --add-exports=jdk.xml.dom/org.w3c.dom.html=ALL-UNNAMED --add-exports=jdk.naming.rmi/com.sun.jndi.url.rmi=ALL-UNNAMED";
        } else {
            jdkOpts = " -Djava.endorsed.dirs=\"" + new File(new File(new File(System.getProperty("java.home"), "jre"), "lib"), "endorsed") + System.getProperty("path.separator") + new File(new File(System.getProperty("java.home"), "lib"), "endorsed") + System.getProperty("path.separator") + new File(libDir, "endorsed").getCanonicalPath() + "\" -Djava.ext.dirs=\"" + new File(new File(new File(System.getProperty("java.home"), "jre"), "lib"), "ext") + System.getProperty("path.separator") + new File(new File(System.getProperty("java.home"), "lib"), "ext") + System.getProperty("path.separator") + new File(libDir, "ext").getCanonicalPath() + "\"";
        }
        String command = "\"" + new File(System.getProperty("java.home"), ScriptUtils.isWindows() ? "bin\\java.exe" : "bin/java").getCanonicalPath() + "\" " + opts + " " + karafOpts + " " + jdkOpts + " -Djava.util.logging.config.file=\"" + new File(location, "etc/java.util.logging.properties").getCanonicalPath() + "\" -Dkaraf.home=\"" + System.getProperty("karaf.home") + "\" -Dkaraf.base=\"" + new File(location).getCanonicalPath() + "\" -Dkaraf.data=\"" + new File(new File(location).getCanonicalPath(), "data") + "\" -Dkaraf.etc=\"" + new File(new File(location).getCanonicalPath(), "etc") + "\" -Dkaraf.log=\"" + new File(new File(new File(location).getCanonicalFile(), "data"), "log") + "\" -Djava.io.tmpdir=\"" + new File(new File(new File(location).getCanonicalFile(), "data"), "tmp") + "\" -Dkaraf.restart.jvm.supported=true -Dkaraf.startLocalConsole=false -Dkaraf.startRemoteShell=true -classpath \"" + classpath.toString() + "\" org.apache.karaf.main.Main server";
        if (System.getenv("KARAF_REDIRECT") != null && !System.getenv("KARAF_REDIRECT").isEmpty()) {
            command = command + " >> " + System.getenv("KARAF_REDIRECT");
        }
        LOGGER.debug("Starting instance " + name + " with command: " + command);
        Process process = new ProcessBuilderFactoryImpl().newBuilder().directory(new File(location)).command(command).start();
        instance.pid = process.getPid();
    }

    private StringBuilder classpathFromLibDir(File libDir) throws IOException {
        File[] jars = libDir.listFiles((dir, name) -> name.endsWith(".jar"));
        StringBuilder classpath = new StringBuilder();
        if (jars != null) {
            for (File jar : jars) {
                if (classpath.length() > 0) {
                    classpath.append(System.getProperty("path.separator"));
                }
                classpath.append(jar.getCanonicalPath());
            }
        }
        return classpath;
    }

    private void addJar(StringBuilder sb, String groupId, String artifactId) {
        File artifactDir = new File(System.getProperty("karaf.home") + File.separator + "system" + File.separator + groupId.replaceAll("\\.", File.separator) + File.separator + artifactId + File.separator);
        TreeMap<String, File> jars = new TreeMap<String, File>();
        String[] versions = artifactDir.list();
        if (versions != null) {
            for (String version : versions) {
                File jar = new File(artifactDir, version + File.separator + artifactId + "-" + version + ".jar");
                if (!jar.exists()) continue;
                jars.put(version, jar);
            }
        }
        if (jars.isEmpty()) {
            throw new IllegalStateException("Cound not find jar for " + groupId + "/" + artifactId);
        }
        if (sb.length() > 0) {
            sb.append(File.pathSeparator);
        }
        sb.append(((File)jars.lastEntry().getValue()).getAbsolutePath());
    }

    public void restartInstance(String name, String javaOpts) {
        this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            String current = System.getProperty("karaf.name");
            if (name.equals(current)) {
                String location = System.getProperty("karaf.home");
                StringBuilder classpath = new StringBuilder();
                this.addJar(classpath, "org.apache.karaf.instance", "org.apache.karaf.instance.core");
                this.addJar(classpath, "org.apache.karaf.shell", "org.apache.karaf.shell.core");
                this.addJar(classpath, "org.ops4j.pax.logging", "pax-logging-api");
                this.addJar(classpath, "jline", "jline");
                String command = "\"" + new File(System.getProperty("java.home"), ScriptUtils.isWindows() ? "bin\\java.exe" : "bin/java").getCanonicalPath() + "\"  -Djava.util.logging.config.file=\"" + new File(location, "etc/java.util.logging.properties").getCanonicalPath() + "\" -Dkaraf.home=\"" + System.getProperty("karaf.home") + "\" -Dkaraf.base=\"" + new File(location).getCanonicalPath() + "\" -Dkaraf.data=\"" + new File(new File(location).getCanonicalPath(), "data") + "\" -Dkaraf.etc=\"" + new File(new File(location).getCanonicalPath(), "etc") + "\" -Dkaraf.log=\"" + new File(new File(new File(location).getCanonicalFile(), "data"), "log") + "\" -Dkaraf.instances=\"" + System.getProperty("karaf.instances") + "\" -classpath \"" + classpath.toString() + "\" " + Execute.class.getName() + " restart --java-opts \"" + javaOpts + "\" " + name;
                new ProcessBuilderFactoryImpl().newBuilder().directory(new File(System.getProperty("karaf.home"))).command(command).start();
            } else {
                this.checkPid(instance);
                if (instance.pid != 0) {
                    this.cleanShutdown(instance);
                }
                this.doStart(instance, name, javaOpts);
            }
            return null;
        }, true);
    }

    public void stopInstance(String name) {
        Integer pid = this.execute(state -> {
            int rootInstancePID = 0;
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            this.checkPid(instance);
            if (instance.pid == 0) {
                throw new IllegalStateException("Instance already stopped");
            }
            this.cleanShutdown(instance);
            if (instance.pid > 0) {
                if (!instance.root) {
                    Process process = new ProcessBuilderFactoryImpl().newBuilder().attach(instance.pid);
                    process.destroy();
                } else {
                    rootInstancePID = instance.pid;
                }
                instance.pid = 0;
            }
            return rootInstancePID;
        }, true);
        if (pid != 0 && this.isInstanceRoot(name)) {
            try {
                Process process = new ProcessBuilderFactoryImpl().newBuilder().attach(pid);
                process.destroy();
            }
            catch (IOException e) {
                LOGGER.debug("Unable to cleanly shutdown root instance ", (Throwable)e);
            }
        }
    }

    public void destroyInstance(String name) {
        this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            this.checkPid(instance);
            if (instance.pid != 0) {
                throw new IllegalStateException("Instance not stopped");
            }
            this.deleteFile(new File(instance.loc));
            state.instances.remove(name);
            this.proxies.remove(name);
            return null;
        }, true);
    }

    @Override
    public void renameInstance(String oldName, String newName, boolean printOutput) throws Exception {
        this.execute(state -> {
            if (state.instances.get(newName) != null) {
                throw new IllegalArgumentException("Instance " + newName + " already exists");
            }
            InstanceState instance = state.instances.get(oldName);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + oldName + " not found");
            }
            if (instance.root) {
                throw new IllegalArgumentException("Root instance cannot be renamed");
            }
            this.checkPid(instance);
            if (instance.pid != 0) {
                throw new IllegalStateException("Instance not stopped");
            }
            InstanceServiceImpl.println("Renaming instance " + SimpleAnsi.INTENSITY_BOLD + oldName + SimpleAnsi.INTENSITY_NORMAL + " to " + SimpleAnsi.INTENSITY_BOLD + newName + SimpleAnsi.INTENSITY_NORMAL);
            String oldLocationPath = instance.loc;
            File oldLocation = new File(oldLocationPath);
            String basedir = oldLocation.getParent();
            File newLocation = new File(basedir, newName);
            oldLocation.renameTo(newLocation);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(oldName, newName);
            props.put(oldLocationPath, newLocation.getPath());
            this.filterResource(newLocation, "etc/system.properties", props);
            this.filterResource(newLocation, "bin/karaf", props);
            this.filterResource(newLocation, "bin/start", props);
            this.filterResource(newLocation, "bin/stop", props);
            this.filterResource(newLocation, "bin/karaf.bat", props);
            this.filterResource(newLocation, "bin/start.bat", props);
            this.filterResource(newLocation, "bin/stop.bat", props);
            instance.name = newName;
            instance.loc = newLocation.getPath();
            state.instances.put(newName, instance);
            state.instances.remove(oldName);
            InstanceImpl proxy = (InstanceImpl)this.proxies.remove(oldName);
            if (proxy == null) {
                proxy = new InstanceImpl(this, newName);
            } else {
                proxy.doSetName(newName);
            }
            this.proxies.put(newName, proxy);
            return null;
        }, true);
    }

    @Override
    public synchronized Instance cloneInstance(String name, String cloneName, InstanceSettings settings, boolean printOutput) throws Exception {
        int instanceSshPort = this.getInstanceSshPort(name);
        int instanceRmiRegistryPort = this.getInstanceRmiRegistryPort(name);
        int instanceRmiServerPort = this.getInstanceRmiServerPort(name);
        return this.execute(state -> {
            if (state.instances.get(cloneName) != null) {
                throw new IllegalArgumentException("Instance " + cloneName + " already exists");
            }
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            String cloneLocationPath = settings.getLocation() != null ? settings.getLocation() : cloneName;
            File cloneLocation = new File(cloneLocationPath);
            if (!cloneLocation.isAbsolute()) {
                cloneLocation = new File(this.storageLocation, cloneLocationPath);
            }
            String locationPath = instance.loc;
            File location = new File(locationPath);
            this.copy(location, cloneLocation);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(name, cloneName);
            props.put(locationPath, cloneLocationPath);
            if (settings.getSshPort() > 0) {
                props.put(Integer.toString(instanceSshPort), Integer.toString(settings.getSshPort()));
            }
            if (settings.getRmiRegistryPort() > 0) {
                props.put(Integer.toString(instanceRmiRegistryPort), Integer.toString(settings.getRmiRegistryPort()));
            }
            if (settings.getRmiServerPort() > 0) {
                props.put(Integer.toString(instanceRmiServerPort), Integer.toString(settings.getRmiServerPort()));
            }
            this.filterResource(cloneLocation, "etc/custom.properties", props);
            this.filterResource(cloneLocation, "etc/org.apache.karaf.management.cfg", props);
            this.filterResource(cloneLocation, "etc/org.apache.karaf.shell.cfg", props);
            this.filterResource(cloneLocation, "etc/system.properties", props);
            this.filterResource(cloneLocation, "bin/karaf", props);
            this.filterResource(cloneLocation, "bin/start", props);
            this.filterResource(cloneLocation, "bin/stop", props);
            this.filterResource(cloneLocation, "bin/karaf.bat", props);
            this.filterResource(cloneLocation, "bin/start.bat", props);
            this.filterResource(cloneLocation, "bin/stop.bat", props);
            String javaOpts = settings.getJavaOpts();
            if (javaOpts == null || javaOpts.length() == 0) {
                javaOpts = DEFAULT_JAVA_OPTS;
            }
            InstanceState is = new InstanceState();
            is.name = cloneName;
            is.loc = cloneLocation.toString();
            is.opts = javaOpts;
            state.instances.put(cloneName, is);
            InstanceImpl cloneInstance = new InstanceImpl(this, cloneName);
            this.proxies.put(cloneName, cloneInstance);
            return cloneInstance;
        }, true);
    }

    private void checkPid(InstanceState instance) throws IOException {
        Process process;
        if (instance.pid != 0 && !(process = new ProcessBuilderFactoryImpl().newBuilder().attach(instance.pid)).isRunning()) {
            instance.pid = 0;
        }
    }

    protected void cleanShutdown(InstanceState instance) {
        try {
            File file = new File(new File(instance.loc, "etc"), CONFIG_PROPERTIES_FILE_NAME);
            Properties props = PropertiesLoader.loadPropertiesFile(file.toURI().toURL(), false);
            props.put("karaf.base", new File(instance.loc).getCanonicalPath());
            props.put("karaf.home", System.getProperty("karaf.home"));
            props.put("karaf.data", new File(new File(instance.loc), "data").getCanonicalPath());
            props.put("karaf.etc", new File(new File(instance.loc), "etc").getCanonicalPath());
            props.put("karaf.log", new File(new File(new File(instance.loc), "data"), "log").getCanonicalPath());
            InterpolationHelper.performSubstitution(props, null, true, false, true);
            int port = Integer.parseInt(props.getProperty(KARAF_SHUTDOWN_PORT, "0"));
            String host = props.getProperty(KARAF_SHUTDOWN_HOST, "localhost");
            String portFile = props.getProperty(KARAF_SHUTDOWN_PORT_FILE);
            String shutdown = props.getProperty(KARAF_SHUTDOWN_COMMAND, DEFAULT_SHUTDOWN_COMMAND);
            if (port == 0 && portFile != null) {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(portFile)));){
                    String portStr = r.readLine();
                    port = Integer.parseInt(portStr);
                }
            }
            if (port > 0) {
                Socket s = new Socket(host, port);
                s.getOutputStream().write(shutdown.getBytes());
                s.close();
                long stopTimeout = Long.parseLong(props.getProperty(KARAF_SHUTDOWN_TIMEOUT, Long.toString(this.getStopTimeout())));
                long t = System.currentTimeMillis() + stopTimeout;
                do {
                    Thread.sleep(100L);
                    this.checkPid(instance);
                } while (System.currentTimeMillis() < t && instance.pid > 0);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unable to cleanly shutdown instance " + instance.name, (Throwable)e);
        }
    }

    int getInstanceSshPort(String name) {
        return this.getKarafPort(name, "etc/org.apache.karaf.shell.cfg", "sshPort");
    }

    void changeInstanceSshPort(String name, int port) throws Exception {
        this.setKarafPort(name, "etc/org.apache.karaf.shell.cfg", "sshPort", port);
    }

    String getInstanceSshHost(String name) {
        return this.getKarafHost(name, "etc/org.apache.karaf.shell.cfg", "sshHost");
    }

    int getInstanceRmiRegistryPort(String name) {
        return this.getKarafPort(name, "etc/org.apache.karaf.management.cfg", "rmiRegistryPort");
    }

    void changeInstanceRmiRegistryPort(String name, int port) throws Exception {
        this.setKarafPort(name, "etc/org.apache.karaf.management.cfg", "rmiRegistryPort", port);
    }

    String getInstanceRmiRegistryHost(String name) {
        return this.getKarafHost(name, "etc/org.apache.karaf.management.cfg", "rmiRegistryHost");
    }

    int getInstanceRmiServerPort(String name) {
        return this.getKarafPort(name, "etc/org.apache.karaf.management.cfg", "rmiServerPort");
    }

    void changeInstanceRmiServerPort(String name, int port) throws Exception {
        this.setKarafPort(name, "etc/org.apache.karaf.management.cfg", "rmiServerPort", port);
    }

    String getInstanceRmiServerHost(String name) {
        return this.getKarafHost(name, "etc/org.apache.karaf.management.cfg", "rmiServerHost");
    }

    private int getKarafPort(String name, String path, String key) {
        return this.execute(state -> this.getKarafPort((State)state, name, path, key), false);
    }

    private Integer getKarafPort(State state, String name, String path, String key) {
        InstanceState instance = state.instances.get(name);
        if (instance == null) {
            throw new IllegalArgumentException("Instance " + name + " not found");
        }
        File f = new File(instance.loc, path);
        try {
            return FileLockUtils.execute(f, properties -> {
                Object obj = properties.get(key);
                return obj instanceof Number ? ((Number)obj).intValue() : Integer.parseInt(obj.toString());
            }, false);
        }
        catch (IOException e) {
            return 0;
        }
    }

    private void setKarafPort(String name, String path, String key, int port) throws IOException {
        this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            this.checkPid(instance);
            if (instance.pid != 0) {
                throw new IllegalStateException("Instance is not stopped");
            }
            File f = new File(instance.loc, path);
            FileLockUtils.execute(f, properties -> properties.put(key, String.valueOf(port)), true);
            return null;
        }, true);
    }

    private String getKarafHost(String name, String path, String key) {
        return this.execute(state -> this.getKarafHost((State)state, name, path, key), false);
    }

    private String getKarafHost(State state, String name, String path, String key) {
        InstanceState instance = state.instances.get(name);
        if (instance == null) {
            throw new IllegalArgumentException("Instance " + name + " not found");
        }
        File f = new File(instance.loc, path);
        try {
            return FileLockUtils.execute(f, properties -> ((String)properties.get(key)).toString(), false);
        }
        catch (IOException e) {
            return "0.0.0.0";
        }
    }

    boolean isInstanceRoot(String name) {
        return this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            return instance.root;
        }, false);
    }

    String getInstanceLocation(String name) {
        return this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            return instance.loc;
        }, true);
    }

    int getInstancePid(String name) {
        boolean updateInstanceProperties = this.isInstancePidNeedUpdate(name);
        return this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            this.checkPid(instance);
            return instance.pid;
        }, updateInstanceProperties);
    }

    String getInstanceJavaOpts(String name) {
        return this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            return instance.opts;
        }, false);
    }

    void changeInstanceJavaOpts(String name, String opts) {
        this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            instance.opts = opts;
            return null;
        }, true);
    }

    String getInstanceState(String name) {
        boolean updateInstanceProperties = this.isInstancePidNeedUpdate(name);
        return this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            int port = this.getKarafPort((State)state, name, "etc/org.apache.karaf.shell.cfg", "sshPort");
            String host = this.getKarafHost((State)state, name, "etc/org.apache.karaf.shell.cfg", "sshHost");
            if (host.equals("0.0.0.0")) {
                host = "localhost";
            }
            if (!new File(instance.loc).isDirectory() || port <= 0) {
                return "Error";
            }
            this.checkPid(instance);
            if (instance.pid == 0) {
                return "Stopped";
            }
            try {
                Socket s = new Socket(host, port);
                s.close();
                return "Started";
            }
            catch (Exception exception) {
                return "Starting";
            }
        }, updateInstanceProperties);
    }

    private boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = true;
        if (fileToDelete.isDirectory()) {
            File[] files = fileToDelete.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (File file : files) {
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= this.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result &= fileToDelete.delete();
    }

    private void copyResourcesToDir(String[] resourcesToCopy, File target, Map<String, URL> resources, boolean printOutput) throws IOException {
        for (String resource : resourcesToCopy) {
            this.copyResourceToDir(resource, target, resources, printOutput);
        }
    }

    private void copyResourceToDir(String resource, File target, Map<String, URL> resources, boolean printOutput) throws IOException {
        File outFile = new File(target, resource);
        if (!outFile.exists()) {
            InstanceServiceImpl.logDebug("Creating file: %s", printOutput, outFile.getPath());
            try (InputStream is = this.getResourceStream(resource, resources);
                 FileOutputStream os = new FileOutputStream(outFile);){
                if (is == null) {
                    InstanceServiceImpl.logInfo("\tWARNING: unable to find %s", true, resource);
                } else {
                    this.copyStream(is, os);
                }
            }
        }
    }

    private InputStream getResourceStream(String resource, Map<String, URL> resources) throws IOException {
        return resources.containsKey(resource) ? resources.remove(resource).openStream() : this.getClass().getClassLoader().getResourceAsStream(RESOURCE_BASE + resource);
    }

    private static void println(String st) {
        System.out.println(st);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Properties loadPropertiesFile(URL configPropURL) throws Exception {
        try (InputStream is = configPropURL.openConnection().getInputStream();){
            Properties configProps = new Properties();
            configProps.load(is);
            Properties properties = configProps;
            return properties;
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            return null;
        }
    }

    private void copyStream(InputStream is, OutputStream os) {
        PrintStream out = new PrintStream(os);
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            out.println(line);
        }
        scanner.close();
    }

    private void filterResource(File basedir, String path, HashMap<String, String> props) throws IOException {
        File file = new File(basedir, path);
        File bak = new File(basedir, path + BACKUP_EXTENSION);
        if (!file.exists()) {
            return;
        }
        file.renameTo(bak);
        this.copyAndFilterResource(new FileInputStream(bak), new FileOutputStream(file), props);
        bak.delete();
    }

    private void copyFilteredResourcesToDir(String[] resourcesToCopy, File target, Map<String, URL> resources, Map<String, String> props, boolean printOutput) throws IOException {
        for (String resource : resourcesToCopy) {
            this.copyFilteredResourceToDir(resource, target, resources, props, printOutput);
        }
    }

    private void copyFilteredResourceToDir(String resource, File target, Map<String, URL> resources, Map<String, String> props, boolean printOutput) throws IOException {
        File outFile = new File(target, resource);
        if (!outFile.exists()) {
            InstanceServiceImpl.logDebug("Creating file: %s", printOutput, outFile.getPath());
            try (InputStream is = this.getResourceStream(resource, resources);
                 FileOutputStream os = new FileOutputStream(outFile);){
                this.copyAndFilterResource(is, os, props);
            }
        }
    }

    private void copyAndFilterResource(InputStream source, OutputStream target, Map<String, String> props) throws IOException {
        PrintStream out = new PrintStream(target);
        Scanner scanner = new Scanner(source);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            line = this.filter(line, props);
            out.println(line);
        }
        scanner.close();
    }

    private void copyBinaryResourceToDir(String resource, File target, Map<String, URL> resources, boolean printOutput) throws IOException {
        File outFile = new File(target, resource);
        if (!outFile.exists()) {
            InstanceServiceImpl.logDebug("Creating file: %s", printOutput, outFile.getPath());
            try (InputStream is = this.getResourceStream(resource, resources);
                 FileOutputStream os = new FileOutputStream(outFile);){
                StreamUtils.copy(is, os);
            }
        }
    }

    private String filter(String line, Map<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = line.indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = line.substring(0, p1);
            String l2 = line.substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    private void mkdir(File karafBase, String path, boolean printOutput) {
        File file = new File(karafBase, path);
        if (!file.exists()) {
            InstanceServiceImpl.logDebug("Creating dir: %s", printOutput, file.getPath());
            file.mkdirs();
        }
    }

    private void makeFileExecutable(File serviceFile) throws IOException {
        try {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
            Set<PosixFilePermission> filePermissions = Files.getPosixFilePermissions(serviceFile.toPath(), new LinkOption[0]);
            filePermissions.addAll(permissions);
            Files.setPosixFilePermissions(serviceFile.toPath(), filePermissions);
        }
        catch (UnsupportedOperationException ex) {
            serviceFile.setExecutable(true, false);
        }
    }

    private void copy(File source, File destination) throws IOException {
        if (source.getName().equals("cache.lock")) {
            return;
        }
        if (source.getName().equals("lock")) {
            return;
        }
        if (source.getName().matches("transaction_\\d+\\.log")) {
            return;
        }
        if (source.getName().endsWith(".instance")) {
            return;
        }
        if (source.isDirectory()) {
            String[] children;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            for (String child : children = source.list()) {
                if (child.contains("instances") || child.contains("lib")) continue;
                this.copy(new File(source, child), new File(destination, child));
            }
        } else {
            try (FileInputStream in = new FileInputStream(source);
                 FileOutputStream out = new FileOutputStream(destination);){
                StreamUtils.copy(in, out);
            }
        }
    }

    public void changeInstanceSshHost(String name, String host) throws Exception {
        this.setKarafHost(name, "etc/org.apache.karaf.shell.cfg", "sshHost", host);
    }

    private void setKarafHost(String name, String path, String key, String host) throws IOException {
        this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            this.checkPid(instance);
            if (instance.pid != 0) {
                throw new IllegalStateException("Instance is not stopped");
            }
            File f = new File(instance.loc, path);
            FileLockUtils.execute(f, properties -> properties.put(key, host), true);
            return null;
        }, true);
    }

    private boolean isInstancePidNeedUpdate(String name) {
        return this.execute(state -> {
            InstanceState instance = state.instances.get(name);
            if (instance == null) {
                throw new IllegalArgumentException("Instance " + name + " not found");
            }
            int originalPid = instance.pid;
            this.checkPid(instance);
            int newPid = instance.pid;
            return originalPid != newPid;
        }, false);
    }

    private static class ProfileApplier {
        private ProfileApplier() {
        }

        static void verify() {
            Profile.class.getName();
        }

        static void applyProfiles(File karafBase, List<String> profiles, boolean printOutput) throws IOException {
            BundleContext bundleContext = FrameworkUtil.getBundle(ProfileApplier.class).getBundleContext();
            ServiceReference reference = bundleContext.getServiceReference(ProfileService.class);
            ProfileService service = (ProfileService)bundleContext.getService(reference);
            Profile profile = ProfileBuilder.Factory.create((String)"temp").addParents(profiles).getProfile();
            Profile overlay = service.getOverlayProfile(profile);
            Profile effective = service.getEffectiveProfile(overlay, false);
            Map configs = effective.getFileConfigurations();
            for (Map.Entry config : configs.entrySet()) {
                String pid = (String)config.getKey();
                if (pid.equals("profile.cfg")) continue;
                Path configFile = Paths.get(karafBase.toString(), "etc", pid);
                InstanceServiceImpl.logDebug("Creating file: %s", printOutput, new Object[]{configFile.toString()});
                Files.write(configFile, (byte[])config.getValue(), new OpenOption[0]);
            }
            FileLockUtils.execute(new File(karafBase, InstanceServiceImpl.FEATURES_CFG), properties -> {
                InstanceServiceImpl.appendToPropList(properties, "featuresBoot", effective.getFeatures());
                InstanceServiceImpl.appendToPropList(properties, "featuresRepositories", effective.getRepositories());
            }, true);
            bundleContext.ungetService(reference);
        }
    }

    static interface Task<U, T> {
        public T call(U var1) throws IOException;
    }

    static class State {
        int defaultSshPortStart = 8101;
        int defaultRmiRegistryPortStart = 1099;
        int defaultRmiServerPortStart = 44444;
        Map<String, InstanceState> instances;

        public State() {
            try {
                Properties shellProperty = new Properties();
                shellProperty.load(new File(System.getProperty("karaf.etc"), "org.apache.karaf.shell.cfg"));
                this.defaultSshPortStart = InstanceServiceImpl.getInt(shellProperty, "sshPort", 8101);
                Properties managementProperty = new Properties();
                managementProperty.load(new File(System.getProperty("karaf.etc"), "org.apache.karaf.management.cfg"));
                this.defaultRmiRegistryPortStart = InstanceServiceImpl.getInt(managementProperty, "rmiRegistryPort", 1099);
                this.defaultRmiServerPortStart = InstanceServiceImpl.getInt(managementProperty, "rmiServerPort", 1099);
            }
            catch (Exception e) {
                LOGGER.debug("Could not read port start value from the root instance configuration.", (Throwable)e);
            }
        }
    }

    static class InstanceState {
        String name;
        String loc;
        String opts;
        int pid;
        boolean root;

        InstanceState() {
        }
    }
}

