/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.util.Collections;
import java.util.function.Function;
import org.apache.kafka.message.EntityType;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.FieldType;
import org.apache.kafka.message.Versions;

public final class Target {
    private final FieldSpec field;
    private final String sourceVariable;
    private final String humanReadableName;
    private final Function<String, String> assignmentStatementGenerator;

    Target(FieldSpec field, String sourceVariable, String humanReadableName, Function<String, String> assignmentStatementGenerator) {
        this.field = field;
        this.sourceVariable = sourceVariable;
        this.humanReadableName = humanReadableName;
        this.assignmentStatementGenerator = assignmentStatementGenerator;
    }

    public String assignmentStatement(String rightHandSide) {
        return this.assignmentStatementGenerator.apply(rightHandSide);
    }

    public Target nonNullableCopy() {
        FieldSpec nonNullableField = new FieldSpec(this.field.name(), this.field.versionsString(), this.field.fields(), this.field.typeString(), this.field.mapKey(), Versions.NONE.toString(), this.field.defaultString(), this.field.ignorable(), this.field.entityType(), this.field.about(), this.field.taggedVersionsString(), this.field.flexibleVersionsString(), this.field.tagInteger(), this.field.zeroCopy());
        return new Target(nonNullableField, this.sourceVariable, this.humanReadableName, this.assignmentStatementGenerator);
    }

    public Target arrayElementTarget(Function<String, String> assignmentStatementGenerator) {
        if (!this.field.type().isArray()) {
            throw new RuntimeException("Field " + this.field + " is not an array.");
        }
        FieldType.ArrayType arrayType = (FieldType.ArrayType)this.field.type();
        FieldSpec elementField = new FieldSpec(this.field.name() + "Element", this.field.versions().toString(), Collections.emptyList(), arrayType.elementType().toString(), false, Versions.NONE.toString(), "", false, EntityType.UNKNOWN, "", Versions.NONE.toString(), this.field.flexibleVersionsString(), null, this.field.zeroCopy());
        return new Target(elementField, "_element", this.humanReadableName + " element", assignmentStatementGenerator);
    }

    public FieldSpec field() {
        return this.field;
    }

    public String sourceVariable() {
        return this.sourceVariable;
    }

    public String humanReadableName() {
        return this.humanReadableName;
    }
}

