/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.EntityType;
import org.apache.kafka.message.FieldType;
import org.apache.kafka.message.HeaderGenerator;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.StructRegistry;
import org.apache.kafka.message.Versions;

public final class FieldSpec {
    private static final Pattern VALID_FIELD_NAMES = Pattern.compile("[A-Za-z]([A-Za-z0-9]*)");
    private final String name;
    private final Versions versions;
    private final List<FieldSpec> fields;
    private final FieldType type;
    private final boolean mapKey;
    private final Versions nullableVersions;
    private final String fieldDefault;
    private final boolean ignorable;
    private final EntityType entityType;
    private final String about;
    private final Versions taggedVersions;
    private final Optional<Versions> flexibleVersions;
    private final Optional<Integer> tag;
    private final boolean zeroCopy;

    @JsonCreator
    public FieldSpec(@JsonProperty(value="name") String name, @JsonProperty(value="versions") String versions, @JsonProperty(value="fields") List<FieldSpec> fields, @JsonProperty(value="type") String type, @JsonProperty(value="mapKey") boolean mapKey, @JsonProperty(value="nullableVersions") String nullableVersions, @JsonProperty(value="default") String fieldDefault, @JsonProperty(value="ignorable") boolean ignorable, @JsonProperty(value="entityType") EntityType entityType, @JsonProperty(value="about") String about, @JsonProperty(value="taggedVersions") String taggedVersions, @JsonProperty(value="flexibleVersions") String flexibleVersions, @JsonProperty(value="tag") Integer tag, @JsonProperty(value="zeroCopy") boolean zeroCopy) {
        this.name = Objects.requireNonNull(name);
        if (!VALID_FIELD_NAMES.matcher(this.name).matches()) {
            throw new RuntimeException("Invalid field name " + this.name);
        }
        this.taggedVersions = Versions.parse(taggedVersions, Versions.NONE);
        this.versions = Versions.parse(versions, this.taggedVersions.empty() ? null : this.taggedVersions);
        if (this.versions == null) {
            throw new RuntimeException("You must specify the version of the " + name + " structure.");
        }
        this.fields = Collections.unmodifiableList(fields == null ? Collections.emptyList() : new ArrayList<FieldSpec>(fields));
        this.type = FieldType.parse(Objects.requireNonNull(type));
        this.mapKey = mapKey;
        this.nullableVersions = Versions.parse(nullableVersions, Versions.NONE);
        if (!this.nullableVersions.empty() && !this.type.canBeNullable()) {
            throw new RuntimeException("Type " + this.type + " cannot be nullable.");
        }
        this.fieldDefault = fieldDefault == null ? "" : fieldDefault;
        this.ignorable = ignorable;
        this.entityType = entityType == null ? EntityType.UNKNOWN : entityType;
        this.entityType.verifyTypeMatches(name, this.type);
        String string = this.about = about == null ? "" : about;
        if (!(this.fields().isEmpty() || this.type.isArray() || this.type.isStruct())) {
            throw new RuntimeException("Non-array or Struct field " + name + " cannot have fields");
        }
        if (flexibleVersions == null || flexibleVersions.isEmpty()) {
            this.flexibleVersions = Optional.empty();
        } else {
            this.flexibleVersions = Optional.of(Versions.parse(flexibleVersions, null));
            if (!this.type.isString() && !this.type.isBytes()) {
                throw new RuntimeException("Invalid flexibleVersions override for " + name + ".  Only fields of type string or bytes can specify a flexibleVersions override.");
            }
        }
        this.tag = Optional.ofNullable(tag);
        if (this.tag.isPresent() && mapKey) {
            throw new RuntimeException("Tagged fields cannot be used as keys.");
        }
        this.checkTagInvariants();
        this.zeroCopy = zeroCopy;
        if (this.zeroCopy && !this.type.isBytes()) {
            throw new RuntimeException("Invalid zeroCopy value for " + name + ". Only fields of type bytes can use zeroCopy flag.");
        }
    }

    private void checkTagInvariants() {
        if (this.tag.isPresent()) {
            if (this.tag.get() < 0) {
                throw new RuntimeException("Field " + this.name + " specifies a tag of " + this.tag.get() + ".  Tags cannot be negative.");
            }
            if (this.taggedVersions.empty()) {
                throw new RuntimeException("Field " + this.name + " specifies a tag of " + this.tag.get() + ", but has no tagged versions.  If a tag is specified, taggedVersions must be specified as well.");
            }
            Versions nullableTaggedVersions = this.nullableVersions.intersect(this.taggedVersions);
            if (!nullableTaggedVersions.empty() && !nullableTaggedVersions.equals(this.taggedVersions)) {
                throw new RuntimeException("Field " + this.name + " specifies nullableVersions " + this.nullableVersions + " and taggedVersions " + this.taggedVersions + ".  Either all tagged versions must be nullable, or none must be.");
            }
            if (this.taggedVersions.highest() < Short.MAX_VALUE) {
                throw new RuntimeException("Field " + this.name + " specifies taggedVersions " + this.taggedVersions + ", which is not open-ended.  taggedVersions must be either none, or an open-ended range (that ends with a plus sign).");
            }
            if (!this.taggedVersions.intersect(this.versions).equals(this.taggedVersions)) {
                throw new RuntimeException("Field " + this.name + " specifies taggedVersions " + this.taggedVersions + ", and versions " + this.versions + ".  taggedVersions must be a subset of versions.");
            }
        } else if (!this.taggedVersions.empty()) {
            throw new RuntimeException("Field " + this.name + " does not specify a tag, but specifies tagged versions of " + this.taggedVersions + ".  Please specify a tag, or remove the taggedVersions.");
        }
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    String capitalizedCamelCaseName() {
        return MessageGenerator.capitalizeFirst(this.name);
    }

    String camelCaseName() {
        return MessageGenerator.lowerCaseFirst(this.name);
    }

    String snakeCaseName() {
        return MessageGenerator.toSnakeCase(this.name);
    }

    public Versions versions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    public String versionsString() {
        return this.versions.toString();
    }

    @JsonProperty(value="fields")
    public List<FieldSpec> fields() {
        return this.fields;
    }

    @JsonProperty(value="type")
    public String typeString() {
        return this.type.toString();
    }

    public FieldType type() {
        return this.type;
    }

    @JsonProperty(value="mapKey")
    public boolean mapKey() {
        return this.mapKey;
    }

    public Versions nullableVersions() {
        return this.nullableVersions;
    }

    @JsonProperty(value="nullableVersions")
    public String nullableVersionsString() {
        return this.nullableVersions.toString();
    }

    @JsonProperty(value="default")
    public String defaultString() {
        return this.fieldDefault;
    }

    @JsonProperty(value="ignorable")
    public boolean ignorable() {
        return this.ignorable;
    }

    @JsonProperty(value="entityType")
    public EntityType entityType() {
        return this.entityType;
    }

    @JsonProperty(value="about")
    public String about() {
        return this.about;
    }

    @JsonProperty(value="taggedVersions")
    public String taggedVersionsString() {
        return this.taggedVersions.toString();
    }

    public Versions taggedVersions() {
        return this.taggedVersions;
    }

    @JsonProperty(value="flexibleVersions")
    public String flexibleVersionsString() {
        return this.flexibleVersions.isPresent() ? this.flexibleVersions.get().toString() : null;
    }

    public Optional<Versions> flexibleVersions() {
        return this.flexibleVersions;
    }

    @JsonProperty(value="tag")
    public Integer tagInteger() {
        return this.tag.orElse(null);
    }

    public Optional<Integer> tag() {
        return this.tag;
    }

    @JsonProperty(value="zeroCopy")
    public boolean zeroCopy() {
        return this.zeroCopy;
    }

    String fieldDefault(HeaderGenerator headerGenerator, StructRegistry structRegistry) {
        if (this.type instanceof FieldType.BoolFieldType) {
            if (this.fieldDefault.isEmpty()) {
                return "false";
            }
            if (this.fieldDefault.equalsIgnoreCase("true")) {
                return "true";
            }
            if (this.fieldDefault.equalsIgnoreCase("false")) {
                return "false";
            }
            throw new RuntimeException("Invalid default for boolean field " + this.name + ": " + this.fieldDefault);
        }
        if (this.type instanceof FieldType.Int8FieldType || this.type instanceof FieldType.Int16FieldType || this.type instanceof FieldType.Uint16FieldType || this.type instanceof FieldType.Uint32FieldType || this.type instanceof FieldType.Int32FieldType || this.type instanceof FieldType.Int64FieldType) {
            int base = 10;
            String defaultString = this.fieldDefault;
            if (defaultString.startsWith("0x")) {
                base = 16;
                defaultString = defaultString.substring(2);
            }
            if (this.type instanceof FieldType.Int8FieldType) {
                if (defaultString.isEmpty()) {
                    return "(byte) 0";
                }
                try {
                    Byte.valueOf(defaultString, base);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid default for int8 field " + this.name + ": " + defaultString, e);
                }
                return "(byte) " + this.fieldDefault;
            }
            if (this.type instanceof FieldType.Int16FieldType) {
                if (defaultString.isEmpty()) {
                    return "(short) 0";
                }
                try {
                    Short.valueOf(defaultString, base);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid default for int16 field " + this.name + ": " + defaultString, e);
                }
                return "(short) " + this.fieldDefault;
            }
            if (this.type instanceof FieldType.Uint16FieldType) {
                if (defaultString.isEmpty()) {
                    return "0";
                }
                try {
                    int value = Integer.valueOf(defaultString, base);
                    if (value < 0 || value > 65535) {
                        throw new RuntimeException("Invalid default for uint16 field " + this.name + ": out of range.");
                    }
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid default for uint16 field " + this.name + ": " + defaultString, e);
                }
                return this.fieldDefault;
            }
            if (this.type instanceof FieldType.Uint32FieldType) {
                if (defaultString.isEmpty()) {
                    return "0";
                }
                try {
                    long value = Long.valueOf(defaultString, base);
                    if (value < 0L || value > 0xFFFFFFFFL) {
                        throw new RuntimeException("Invalid default for uint32 field " + this.name + ": out of range.");
                    }
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid default for uint32 field " + this.name + ": " + defaultString, e);
                }
                return this.fieldDefault;
            }
            if (this.type instanceof FieldType.Int32FieldType) {
                if (defaultString.isEmpty()) {
                    return "0";
                }
                try {
                    Integer.valueOf(defaultString, base);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid default for int32 field " + this.name + ": " + defaultString, e);
                }
                return this.fieldDefault;
            }
            if (this.type instanceof FieldType.Int64FieldType) {
                if (defaultString.isEmpty()) {
                    return "0L";
                }
                try {
                    Long.valueOf(defaultString, base);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid default for int64 field " + this.name + ": " + defaultString, e);
                }
                return this.fieldDefault + "L";
            }
            throw new RuntimeException("Unsupported field type " + this.type);
        }
        if (this.type instanceof FieldType.UUIDFieldType) {
            headerGenerator.addImport("org.apache.kafka.common.Uuid");
            if (this.fieldDefault.isEmpty()) {
                return "Uuid.ZERO_UUID";
            }
            try {
                ByteBuffer uuidBytes = ByteBuffer.wrap(Base64.getUrlDecoder().decode(this.fieldDefault));
                uuidBytes.getLong();
                uuidBytes.getLong();
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Invalid default for uuid field " + this.name + ": " + this.fieldDefault, e);
            }
            headerGenerator.addImport("org.apache.kafka.common.Uuid");
            return "Uuid.fromString(\"" + this.fieldDefault + "\")";
        }
        if (this.type instanceof FieldType.Float64FieldType) {
            if (this.fieldDefault.isEmpty()) {
                return "0.0";
            }
            try {
                Double.parseDouble(this.fieldDefault);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid default for float64 field " + this.name + ": " + this.fieldDefault, e);
            }
            return "Double.parseDouble(\"" + this.fieldDefault + "\")";
        }
        if (this.type instanceof FieldType.StringFieldType) {
            if (this.fieldDefault.equals("null")) {
                this.validateNullDefault();
                return "null";
            }
            return "\"" + this.fieldDefault + "\"";
        }
        if (this.type.isBytes()) {
            if (this.fieldDefault.equals("null")) {
                this.validateNullDefault();
                return "null";
            }
            if (!this.fieldDefault.isEmpty()) {
                throw new RuntimeException("Invalid default for bytes field " + this.name + ".  The only valid default for a bytes field is empty or null.");
            }
            if (this.zeroCopy) {
                headerGenerator.addImport("org.apache.kafka.common.utils.ByteUtils");
                return "ByteUtils.EMPTY_BUF";
            }
            headerGenerator.addImport("org.apache.kafka.common.utils.Bytes");
            return "Bytes.EMPTY";
        }
        if (this.type.isRecords()) {
            return "null";
        }
        if (this.type.isStruct()) {
            if (!this.fieldDefault.isEmpty()) {
                throw new RuntimeException("Invalid default for struct field " + this.name + ": custom defaults are not supported for struct fields.");
            }
            return "new " + this.type.toString() + "()";
        }
        if (this.type.isArray()) {
            if (this.fieldDefault.equals("null")) {
                this.validateNullDefault();
                return "null";
            }
            if (!this.fieldDefault.isEmpty()) {
                throw new RuntimeException("Invalid default for array field " + this.name + ".  The only valid default for an array field is the empty array or null.");
            }
            return String.format("new %s(0)", this.concreteJavaType(headerGenerator, structRegistry));
        }
        throw new RuntimeException("Unsupported field type " + this.type);
    }

    private void validateNullDefault() {
        if (!this.nullableVersions().contains(this.versions)) {
            throw new RuntimeException("null cannot be the default for field " + this.name + ", because not all versions of this field are nullable.");
        }
    }

    String fieldAbstractJavaType(HeaderGenerator headerGenerator, StructRegistry structRegistry) {
        if (this.type instanceof FieldType.BoolFieldType) {
            return "boolean";
        }
        if (this.type instanceof FieldType.Int8FieldType) {
            return "byte";
        }
        if (this.type instanceof FieldType.Int16FieldType) {
            return "short";
        }
        if (this.type instanceof FieldType.Uint16FieldType) {
            return "int";
        }
        if (this.type instanceof FieldType.Uint32FieldType) {
            return "long";
        }
        if (this.type instanceof FieldType.Int32FieldType) {
            return "int";
        }
        if (this.type instanceof FieldType.Int64FieldType) {
            return "long";
        }
        if (this.type instanceof FieldType.UUIDFieldType) {
            headerGenerator.addImport("org.apache.kafka.common.Uuid");
            return "Uuid";
        }
        if (this.type instanceof FieldType.Float64FieldType) {
            return "double";
        }
        if (this.type.isString()) {
            return "String";
        }
        if (this.type.isBytes()) {
            if (this.zeroCopy) {
                headerGenerator.addImport("java.nio.ByteBuffer");
                return "ByteBuffer";
            }
            return "byte[]";
        }
        if (this.type instanceof FieldType.RecordsFieldType) {
            headerGenerator.addImport("org.apache.kafka.common.record.BaseRecords");
            return "BaseRecords";
        }
        if (this.type.isStruct()) {
            return MessageGenerator.capitalizeFirst(this.typeString());
        }
        if (this.type.isArray()) {
            FieldType.ArrayType arrayType = (FieldType.ArrayType)this.type;
            if (structRegistry.isStructArrayWithKeys(this)) {
                headerGenerator.addImport("org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection");
                return FieldSpec.collectionType(arrayType.elementType().toString());
            }
            headerGenerator.addImport("java.util.List");
            return String.format("List<%s>", arrayType.elementType().getBoxedJavaType(headerGenerator));
        }
        throw new RuntimeException("Unknown field type " + this.type);
    }

    String concreteJavaType(HeaderGenerator headerGenerator, StructRegistry structRegistry) {
        if (this.type.isArray()) {
            FieldType.ArrayType arrayType = (FieldType.ArrayType)this.type;
            if (structRegistry.isStructArrayWithKeys(this)) {
                return FieldSpec.collectionType(arrayType.elementType().toString());
            }
            headerGenerator.addImport("java.util.ArrayList");
            return String.format("ArrayList<%s>", arrayType.elementType().getBoxedJavaType(headerGenerator));
        }
        return this.fieldAbstractJavaType(headerGenerator, structRegistry);
    }

    static String collectionType(String baseType) {
        return baseType + "Collection";
    }

    void generateNonDefaultValueCheck(HeaderGenerator headerGenerator, StructRegistry structRegistry, CodeBuffer buffer, String fieldPrefix, Versions nullableVersions) {
        String fieldDefault = this.fieldDefault(headerGenerator, structRegistry);
        if (this.type().isArray()) {
            if (fieldDefault.equals("null")) {
                buffer.printf("if (%s%s != null) {%n", fieldPrefix, this.camelCaseName());
            } else if (nullableVersions.empty()) {
                buffer.printf("if (!%s%s.isEmpty()) {%n", fieldPrefix, this.camelCaseName());
            } else {
                buffer.printf("if (%s%s == null || !%s%s.isEmpty()) {%n", fieldPrefix, this.camelCaseName(), fieldPrefix, this.camelCaseName());
            }
        } else if (this.type().isBytes()) {
            if (fieldDefault.equals("null")) {
                buffer.printf("if (%s%s != null) {%n", fieldPrefix, this.camelCaseName());
            } else if (nullableVersions.empty()) {
                if (this.zeroCopy()) {
                    buffer.printf("if (%s%s.hasRemaining()) {%n", fieldPrefix, this.camelCaseName());
                } else {
                    buffer.printf("if (%s%s.length != 0) {%n", fieldPrefix, this.camelCaseName());
                }
            } else if (this.zeroCopy()) {
                buffer.printf("if (%s%s == null || %s%s.remaining() > 0) {%n", fieldPrefix, this.camelCaseName(), fieldPrefix, this.camelCaseName());
            } else {
                buffer.printf("if (%s%s == null || %s%s.length != 0) {%n", fieldPrefix, this.camelCaseName(), fieldPrefix, this.camelCaseName());
            }
        } else if (this.type().isString() || this.type().isStruct() || this.type() instanceof FieldType.UUIDFieldType) {
            if (fieldDefault.equals("null")) {
                buffer.printf("if (%s%s != null) {%n", fieldPrefix, this.camelCaseName());
            } else if (nullableVersions.empty()) {
                buffer.printf("if (!%s%s.equals(%s)) {%n", fieldPrefix, this.camelCaseName(), fieldDefault);
            } else {
                buffer.printf("if (%s%s == null || !%s%s.equals(%s)) {%n", fieldPrefix, this.camelCaseName(), fieldPrefix, this.camelCaseName(), fieldDefault);
            }
        } else if (this.type() instanceof FieldType.BoolFieldType) {
            buffer.printf("if (%s%s%s) {%n", fieldDefault.equals("true") ? "!" : "", fieldPrefix, this.camelCaseName());
        } else {
            buffer.printf("if (%s%s != %s) {%n", fieldPrefix, this.camelCaseName(), fieldDefault);
        }
    }

    void generateNonIgnorableFieldCheck(HeaderGenerator headerGenerator, StructRegistry structRegistry, String fieldPrefix, CodeBuffer buffer) {
        this.generateNonDefaultValueCheck(headerGenerator, structRegistry, buffer, fieldPrefix, this.nullableVersions());
        buffer.incrementIndent();
        headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        buffer.printf("throw new UnsupportedVersionException(\"Attempted to write a non-default %s at version \" + _version);%n", this.camelCaseName());
        buffer.decrementIndent();
        buffer.printf("}%n", new Object[0]);
    }
}

