/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.RestartRequest;
import org.apache.kafka.connect.runtime.rest.HerderRequestHandler;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestServerConfig;
import org.apache.kafka.connect.runtime.rest.entities.ActiveTopicsInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorOffsets;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;
import org.apache.kafka.connect.runtime.rest.entities.Message;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.runtime.rest.resources.ConnectResource;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/connectors")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectorsResource
implements ConnectResource {
    private static final Logger log = LoggerFactory.getLogger(ConnectorsResource.class);
    private final Herder herder;
    private final HerderRequestHandler requestHandler;
    @Context
    private ServletContext context;
    private final boolean isTopicTrackingDisabled;
    private final boolean isTopicTrackingResetDisabled;

    public ConnectorsResource(Herder herder, RestServerConfig config, RestClient restClient) {
        this.herder = herder;
        this.requestHandler = new HerderRequestHandler(restClient, DEFAULT_REST_REQUEST_TIMEOUT_MS);
        this.isTopicTrackingDisabled = !config.topicTrackingEnabled();
        this.isTopicTrackingResetDisabled = !config.topicTrackingResetEnabled();
    }

    @Override
    public void requestTimeout(long requestTimeoutMs) {
        this.requestHandler.requestTimeoutMs(requestTimeoutMs);
    }

    @GET
    @Path(value="/")
    @Operation(summary="List all active connectors")
    public Response listConnectors(@Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (uriInfo.getQueryParameters().containsKey((Object)"expand")) {
            HashMap out = new HashMap();
            for (String connector : this.herder.connectors()) {
                try {
                    HashMap<String, Object> connectorExpansions = new HashMap<String, Object>();
                    Iterator iterator = ((List)uriInfo.getQueryParameters().get((Object)"expand")).iterator();
                    block11: while (iterator.hasNext()) {
                        String expansion;
                        switch (expansion = (String)iterator.next()) {
                            case "status": {
                                connectorExpansions.put("status", this.herder.connectorStatus(connector));
                                continue block11;
                            }
                            case "info": {
                                connectorExpansions.put("info", this.herder.connectorInfo(connector));
                                continue block11;
                            }
                        }
                        log.info("Ignoring unknown expansion type {}", (Object)expansion);
                    }
                    out.put(connector, connectorExpansions);
                }
                catch (NotFoundException e) {
                    log.debug("Unable to get connector info for {} on this worker", (Object)connector);
                }
            }
            return Response.ok(out).build();
        }
        return Response.ok(this.herder.connectors()).build();
    }

    @POST
    @Path(value="/")
    @Operation(summary="Create a new connector")
    public Response createConnector(@Parameter(hidden=true) @QueryParam(value="forward") Boolean forward, @Context HttpHeaders headers, CreateConnectorRequest createRequest) throws Throwable {
        String name = createRequest.name() == null ? "" : createRequest.name().trim();
        Map<String, String> configs = createRequest.config();
        this.checkAndPutConnectorConfigName(name, configs);
        FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>();
        this.herder.putConnectorConfig(name, configs, false, cb);
        Herder.Created<ConnectorInfo> info = this.requestHandler.completeOrForwardRequest(cb, "/connectors", "POST", headers, createRequest, new TypeReference<ConnectorInfo>(){}, new CreatedConnectorInfoTranslator(), forward);
        URI location = UriBuilder.fromUri((String)"/connectors").path(name).build(new Object[0]);
        return Response.created((URI)location).entity((Object)info.result()).build();
    }

    @GET
    @Path(value="/{connector}")
    @Operation(summary="Get the details for the specified connector")
    public ConnectorInfo getConnector(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<ConnectorInfo> cb = new FutureCallback<ConnectorInfo>();
        this.herder.connectorInfo(connector, cb);
        return this.requestHandler.completeRequest(cb);
    }

    @GET
    @Path(value="/{connector}/config")
    @Operation(summary="Get the configuration for the specified connector")
    public Map<String, String> getConnectorConfig(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<Map<String, String>> cb = new FutureCallback<Map<String, String>>();
        this.herder.connectorConfig(connector, cb);
        return this.requestHandler.completeRequest(cb);
    }

    @GET
    @Path(value="/{connector}/tasks-config")
    @Operation(summary="Get the configuration of all tasks for the specified connector")
    public Map<ConnectorTaskId, Map<String, String>> getTasksConfig(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<Map<ConnectorTaskId, Map<String, String>>> cb = new FutureCallback<Map<ConnectorTaskId, Map<String, String>>>();
        this.herder.tasksConfig(connector, cb);
        return this.requestHandler.completeRequest(cb);
    }

    @GET
    @Path(value="/{connector}/status")
    @Operation(summary="Get the status for the specified connector")
    public ConnectorStateInfo getConnectorStatus(@PathParam(value="connector") String connector) {
        return this.herder.connectorStatus(connector);
    }

    @GET
    @Path(value="/{connector}/topics")
    @Operation(summary="Get the list of topics actively used by the specified connector")
    public Response getConnectorActiveTopics(@PathParam(value="connector") String connector) {
        if (this.isTopicTrackingDisabled) {
            throw new ConnectRestException(Response.Status.FORBIDDEN.getStatusCode(), "Topic tracking is disabled.");
        }
        ActiveTopicsInfo info = this.herder.connectorActiveTopics(connector);
        return Response.ok(Collections.singletonMap(info.connector(), info)).build();
    }

    @PUT
    @Path(value="/{connector}/topics/reset")
    @Operation(summary="Reset the list of topics actively used by the specified connector")
    public Response resetConnectorActiveTopics(@PathParam(value="connector") String connector, @Context HttpHeaders headers) {
        if (this.isTopicTrackingDisabled) {
            throw new ConnectRestException(Response.Status.FORBIDDEN.getStatusCode(), "Topic tracking is disabled.");
        }
        if (this.isTopicTrackingResetDisabled) {
            throw new ConnectRestException(Response.Status.FORBIDDEN.getStatusCode(), "Topic tracking reset is disabled.");
        }
        this.herder.resetConnectorActiveTopics(connector);
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/{connector}/config")
    @Operation(summary="Create or reconfigure the specified connector")
    public Response putConnectorConfig(@PathParam(value="connector") String connector, @Context HttpHeaders headers, @Parameter(hidden=true) @QueryParam(value="forward") Boolean forward, Map<String, String> connectorConfig) throws Throwable {
        Response.ResponseBuilder response;
        FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>();
        this.checkAndPutConnectorConfigName(connector, connectorConfig);
        this.herder.putConnectorConfig(connector, connectorConfig, true, cb);
        Herder.Created<ConnectorInfo> createdInfo = this.requestHandler.completeOrForwardRequest(cb, "/connectors/" + connector + "/config", "PUT", headers, connectorConfig, new TypeReference<ConnectorInfo>(){}, new CreatedConnectorInfoTranslator(), forward);
        if (createdInfo.created()) {
            URI location = UriBuilder.fromUri((String)"/connectors").path(connector).build(new Object[0]);
            response = Response.created((URI)location);
        } else {
            response = Response.ok();
        }
        return response.entity((Object)createdInfo.result()).build();
    }

    @POST
    @Path(value="/{connector}/restart")
    @Operation(summary="Restart the specified connector")
    public Response restartConnector(@PathParam(value="connector") String connector, @Context HttpHeaders headers, @DefaultValue(value="false") @QueryParam(value="includeTasks") @Parameter(description="Whether to also restart tasks") Boolean includeTasks, @DefaultValue(value="false") @QueryParam(value="onlyFailed") @Parameter(description="Whether to only restart failed tasks/connectors") Boolean onlyFailed, @Parameter(hidden=true) @QueryParam(value="forward") Boolean forward) throws Throwable {
        RestartRequest restartRequest = new RestartRequest(connector, onlyFailed, includeTasks);
        String forwardingPath = "/connectors/" + connector + "/restart";
        if (restartRequest.forceRestartConnectorOnly()) {
            FutureCallback<Void> cb = new FutureCallback<Void>();
            this.herder.restartConnector(connector, cb);
            this.requestHandler.completeOrForwardRequest(cb, forwardingPath, "POST", headers, null, forward);
            return Response.noContent().build();
        }
        FutureCallback<ConnectorStateInfo> cb = new FutureCallback<ConnectorStateInfo>();
        this.herder.restartConnectorAndTasks(restartRequest, cb);
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("includeTasks", includeTasks.toString());
        queryParameters.put("onlyFailed", onlyFailed.toString());
        ConnectorStateInfo stateInfo = this.requestHandler.completeOrForwardRequest(cb, forwardingPath, "POST", headers, queryParameters, null, new TypeReference<ConnectorStateInfo>(){}, new HerderRequestHandler.IdentityTranslator(), forward);
        return Response.accepted().entity((Object)stateInfo).build();
    }

    @PUT
    @Path(value="/{connector}/stop")
    @Operation(summary="Stop the specified connector", description="This operation is idempotent and has no effects if the connector is already stopped")
    public void stopConnector(@PathParam(value="connector") String connector, @Context HttpHeaders headers, @Parameter(hidden=true) @QueryParam(value="forward") Boolean forward) throws Throwable {
        FutureCallback<Void> cb = new FutureCallback<Void>();
        this.herder.stopConnector(connector, cb);
        this.requestHandler.completeOrForwardRequest(cb, "/connectors/" + connector + "/stop", "PUT", headers, null, forward);
    }

    @PUT
    @Path(value="/{connector}/pause")
    @Operation(summary="Pause the specified connector", description="This operation is idempotent and has no effects if the connector is already paused")
    public Response pauseConnector(@PathParam(value="connector") String connector, @Context HttpHeaders headers) {
        this.herder.pauseConnector(connector);
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/{connector}/resume")
    @Operation(summary="Resume the specified connector", description="This operation is idempotent and has no effects if the connector is already running")
    public Response resumeConnector(@PathParam(value="connector") String connector) {
        this.herder.resumeConnector(connector);
        return Response.accepted().build();
    }

    @GET
    @Path(value="/{connector}/tasks")
    @Operation(summary="List all tasks for the specified connector")
    public List<TaskInfo> getTaskConfigs(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<List<TaskInfo>> cb = new FutureCallback<List<TaskInfo>>();
        this.herder.taskConfigs(connector, cb);
        return this.requestHandler.completeRequest(cb);
    }

    @GET
    @Path(value="/{connector}/tasks/{task}/status")
    @Operation(summary="Get the state of the specified task for the specified connector")
    public ConnectorStateInfo.TaskState getTaskStatus(@PathParam(value="connector") String connector, @Context HttpHeaders headers, @PathParam(value="task") Integer task) {
        return this.herder.taskStatus(new ConnectorTaskId(connector, task));
    }

    @POST
    @Path(value="/{connector}/tasks/{task}/restart")
    @Operation(summary="Restart the specified task for the specified connector")
    public void restartTask(@PathParam(value="connector") String connector, @PathParam(value="task") Integer task, @Context HttpHeaders headers, @Parameter(hidden=true) @QueryParam(value="forward") Boolean forward) throws Throwable {
        FutureCallback<Void> cb = new FutureCallback<Void>();
        ConnectorTaskId taskId = new ConnectorTaskId(connector, task);
        this.herder.restartTask(taskId, cb);
        this.requestHandler.completeOrForwardRequest(cb, "/connectors/" + connector + "/tasks/" + task + "/restart", "POST", headers, null, forward);
    }

    @DELETE
    @Path(value="/{connector}")
    @Operation(summary="Delete the specified connector")
    public void destroyConnector(@PathParam(value="connector") String connector, @Context HttpHeaders headers, @Parameter(hidden=true) @QueryParam(value="forward") Boolean forward) throws Throwable {
        FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>();
        this.herder.deleteConnectorConfig(connector, cb);
        this.requestHandler.completeOrForwardRequest(cb, "/connectors/" + connector, "DELETE", headers, null, forward);
    }

    @GET
    @Path(value="/{connector}/offsets")
    @Operation(summary="Get the current offsets for the specified connector")
    public ConnectorOffsets getOffsets(@PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<ConnectorOffsets> cb = new FutureCallback<ConnectorOffsets>();
        this.herder.connectorOffsets(connector, cb);
        return this.requestHandler.completeRequest(cb);
    }

    @PATCH
    @Path(value="/{connector}/offsets")
    @Operation(summary="Alter the offsets for the specified connector")
    public Response alterConnectorOffsets(@Parameter(hidden=true) @QueryParam(value="forward") Boolean forward, @Context HttpHeaders headers, @PathParam(value="connector") String connector, ConnectorOffsets offsets) throws Throwable {
        if (offsets.offsets() == null || offsets.offsets().isEmpty()) {
            throw new BadRequestException("Partitions / offsets need to be provided for an alter offsets request");
        }
        FutureCallback<Message> cb = new FutureCallback<Message>();
        this.herder.alterConnectorOffsets(connector, offsets.toMap(), cb);
        Message msg = this.requestHandler.completeOrForwardRequest(cb, "/connectors/" + connector + "/offsets", "PATCH", headers, offsets, new TypeReference<Message>(){}, new HerderRequestHandler.IdentityTranslator(), forward);
        return Response.ok().entity((Object)msg).build();
    }

    @DELETE
    @Path(value="/{connector}/offsets")
    @Operation(summary="Reset the offsets for the specified connector")
    public Response resetConnectorOffsets(@Parameter(hidden=true) @QueryParam(value="forward") Boolean forward, @Context HttpHeaders headers, @PathParam(value="connector") String connector) throws Throwable {
        FutureCallback<Message> cb = new FutureCallback<Message>();
        this.herder.resetConnectorOffsets(connector, cb);
        Message msg = this.requestHandler.completeOrForwardRequest(cb, "/connectors/" + connector + "/offsets", "DELETE", headers, null, new TypeReference<Message>(){}, new HerderRequestHandler.IdentityTranslator(), forward);
        return Response.ok().entity((Object)msg).build();
    }

    private void checkAndPutConnectorConfigName(String connectorName, Map<String, String> connectorConfig) {
        String includedName = connectorConfig.get("name");
        if (includedName != null) {
            if (!includedName.equals(connectorName)) {
                throw new BadRequestException("Connector name configuration (" + includedName + ") doesn't match connector name in the URL (" + connectorName + ")");
            }
        } else {
            connectorConfig.put("name", connectorName);
        }
    }

    private static class CreatedConnectorInfoTranslator
    implements HerderRequestHandler.Translator<Herder.Created<ConnectorInfo>, ConnectorInfo> {
        private CreatedConnectorInfoTranslator() {
        }

        @Override
        public Herder.Created<ConnectorInfo> translate(RestClient.HttpResponse<ConnectorInfo> response) {
            boolean created = response.status() == 201;
            return new Herder.Created<ConnectorInfo>(created, response.body());
        }
    }
}

