/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.cli;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.runtime.Connect;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.WorkerInfo;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.standalone.StandaloneConfig;
import org.apache.kafka.connect.runtime.standalone.StandaloneHerder;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectStandalone {
    private static final Logger log = LoggerFactory.getLogger(ConnectStandalone.class);

    public static void main(String[] args) {
        if (args.length < 2 || Arrays.asList(args).contains("--help")) {
            log.info("Usage: ConnectStandalone worker.properties connector1.properties [connector2.properties ...]");
            Exit.exit((int)1);
        }
        try {
            Time time = Time.SYSTEM;
            log.info("Kafka Connect standalone worker initializing ...");
            long initStart = time.hiResClockMs();
            WorkerInfo initInfo = new WorkerInfo();
            initInfo.logAll();
            String workerPropsFile = args[0];
            Map workerProps = !workerPropsFile.isEmpty() ? Utils.propsToStringMap((Properties)Utils.loadProps((String)workerPropsFile)) : Collections.emptyMap();
            log.info("Scanning for plugin classes. This might take a moment ...");
            Plugins plugins = new Plugins(workerProps);
            plugins.compareAndSwapWithDelegatingLoader();
            StandaloneConfig config = new StandaloneConfig(workerProps);
            String kafkaClusterId = ConnectUtils.lookupKafkaClusterId(config);
            log.debug("Kafka cluster ID: {}", (Object)kafkaClusterId);
            RestServer rest = new RestServer(config);
            rest.initializeServer();
            URI advertisedUrl = rest.advertisedUrl();
            String workerId = advertisedUrl.getHost() + ":" + advertisedUrl.getPort();
            ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy = plugins.newPlugin(config.getString("connector.client.config.override.policy"), config, ConnectorClientConfigOverridePolicy.class);
            Worker worker = new Worker(workerId, time, plugins, config, new FileOffsetBackingStore(), connectorClientConfigOverridePolicy);
            StandaloneHerder herder = new StandaloneHerder(worker, kafkaClusterId, connectorClientConfigOverridePolicy);
            Connect connect = new Connect(herder, rest);
            log.info("Kafka Connect standalone worker initialization took {}ms", (Object)(time.hiResClockMs() - initStart));
            try {
                connect.start();
                for (final String connectorPropsFile : Arrays.copyOfRange(args, 1, args.length)) {
                    Map connectorProps = Utils.propsToStringMap((Properties)Utils.loadProps((String)connectorPropsFile));
                    FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>(new Callback<Herder.Created<ConnectorInfo>>(){

                        @Override
                        public void onCompletion(Throwable error, Herder.Created<ConnectorInfo> info) {
                            if (error != null) {
                                log.error("Failed to create job for {}", (Object)connectorPropsFile);
                            } else {
                                log.info("Created connector {}", (Object)info.result().name());
                            }
                        }
                    });
                    herder.putConnectorConfig((String)connectorProps.get("name"), connectorProps, false, cb);
                    cb.get();
                }
            }
            catch (Throwable t) {
                log.error("Stopping after connector error", t);
                connect.stop();
                Exit.exit((int)3);
            }
            connect.awaitStop();
        }
        catch (Throwable t) {
            log.error("Stopping due to error", t);
            Exit.exit((int)2);
        }
    }
}

