/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.rest.entities.ErrorMessage;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.runtime.rest.util.SSLUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();

    public static <T> HttpResponse<T> httpRequest(String url, String method, HttpHeaders headers, Object requestBodyData, TypeReference<T> responseFormat, WorkerConfig config) {
        HttpClient client = url.startsWith("https://") ? new HttpClient(SSLUtils.createSslContextFactory(config, true)) : new HttpClient();
        client.setFollowRedirects(false);
        try {
            client.start();
        }
        catch (Exception e) {
            log.error("Failed to start RestClient: ", (Throwable)e);
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to start RestClient: " + e.getMessage(), (Throwable)e);
        }
        try {
            String serializedBody = requestBodyData == null ? null : JSON_SERDE.writeValueAsString(requestBodyData);
            log.trace("Sending {} with input {} to {}", new Object[]{method, serializedBody, url});
            Request req = client.newRequest(url);
            req.method(method);
            req.accept(new String[]{"application/json"});
            req.agent("kafka-connect");
            RestClient.addHeadersToRequest(headers, req);
            if (serializedBody != null) {
                req.content((ContentProvider)new StringContentProvider(serializedBody, StandardCharsets.UTF_8), "application/json");
            }
            ContentResponse res = req.send();
            int responseCode = res.getStatus();
            log.debug("Request's response code: {}", (Object)responseCode);
            if (responseCode == 204) {
                HttpResponse<Object> httpResponse = new HttpResponse<Object>(responseCode, RestClient.convertHttpFieldsToMap(res.getHeaders()), null);
                return httpResponse;
            }
            if (responseCode >= 400) {
                ErrorMessage errorMessage = (ErrorMessage)JSON_SERDE.readValue(res.getContentAsString(), ErrorMessage.class);
                throw new ConnectRestException(responseCode, errorMessage.errorCode(), errorMessage.message());
            }
            if (responseCode >= 200 && responseCode < 300) {
                Object result = JSON_SERDE.readValue(res.getContentAsString(), responseFormat);
                HttpResponse<Object> httpResponse = new HttpResponse<Object>(responseCode, RestClient.convertHttpFieldsToMap(res.getHeaders()), result);
                return httpResponse;
            }
            try {
                throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Unexpected status code when handling forwarded request: " + responseCode);
            }
            catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
                log.error("IO error forwarding REST request: ", (Throwable)e);
                throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, "IO Error trying to forward REST request: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (client != null) {
                try {
                    client.stop();
                }
                catch (Exception e) {
                    log.error("Failed to stop HTTP client", (Throwable)e);
                }
            }
        }
    }

    private static void addHeadersToRequest(HttpHeaders headers, Request req) {
        String credentialAuthorization;
        if (headers != null && (credentialAuthorization = headers.getHeaderString("Authorization")) != null) {
            req.header("Authorization", credentialAuthorization);
        }
    }

    private static Map<String, String> convertHttpFieldsToMap(HttpFields httpFields) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (httpFields == null || httpFields.size() == 0) {
            return headers;
        }
        for (HttpField field : httpFields) {
            headers.put(field.getName(), field.getValue());
        }
        return headers;
    }

    public static class HttpResponse<T> {
        private int status;
        private Map<String, String> headers;
        private T body;

        public HttpResponse(int status, Map<String, String> headers, T body) {
            this.status = status;
            this.headers = headers;
            this.body = body;
        }

        public int status() {
            return this.status;
        }

        public Map<String, String> headers() {
            return this.headers;
        }

        public T body() {
            return this.body;
        }
    }
}

