/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceList;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UddiFindBinding {
    private UDDISecurityPortType security = null;
    private UDDIInquiryPortType inquiry = null;

    public UddiFindBinding() {
        try {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.inquiry = transport.getUDDIInquiryService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fire(String token) {
        try {
            GetAuthToken getAuthTokenRoot = new GetAuthToken();
            getAuthTokenRoot.setUserID("root");
            getAuthTokenRoot.setCred("root");
            if (token == null) {
                AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
                System.out.println("root AUTHTOKEN = don't log auth tokens!");
                token = rootAuthToken.getAuthInfo();
            }
            FindService fs = new FindService();
            fs.setAuthInfo(token);
            fs.getName().add(new Name());
            ((Name)fs.getName().get(0)).setValue("%");
            fs.setFindQualifiers(new FindQualifiers());
            fs.getFindQualifiers().getFindQualifier().add("approximateMatch");
            ServiceList findService = this.inquiry.findService(fs);
            System.out.println(findService.getServiceInfos().getServiceInfo().size());
            GetServiceDetail gs = new GetServiceDetail();
            for (int i = 0; i < findService.getServiceInfos().getServiceInfo().size(); ++i) {
                gs.getServiceKey().add(((ServiceInfo)findService.getServiceInfos().getServiceInfo().get(i)).getServiceKey());
            }
            ServiceDetail serviceDetail = this.inquiry.getServiceDetail(gs);
            for (int i = 0; i < serviceDetail.getBusinessService().size(); ++i) {
                if (((BusinessService)serviceDetail.getBusinessService().get(i)).getBindingTemplates() == null) continue;
                for (int k = 0; k < ((BusinessService)serviceDetail.getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().size(); ++k) {
                    if (((BindingTemplate)((BusinessService)serviceDetail.getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().get(k)).getAccessPoint() == null) continue;
                    System.out.println(((BindingTemplate)((BusinessService)serviceDetail.getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().get(k)).getAccessPoint().getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UddiFindBinding sp = new UddiFindBinding();
        sp.fire(null);
    }
}

