/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import org.apache.johnzon.jsonb.api.experimental.JsonbExtension;
import org.apache.johnzon.mapper.JsonObjectGenerator;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;
import org.apache.johnzon.mapper.util.ArrayUtil;

public class JohnzonJsonb
implements Jsonb,
AutoCloseable,
JsonbExtension {
    private final Mapper delegate;
    private final boolean ijson;
    private final Consumer<JohnzonJsonb> onClose;
    private final Map<Class<?>, Boolean> structureAwareIo = new ConcurrentHashMap();

    public JohnzonJsonb(Mapper build, boolean ijson, Consumer<JohnzonJsonb> onClose) {
        this.delegate = build;
        this.ijson = ijson;
        this.onClose = onClose;
    }

    public <T> T fromJson(String str, Class<T> type) throws JsonbException {
        try {
            if (this.isArray(type)) {
                return (T)this.delegate.readTypedArray((Reader)new StringReader(str), type.getComponentType(), type);
            }
            if (JsonArray.class == type) {
                return (T)this.delegate.readJsonArray((Reader)new StringReader(str));
            }
            if (Collection.class.isAssignableFrom(type)) {
                return (T)this.delegate.readCollection((Reader)new StringReader(str), (ParameterizedType)new JohnzonParameterizedType(type, new Type[]{Object.class}));
            }
            Type mappingType = this.unwrapPrimitiveOptional(type);
            Object object = this.delegate.readObject(str, mappingType);
            if (mappingType != type) {
                return this.wrapPrimitiveOptional(object, type);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    private <T> T wrapPrimitiveOptional(Object object, Type type) {
        if (OptionalDouble.class == type) {
            if (object == null) {
                return (T)OptionalDouble.empty();
            }
            return (T)OptionalDouble.of(((Number)Number.class.cast(object)).doubleValue());
        }
        if (OptionalInt.class == type) {
            if (object == null) {
                return (T)OptionalInt.empty();
            }
            return (T)OptionalInt.of(((Number)Number.class.cast(object)).intValue());
        }
        if (OptionalLong.class == type) {
            if (object == null) {
                return (T)OptionalLong.empty();
            }
            return (T)OptionalLong.of(((Number)Number.class.cast(object)).longValue());
        }
        return (T)Optional.ofNullable(object);
    }

    private Type unwrapPrimitiveOptional(Type type) {
        ParameterizedType pt;
        if (OptionalDouble.class == type) {
            return Double.TYPE;
        }
        if (OptionalInt.class == type) {
            return Integer.TYPE;
        }
        if (OptionalLong.class == type) {
            return Long.TYPE;
        }
        if (ParameterizedType.class.isInstance(type) && Optional.class == (pt = (ParameterizedType)ParameterizedType.class.cast(type)).getRawType()) {
            return pt.getActualTypeArguments()[0];
        }
        return type;
    }

    public <T> T fromJson(String str, Type runtimeType) throws JsonbException {
        try {
            if (this.isArray(runtimeType)) {
                Class cast = (Class)Class.class.cast(runtimeType);
                return (T)this.delegate.readTypedArray((Reader)new StringReader(str), cast.getComponentType(), cast);
            }
            if (JsonArray.class == runtimeType) {
                return (T)this.delegate.readJsonArray((Reader)new StringReader(str));
            }
            if (this.isCollection(runtimeType)) {
                return (T)this.delegate.readCollection((Reader)new StringReader(str), (ParameterizedType)ParameterizedType.class.cast(runtimeType));
            }
            Type mappingType = this.unwrapPrimitiveOptional(runtimeType);
            Object object = this.delegate.readObject(str, mappingType);
            if (mappingType != runtimeType) {
                return this.wrapPrimitiveOptional(object, runtimeType);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public <T> T fromJson(Reader reader, Class<T> type) throws JsonbException {
        boolean valueProvider = this.isValueProvider(reader);
        try {
            if (this.isArray(type)) {
                if (valueProvider) {
                    return (T)this.delegate.readObject((JsonValue)((Supplier)((Object)reader)).get(), type);
                }
                return (T)this.delegate.readTypedArray(reader, type.getComponentType(), type);
            }
            if (JsonArray.class == type) {
                if (valueProvider) {
                    return (T)this.delegate.readObject((JsonValue)((Supplier)((Object)reader)).get(), type);
                }
                return (T)this.delegate.readJsonArray(reader);
            }
            if (Collection.class.isAssignableFrom(type)) {
                if (valueProvider) {
                    return (T)this.delegate.readObject((JsonValue)((Supplier)((Object)reader)).get(), type);
                }
                return (T)this.delegate.readCollection(reader, (ParameterizedType)new JohnzonParameterizedType(type, new Type[]{Object.class}));
            }
            if (valueProvider) {
                return (T)this.delegate.readObject((JsonValue)((Supplier)((Object)reader)).get(), type);
            }
            Type mappingType = this.unwrapPrimitiveOptional(type);
            Object object = this.delegate.readObject(reader, mappingType);
            if (mappingType != type) {
                return this.wrapPrimitiveOptional(object, type);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public <T> T fromJson(Reader reader, Type runtimeType) throws JsonbException {
        if (this.isValueProvider(reader)) {
            return (T)this.delegate.readObject((JsonValue)((Supplier)((Object)reader)).get(), runtimeType);
        }
        try {
            if (this.isArray(runtimeType)) {
                Class type = (Class)Class.class.cast(runtimeType);
                return (T)this.delegate.readTypedArray(reader, type.getComponentType(), type);
            }
            if (JsonArray.class == runtimeType) {
                return (T)this.delegate.readJsonArray(reader);
            }
            if (this.isCollection(runtimeType)) {
                return (T)this.delegate.readCollection(reader, (ParameterizedType)ParameterizedType.class.cast(runtimeType));
            }
            Type mappingType = this.unwrapPrimitiveOptional(runtimeType);
            Object object = this.delegate.readObject(reader, mappingType);
            if (mappingType != runtimeType) {
                return this.wrapPrimitiveOptional(object, runtimeType);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public <T> T fromJson(InputStream stream, Class<T> type) throws JsonbException {
        try {
            if (this.isArray(type)) {
                return (T)this.delegate.readTypedArray(stream, type.getComponentType(), type);
            }
            if (JsonArray.class == type) {
                return (T)this.delegate.readJsonArray(stream);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return (T)this.delegate.readCollection(stream, (ParameterizedType)new JohnzonParameterizedType(type, new Type[]{Object.class}));
            }
            Type mappingType = this.unwrapPrimitiveOptional(type);
            Object object = this.delegate.readObject(stream, mappingType);
            if (mappingType != type) {
                return this.wrapPrimitiveOptional(object, type);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public <T> T fromJson(InputStream stream, Type runtimeType) throws JsonbException {
        try {
            if (this.isArray(runtimeType)) {
                Class type = (Class)Class.class.cast(runtimeType);
                return (T)this.delegate.readTypedArray(stream, type.getComponentType(), type);
            }
            if (JsonArray.class == runtimeType) {
                return (T)this.delegate.readJsonArray(stream);
            }
            if (this.isCollection(runtimeType)) {
                return (T)this.delegate.readCollection(stream, (ParameterizedType)ParameterizedType.class.cast(runtimeType));
            }
            Type mappingType = this.unwrapPrimitiveOptional(runtimeType);
            Object object = this.delegate.readObject(stream, mappingType);
            if (mappingType != runtimeType) {
                return this.wrapPrimitiveOptional(object, runtimeType);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    public String toJson(Object inObject) throws JsonbException {
        try {
            Object object = this.unwrapOptional(inObject);
            if (object == null) {
                return "null";
            }
            if (this.isArray(object.getClass())) {
                return this.delegate.writeArrayAsString(this.toArray(object));
            }
            if (Collection.class.isInstance(object)) {
                return this.delegate.writeArrayAsString((Collection)Collection.class.cast(object));
            }
            if (this.ijson && this.isNotObjectOrArray(object)) {
                throw new JsonbException("I-JSON mode only accepts arrays and objects as root instances");
            }
            return this.delegate.writeObjectAsString(object);
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    private Object[] toArray(Object object) {
        Object[] array;
        Class<?> componentType = object.getClass().getComponentType();
        if (Integer.TYPE == componentType) {
            int length = ArrayUtil.getArrayLength((Object)object);
            array = new Integer[length];
            for (int i = 0; i < length; ++i) {
                array[i] = ((int[])object)[i];
            }
        } else if (Double.TYPE == componentType) {
            int length = ArrayUtil.getArrayLength((Object)object);
            array = new Double[length];
            for (int i = 0; i < length; ++i) {
                array[i] = ((double[])object)[i];
            }
        } else if (Byte.TYPE == componentType) {
            int length = ArrayUtil.getArrayLength((Object)object);
            array = new Byte[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Byte.valueOf(((byte[])object)[i]);
            }
        } else if (Character.TYPE == componentType) {
            int length = ArrayUtil.getArrayLength((Object)object);
            array = new Character[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Character.valueOf(((char[])object)[i]);
            }
        } else if (Float.TYPE == componentType) {
            int length = ArrayUtil.getArrayLength((Object)object);
            array = new Float[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Float.valueOf(((float[])object)[i]);
            }
        } else if (Long.TYPE == componentType) {
            int length = ArrayUtil.getArrayLength((Object)object);
            array = new Long[length];
            for (int i = 0; i < length; ++i) {
                array[i] = ((long[])object)[i];
            }
        } else if (Short.TYPE == componentType) {
            int length = ArrayUtil.getArrayLength((Object)object);
            array = new Short[length];
            for (int i = 0; i < length; ++i) {
                array[i] = ((short[])object)[i];
            }
        } else if (Boolean.TYPE == componentType) {
            int length = ArrayUtil.getArrayLength((Object)object);
            array = new Boolean[length];
            for (int i = 0; i < length; ++i) {
                array[i] = ((boolean[])object)[i];
            }
        } else {
            array = (Object[])object;
        }
        return array;
    }

    public String toJson(Object inObject, Type runtimeType) throws JsonbException {
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(runtimeType)) {
            return this.delegate.writeArrayAsString(this.toArray(object));
        }
        if (this.isCollection(runtimeType)) {
            return this.delegate.writeArrayAsString((Collection)Collection.class.cast(object));
        }
        if (this.ijson && this.isNotObjectOrArray(object)) {
            throw new JsonbException("I-JSON mode only accepts arrays and objects as root instances");
        }
        return this.delegate.writeObjectAsString(object);
    }

    public void toJson(Object inObject, Writer writer) throws JsonbException {
        if (this.isValueConsumer(writer)) {
            ((Consumer)Consumer.class.cast(writer)).accept(this.delegate.toStructure(inObject));
            return;
        }
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(object.getClass())) {
            this.delegate.writeArray((Object[])object, writer);
        } else if (Collection.class.isInstance(object)) {
            this.delegate.writeArray((Collection)Collection.class.cast(object), writer);
        } else {
            if (this.ijson && this.isNotObjectOrArray(object)) {
                throw new JsonbException("I-JSON mode only accepts arrays and objects as root instances");
            }
            this.delegate.writeObject(object, writer);
        }
    }

    public void toJson(Object inObject, Type runtimeType, Writer writer) throws JsonbException {
        if (this.isValueConsumer(writer)) {
            ((Consumer)Consumer.class.cast(writer)).accept(this.delegate.toStructure(inObject));
            return;
        }
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(runtimeType)) {
            this.delegate.writeArray((Object[])object, writer);
        } else if (this.isCollection(runtimeType)) {
            this.delegate.writeArray((Collection)Collection.class.cast(object), writer);
        } else {
            if (this.ijson && this.isNotObjectOrArray(object)) {
                throw new JsonbException("I-JSON mode only accepts arrays and objects as root instances");
            }
            this.delegate.writeObject(object, writer);
        }
    }

    public void toJson(Object inObject, OutputStream stream) throws JsonbException {
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(object.getClass())) {
            this.delegate.writeArray(this.toArray(object), stream);
        } else if (Collection.class.isInstance(object)) {
            this.delegate.writeArray((Collection)Collection.class.cast(object), stream);
        } else {
            if (this.ijson && this.isNotObjectOrArray(object)) {
                throw new JsonbException("I-JSON mode only accepts arrays and objects as root instances");
            }
            this.delegate.writeObject(object, stream);
        }
    }

    public void toJson(Object inObject, Type runtimeType, OutputStream stream) throws JsonbException {
        Object object = this.unwrapOptional(inObject);
        if (object != null && this.isArray(runtimeType)) {
            this.delegate.writeArray((Object[])object, stream);
        } else if (this.isCollection(runtimeType)) {
            this.delegate.writeArray((Collection)Collection.class.cast(object), stream);
        } else {
            if (this.ijson && this.isNotObjectOrArray(object)) {
                throw new JsonbException("I-JSON mode only accepts arrays and objects as root instances");
            }
            this.delegate.writeObject(object, stream);
        }
    }

    private boolean isNotObjectOrArray(Object object) {
        if (String.class.isInstance(object) || Number.class.isInstance(object) || Boolean.class.isInstance(object)) {
            return true;
        }
        if (JsonValue.class.isInstance(object)) {
            switch (((JsonValue)JsonValue.class.cast(object)).getValueType()) {
                case ARRAY: 
                case OBJECT: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private Object unwrapOptional(Object inObject) {
        if (Optional.class.isInstance(inObject)) {
            return ((Optional)Optional.class.cast(inObject)).orElse(null);
        }
        if (OptionalInt.class.isInstance(inObject)) {
            OptionalInt optionalInt = (OptionalInt)OptionalInt.class.cast(inObject);
            return optionalInt.isPresent() ? Integer.valueOf(optionalInt.getAsInt()) : null;
        }
        if (OptionalLong.class.isInstance(inObject)) {
            OptionalLong optionalLong = (OptionalLong)OptionalLong.class.cast(inObject);
            return optionalLong.isPresent() ? Long.valueOf(optionalLong.getAsLong()) : null;
        }
        if (OptionalDouble.class.isInstance(inObject)) {
            OptionalDouble optionalDouble = (OptionalDouble)OptionalDouble.class.cast(inObject);
            return optionalDouble.isPresent() ? Double.valueOf(optionalDouble.getAsDouble()) : null;
        }
        return inObject;
    }

    private boolean isArray(Type runtimeType) {
        return Class.class.isInstance(runtimeType) && ((Class)Class.class.cast(runtimeType)).isArray();
    }

    private boolean isCollection(Type runtimeType) {
        if (!ParameterizedType.class.isInstance(runtimeType)) {
            return runtimeType == List.class || runtimeType == Set.class || runtimeType == SortedSet.class || runtimeType == Collection.class;
        }
        Type rawType = ((ParameterizedType)ParameterizedType.class.cast(runtimeType)).getRawType();
        return Class.class.isInstance(rawType) && Collection.class.isAssignableFrom((Class)Class.class.cast(rawType));
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        finally {
            if (this.onClose != null) {
                this.onClose.accept(this);
            }
        }
    }

    @Override
    public <T> T fromJsonValue(JsonValue json, Class<T> type) {
        return this.fromJsonValue(json, (Type)Type.class.cast(type));
    }

    @Override
    public JsonValue toJsonValue(Object object) {
        return this.toJsonValue(object, object.getClass());
    }

    @Override
    public <T> T fromJsonValue(JsonValue json, Type type) {
        switch (json.getValueType()) {
            case NULL: {
                if (Class.class.isInstance(type) && ((Class)Class.class.cast(type)).isPrimitive()) {
                    throw new JsonbException("can't map a primritive to null");
                }
                return null;
            }
            case STRING: {
                if (String.class != type) {
                    throw new JsonbException("STRING json can't be casted to " + type);
                }
                return (T)((JsonString)JsonString.class.cast(json)).getString();
            }
            case TRUE: 
            case FALSE: {
                if (Boolean.class != type && Boolean.TYPE != type) {
                    throw new JsonbException("TRUE and FALSE json can't be casted to " + type);
                }
                return (T)Boolean.valueOf(JsonValue.ValueType.TRUE == json.getValueType());
            }
            case NUMBER: {
                if (!Class.class.isInstance(type) || !Number.class.isAssignableFrom((Class)Class.class.cast(type))) {
                    throw new JsonbException("NUMBER json can't be casted to " + type);
                }
                JsonNumber jsonNumber = (JsonNumber)JsonNumber.class.cast(json);
                if (Integer.TYPE == type || Integer.class == type) {
                    return (T)Integer.valueOf(jsonNumber.intValue());
                }
                if (Long.TYPE == type || Long.class == type) {
                    return (T)Long.valueOf(jsonNumber.longValue());
                }
                if (Double.TYPE == type || Double.class == type) {
                    return (T)Double.valueOf(jsonNumber.doubleValue());
                }
                if (Float.TYPE == type || Float.class == type) {
                    return (T)Float.valueOf((float)jsonNumber.doubleValue());
                }
                if (Byte.TYPE == type || Byte.class == type) {
                    return (T)Byte.valueOf((byte)jsonNumber.intValue());
                }
                if (Short.TYPE == type || Short.class == type) {
                    return (T)Short.valueOf((short)jsonNumber.intValue());
                }
                if (BigInteger.class == type) {
                    return (T)jsonNumber.bigIntegerValue();
                }
                return (T)jsonNumber.bigDecimalValue();
            }
            case ARRAY: 
            case OBJECT: {
                return (T)this.delegate.readObject((JsonValue)JsonStructure.class.cast(json), type);
            }
        }
        throw new JsonbException("Unsupported type: " + json.getValueType());
    }

    @Override
    public JsonValue toJsonValue(Object rawObject, Type runtimeType) {
        if (JsonValue.class.isInstance(rawObject)) {
            return (JsonValue)JsonValue.class.cast(rawObject);
        }
        try (JsonObjectGenerator jsonObjectGenerator = new JsonObjectGenerator(this.delegate.getBuilderFactory());){
            this.delegate.writeObjectWithGenerator(this.unwrapOptional(rawObject), (JsonGenerator)jsonObjectGenerator);
            jsonObjectGenerator.flush();
            JsonValue jsonValue = jsonObjectGenerator.getResult();
            return jsonValue;
        }
    }

    @Override
    public <T> T fromJson(JsonParser json, Class<T> type) {
        return type.cast(this.fromJson(json, (Type)Type.class.cast(type)));
    }

    @Override
    public <T> T fromJson(JsonParser parser, Type runtimeType) {
        try {
            if (this.isArray(runtimeType)) {
                Class type = (Class)Class.class.cast(runtimeType);
                return (T)this.delegate.readTypedArray(parser, type.getComponentType(), type);
            }
            if (JsonArray.class == runtimeType) {
                return (T)this.delegate.readJsonArray(parser);
            }
            if (this.isCollection(runtimeType)) {
                return (T)this.delegate.readCollection(parser, (ParameterizedType)ParameterizedType.class.cast(runtimeType));
            }
            Type mappingType = this.unwrapPrimitiveOptional(runtimeType);
            Object object = this.delegate.readObject(parser, mappingType);
            if (mappingType != runtimeType) {
                return this.wrapPrimitiveOptional(object, runtimeType);
            }
            return (T)object;
        }
        catch (MapperException me) {
            throw new JsonbException(me.getMessage(), (Throwable)me);
        }
    }

    @Override
    public void toJson(Object object, JsonGenerator jsonGenerator) {
        this.delegate.writeObjectWithGenerator(this.unwrapOptional(object), jsonGenerator);
    }

    @Override
    public void toJson(Object object, Type runtimeType, JsonGenerator jsonGenerator) {
        this.toJson(object, jsonGenerator);
    }

    private boolean isValueProvider(Reader reader) {
        Class<?> key = reader.getClass();
        Boolean exists = this.structureAwareIo.get(key);
        if (exists == null) {
            exists = this.matchesType(key, Supplier.class);
            this.structureAwareIo.putIfAbsent(key, exists);
        }
        return exists;
    }

    private boolean isValueConsumer(Writer writer) {
        Class<?> key = writer.getClass();
        Boolean exists = this.structureAwareIo.get(key);
        if (exists == null) {
            exists = this.matchesType(writer.getClass(), Consumer.class);
            this.structureAwareIo.putIfAbsent(key, exists);
        }
        return exists;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesType(Class<?> type, Class<?> rawType) {
        if (!rawType.isAssignableFrom(type)) return false;
        if (!Stream.of(type.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).anyMatch(pt -> pt.getRawType() == rawType && pt.getActualTypeArguments().length == 1 && Class.class.isInstance(pt.getActualTypeArguments()[0]) && JsonValue.class.isAssignableFrom((Class)Class.class.cast(pt.getActualTypeArguments()[0])))) return false;
        return true;
    }
}

