/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.extras.polymorphism;

import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Polymorphic {
    private Polymorphic() {
    }

    private static String getId(Class<?> type) {
        JsonId mapping = type.getAnnotation(JsonId.class);
        if (mapping == null) {
            throw new IllegalArgumentException("No @JsonId on " + String.valueOf(type));
        }
        String id = mapping.value();
        return id.isEmpty() ? type.getSimpleName() : id;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface JsonId {
        public String value() default "";
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface JsonChildren {
        public Class<?>[] value();
    }

    public static class Wrapper<T> {
        @JsonbProperty(value="_type")
        public String id;
        @JsonbProperty(value="_value")
        public T value;

        private Wrapper(String id, T obj) {
            this.id = id;
            this.value = obj;
        }
    }

    public static class DeSerializer<T>
    implements JsonbDeserializer<T> {
        private volatile transient ConcurrentMap<String, Type> classMapping = new ConcurrentHashMap<String, Type>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
            this.ensureInit();
            if (this.classMapping == null || this.classMapping.isEmpty()) {
                DeSerializer deSerializer = this;
                synchronized (deSerializer) {
                    if (this.classMapping == null || this.classMapping.isEmpty()) {
                        this.loadMapping(rtType);
                    }
                }
            }
            if (!parser.hasNext()) {
                return null;
            }
            this.eatStartObject(parser);
            this.eatTypeKey(parser);
            String typeId = this.getTypeValue(parser);
            this.eatValueStart(parser);
            Type type = Objects.requireNonNull((Type)this.classMapping.get(typeId), "No mapping for " + typeId);
            parser.next();
            return (T)ctx.deserialize(type, parser);
        }

        private void loadMapping(Type rtType) {
            Class from;
            if (ParameterizedType.class.isInstance(rtType)) {
                Type rawType = ((ParameterizedType)ParameterizedType.class.cast(rtType)).getRawType();
                if (!Class.class.isInstance(rawType)) {
                    throw new IllegalStateException("Unsupported type: " + String.valueOf(rawType));
                }
                from = (Class)Class.class.cast(rawType);
            } else if (Class.class.isInstance(rtType)) {
                from = (Class)Class.class.cast(rtType);
            } else {
                throw new IllegalStateException("Unsupported type: " + String.valueOf(rtType));
            }
            JsonChildren classes = from.getAnnotation(JsonChildren.class);
            if (classes == null) {
                throw new IllegalArgumentException("No @JsonChildren on " + String.valueOf(from));
            }
            this.classMapping.putAll(Stream.of(classes.value()).collect(Collectors.toMap(x$0 -> Polymorphic.getId(x$0), Function.identity())));
        }

        private void eatStartObject(JsonParser parser) {
            if (parser.next() != JsonParser.Event.START_OBJECT) {
                throw new IllegalArgumentException("Invalid JSON, expected START_OBJECT");
            }
        }

        private void eatTypeKey(JsonParser parser) {
            if (!parser.hasNext() || parser.next() != JsonParser.Event.KEY_NAME) {
                throw new IllegalArgumentException("Invalid JSON, expected KEY_NAME");
            }
            if (!"_type".equals(parser.getString())) {
                throw new IllegalArgumentException("Expected key _type");
            }
        }

        private void eatValueStart(JsonParser parser) {
            if (!parser.hasNext() || parser.next() != JsonParser.Event.KEY_NAME) {
                throw new IllegalArgumentException("Invalid JSON, expected KEY_NAME");
            }
            if (!parser.hasNext() || !"_value".equals(parser.getString())) {
                throw new IllegalArgumentException("Expected key _value");
            }
        }

        private String getTypeValue(JsonParser parser) {
            JsonParser.Event next = parser.next();
            if (!parser.hasNext() || next != JsonParser.Event.VALUE_STRING) {
                throw new IllegalArgumentException("Unexpected event " + String.valueOf(next));
            }
            return parser.getString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureInit() {
            if (this.classMapping == null) {
                DeSerializer deSerializer = this;
                synchronized (deSerializer) {
                    if (this.classMapping == null) {
                        this.classMapping = new ConcurrentHashMap<String, Type>();
                    }
                }
            }
        }
    }

    public static class Serializer<T>
    implements JsonbSerializer<T> {
        private volatile transient ConcurrentMap<Class<?>, String> idMapping = new ConcurrentHashMap();

        public void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
            this.ensureInit();
            ctx.serialize(new Wrapper<T>(this.getOrLoadId(obj), obj), generator);
        }

        private String getOrLoadId(T obj) {
            Class<?> type = obj.getClass();
            String id = (String)this.idMapping.get(type);
            if (id == null) {
                id = Polymorphic.getId(type);
                this.idMapping.putIfAbsent(type, id);
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureInit() {
            if (this.idMapping == null) {
                Serializer serializer = this;
                synchronized (serializer) {
                    if (this.idMapping == null) {
                        this.idMapping = new ConcurrentHashMap();
                    }
                }
            }
        }
    }
}

