/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.avalon;

public final class CLOptionDescriptor {
    public static final int ARGUMENT_REQUIRED = 2;
    public static final int ARGUMENT_OPTIONAL = 4;
    public static final int ARGUMENT_DISALLOWED = 8;
    public static final int ARGUMENTS_REQUIRED_2 = 16;
    public static final int DUPLICATES_ALLOWED = 32;
    private final int id;
    private final int flags;
    private final String name;
    private final String description;
    private final int[] incompatible;

    public CLOptionDescriptor(String name, int flags, int id, String description) {
        int[] nArray;
        this.checkFlags(flags);
        this.id = id;
        this.name = name;
        this.flags = flags;
        this.description = description;
        if ((flags & 0x20) != 0) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = id;
        }
        this.incompatible = nArray;
    }

    public CLOptionDescriptor(String name, int flags, int id, String description, CLOptionDescriptor[] incompatible) {
        this.checkFlags(flags);
        this.id = id;
        this.name = name;
        this.flags = flags;
        this.description = description;
        this.incompatible = new int[incompatible.length];
        for (int i = 0; i < incompatible.length; ++i) {
            this.incompatible[i] = incompatible[i].getId();
        }
    }

    private void checkFlags(int flags) {
        int modeCount = 0;
        if ((2 & flags) == 2) {
            ++modeCount;
        }
        if ((4 & flags) == 4) {
            ++modeCount;
        }
        if ((8 & flags) == 8) {
            ++modeCount;
        }
        if ((0x10 & flags) == 16) {
            ++modeCount;
        }
        if (0 == modeCount) {
            String message = "No mode specified for option " + this;
            throw new IllegalStateException(message);
        }
        if (1 != modeCount) {
            String message = "Multiple modes specified for option " + this;
            throw new IllegalStateException(message);
        }
    }

    protected final int[] getIncompatible() {
        return this.incompatible;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final int getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[OptionDescriptor ");
        sb.append(this.name);
        sb.append(", ");
        sb.append(this.id);
        sb.append(", ");
        sb.append(this.flags);
        sb.append(", ");
        sb.append(this.description);
        sb.append(" ]");
        return sb.toString();
    }
}

