/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jmeter.protocol.tcp.sampler.BinaryTCPClientImpl;
import org.apache.jmeter.protocol.tcp.sampler.ReadException;
import org.apache.jmeter.protocol.tcp.sampler.TCPClientDecorator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class LengthPrefixedBinaryTCPClientImpl
extends TCPClientDecorator {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final int lengthPrefixLen = JMeterUtils.getPropDefault((String)"tcp.binarylength.prefix.length", (int)2);

    public LengthPrefixedBinaryTCPClientImpl() {
        super(new BinaryTCPClientImpl());
        this.tcpClient.setEolByte(128);
    }

    @Override
    public void write(OutputStream os, String s) throws IOException {
        os.write(LengthPrefixedBinaryTCPClientImpl.intToByteArray(s.length() / 2, this.lengthPrefixLen));
        if (log.isDebugEnabled()) {
            log.debug("Wrote: " + s.length() / 2 + " bytes");
        }
        this.tcpClient.write(os, s);
    }

    @Override
    public void write(OutputStream os, InputStream is) throws IOException {
        this.tcpClient.write(os, is);
    }

    @Override
    public String read(InputStream is) throws ReadException {
        byte[] msg = new byte[]{};
        int msgLen = 0;
        byte[] lengthBuffer = new byte[this.lengthPrefixLen];
        try {
            int bytes;
            if (is.read(lengthBuffer, 0, this.lengthPrefixLen) == this.lengthPrefixLen && (bytes = JOrphanUtils.read((InputStream)is, (byte[])(msg = new byte[msgLen = LengthPrefixedBinaryTCPClientImpl.byteArrayToInt(lengthBuffer)]), (int)0, (int)msgLen)) < msgLen) {
                log.warn("Incomplete message read, expected: " + msgLen + " got: " + bytes);
            }
            String buffer = JOrphanUtils.baToHexString((byte[])msg);
            if (log.isDebugEnabled()) {
                log.debug("Read: " + msgLen + "\n" + buffer);
            }
            return buffer;
        }
        catch (IOException e) {
            throw new ReadException("", e, JOrphanUtils.baToHexString((byte[])msg));
        }
    }

    @Override
    public byte getEolByte() {
        return this.tcpClient.getEolByte();
    }

    @Override
    public void setEolByte(int eolInt) {
        throw new UnsupportedOperationException("Cannot set eomByte for prefixed messages");
    }
}

