/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;
import org.apache.jmeter.protocol.tcp.sampler.AbstractTCPClient;
import org.apache.jmeter.protocol.tcp.sampler.ReadException;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TCPClientImpl
extends AbstractTCPClient {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private int eolInt = JMeterUtils.getPropDefault((String)"tcp.eolByte", (int)1000);
    private String charset = JMeterUtils.getPropDefault((String)"tcp.charset", (String)Charset.defaultCharset().name());

    public TCPClientImpl() {
        this.setEolByte(this.eolInt);
        if (this.useEolByte) {
            log.info("Using eolByte=" + this.eolByte);
        }
        this.setCharset(this.charset);
        String configuredCharset = JMeterUtils.getProperty((String)"tcp.charset");
        if (StringUtils.isEmpty((String)configuredCharset)) {
            log.info("Using platform default charset:" + this.charset);
        } else {
            log.info("Using charset:" + configuredCharset);
        }
    }

    public void write(OutputStream os, String s) throws IOException {
        os.write(s.getBytes(this.charset));
        os.flush();
        if (log.isDebugEnabled()) {
            log.debug("Wrote: " + s);
        }
    }

    public void write(OutputStream os, InputStream is) throws IOException {
        byte[] buff = new byte[512];
        while (is.read(buff) > 0) {
            os.write(buff);
            os.flush();
        }
    }

    public String read(InputStream is) throws ReadException {
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int x = 0;
            while ((x = is.read(buffer)) > -1) {
                w.write(buffer, 0, x);
                if (!this.useEolByte || buffer[x - 1] != this.eolByte) continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Read: " + w.size() + "\n" + w.toString());
            }
            return w.toString(this.charset);
        }
        catch (IOException e) {
            throw new ReadException("", e, w.toString());
        }
    }
}

