/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.mail.sampler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.smtp.sampler.protocol.LocalTrustStoreSSLSocketFactory;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.TrustAllSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailReaderSampler
extends AbstractSampler
implements Interruptible {
    private static final Logger log = LoggerFactory.getLogger(MailReaderSampler.class);
    private static final long serialVersionUID = 240L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private static final String SERVER_TYPE = "host_type";
    private static final String SERVER = "host";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String FOLDER = "folder";
    private static final String DELETE = "delete";
    private static final String NUM_MESSAGES = "num_messages";
    private static final String NEW_LINE = "\n";
    private static final String STORE_MIME_MESSAGE = "storeMimeMessage";
    private static final String HEADER_ONLY = "headerOnly";
    private static final boolean HEADER_ONLY_DEFAULT = false;
    private static final String RFC_822_DEFAULT_ENCODING = "iso-8859-1";
    public static final String DEFAULT_PROTOCOL = "pop3";
    private static final String TRUST_ALL_SOCKET_FACTORY = TrustAllSSLSocketFactory.class.getName();
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    public static final int ALL_MESSAGES = -1;
    private volatile boolean busy;

    public boolean isUseLocalTrustStore() {
        return this.getPropertyAsBoolean("SMTPSampler.useLocalTrustStore");
    }

    public String getTrustStoreToUse() {
        return this.getPropertyAsString("SMTPSampler.trustStoreToUse");
    }

    public boolean isUseSSL() {
        return this.getPropertyAsBoolean("SMTPSampler.useSSL");
    }

    public boolean isUseStartTLS() {
        return this.getPropertyAsBoolean("SMTPSampler.useStartTLS");
    }

    public boolean isTrustAllCerts() {
        return this.getPropertyAsBoolean("SMTPSampler.trustAllCerts");
    }

    public boolean isEnforceStartTLS() {
        return this.getPropertyAsBoolean("SMTPSampler.enforceStartTLS");
    }

    public MailReaderSampler() {
        this.setServerType(DEFAULT_PROTOCOL);
        this.setFolder("INBOX");
        this.setNumMessages(-1);
        this.setDeleteMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult sample(Entry e) {
        SampleResult parent = new SampleResult();
        boolean isOK = false;
        boolean deleteMessages = this.getDeleteMessages();
        String serverProtocol = this.getServerType();
        parent.setSampleLabel(this.getName());
        String samplerString = this.toString();
        parent.setSamplerData(samplerString);
        parent.sampleStart();
        try {
            Properties props = new Properties();
            if (this.isUseStartTLS()) {
                props.setProperty(this.mailProp(serverProtocol, "starttls.enable"), TRUE);
                if (this.isEnforceStartTLS()) {
                    props.setProperty(this.mailProp(serverProtocol, "starttls.require"), TRUE);
                }
            }
            if (this.isTrustAllCerts()) {
                if (this.isUseSSL() || this.isUseStartTLS()) {
                    props.setProperty(this.mailProp(serverProtocol, "ssl.socketFactory.class"), TRUST_ALL_SOCKET_FACTORY);
                    props.setProperty(this.mailProp(serverProtocol, "ssl.socketFactory.fallback"), FALSE);
                }
            } else if (this.isUseLocalTrustStore()) {
                File truststore = new File(this.getTrustStoreToUse());
                log.info("load local truststore - try to load truststore from: " + truststore.getAbsolutePath());
                if (!truststore.exists()) {
                    log.info("load local truststore -Failed to load truststore from: " + truststore.getAbsolutePath());
                    truststore = new File(FileServer.getFileServer().getBaseDir(), this.getTrustStoreToUse());
                    log.info("load local truststore -Attempting to read truststore from:  " + truststore.getAbsolutePath());
                    if (!truststore.exists()) {
                        log.info("load local truststore -Failed to load truststore from: " + truststore.getAbsolutePath() + ". Local truststore not available, aborting execution.");
                        throw new IOException("Local truststore file not found. Also not available under : " + truststore.getAbsolutePath());
                    }
                }
                if (this.isUseSSL() || this.isUseStartTLS()) {
                    props.put(this.mailProp(serverProtocol, "ssl.socketFactory"), new LocalTrustStoreSSLSocketFactory(truststore));
                    props.put(this.mailProp(serverProtocol, "ssl.socketFactory.fallback"), FALSE);
                }
            }
            this.addCustomProperties(props);
            Session session = Session.getInstance((Properties)props, null);
            Store store = session.getStore(serverProtocol);
            store.connect(this.getServer(), this.getPortAsInt(), this.getUserName(), this.getPassword());
            Folder folder = store.getFolder(this.getFolder());
            if (deleteMessages) {
                folder.open(2);
            } else {
                folder.open(1);
            }
            int messageTotal = folder.getMessageCount();
            int n = this.getNumMessages();
            if (n == -1 || n > messageTotal) {
                n = messageTotal;
            }
            Message[] messages = folder.getMessages(1, n);
            String pdata = messages.length + " messages found\n";
            parent.setResponseData(pdata, null);
            parent.setDataType("text");
            parent.setContentType("text/plain");
            boolean headerOnly = this.getHeaderOnly();
            this.busy = true;
            for (Message message : messages) {
                StringBuilder cdata = new StringBuilder();
                SampleResult child = new SampleResult();
                child.sampleStart();
                cdata.append("Message ");
                cdata.append(message.getMessageNumber());
                child.setSampleLabel(cdata.toString());
                child.setSamplerData(cdata.toString());
                cdata.setLength(0);
                String contentType = message.getContentType();
                child.setContentType(contentType);
                child.setDataEncoding(RFC_822_DEFAULT_ENCODING);
                child.setEncodingAndType(contentType);
                if (this.isStoreMimeMessage()) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    message.writeTo((OutputStream)bout);
                    child.setResponseData(bout.toByteArray());
                    child.setDataType("text");
                } else {
                    Enumeration hdrs = message.getAllHeaders();
                    while (hdrs.hasMoreElements()) {
                        Header hdr = (Header)hdrs.nextElement();
                        String value = hdr.getValue();
                        try {
                            value = MimeUtility.decodeText((String)value);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        cdata.append(hdr.getName()).append(": ").append(value).append(NEW_LINE);
                    }
                    child.setResponseHeaders(cdata.toString());
                    cdata.setLength(0);
                    if (!headerOnly) {
                        this.appendMessageData(child, message);
                    }
                }
                if (deleteMessages) {
                    message.setFlag(Flags.Flag.DELETED, true);
                }
                child.setResponseOK();
                if (child.getEndTime() == 0L) {
                    child.sampleEnd();
                }
                parent.addSubResult(child);
            }
            folder.close(true);
            store.close();
            parent.setResponseCodeOK();
            parent.setResponseMessageOK();
            isOK = true;
        }
        catch (IOException | NoClassDefFoundError ex) {
            log.debug("", ex);
            parent.setResponseCode("500");
            parent.setResponseMessage(ex.toString());
        }
        catch (MessagingException ex) {
            log.debug("", (Throwable)ex);
            parent.setResponseCode("500");
            parent.setResponseMessage(ex.toString() + NEW_LINE + samplerString);
        }
        finally {
            this.busy = false;
        }
        if (parent.getEndTime() == 0L) {
            parent.sampleEnd();
        }
        parent.setSuccessful(isOK);
        return parent;
    }

    protected void addCustomProperties(Properties props) {
        Properties jMeterProperties = JMeterUtils.getJMeterProperties();
        Enumeration<?> enums = jMeterProperties.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            if (!key.startsWith("mail.")) continue;
            String value = jMeterProperties.getProperty(key);
            props.put(key, value);
        }
    }

    private void appendMessageData(SampleResult child, Message message) throws MessagingException, IOException {
        StringBuilder cdata = new StringBuilder();
        cdata.append("Date: ");
        cdata.append(message.getSentDate());
        cdata.append(NEW_LINE);
        cdata.append("To: ");
        Address[] recips = message.getAllRecipients();
        for (int j = 0; recips != null && j < recips.length; ++j) {
            cdata.append(recips[j].toString());
            if (j >= recips.length - 1) continue;
            cdata.append("; ");
        }
        cdata.append(NEW_LINE);
        cdata.append("From: ");
        Address[] from = message.getFrom();
        for (int j = 0; from != null && j < from.length; ++j) {
            cdata.append(from[j].toString());
            if (j >= from.length - 1) continue;
            cdata.append("; ");
        }
        cdata.append(NEW_LINE);
        cdata.append("Subject: ");
        cdata.append(message.getSubject());
        cdata.append(NEW_LINE);
        cdata.append(NEW_LINE);
        Object content = message.getContent();
        if (content instanceof MimeMultipart) {
            this.appendMultiPart(child, cdata, (MimeMultipart)content);
        } else if (content instanceof InputStream) {
            child.setResponseData(IOUtils.toByteArray((InputStream)((InputStream)content)));
        } else {
            cdata.append(content);
            child.setResponseData(cdata.toString(), child.getDataEncodingNoDefault());
        }
    }

    private void appendMultiPart(SampleResult child, StringBuilder cdata, MimeMultipart mmp) throws MessagingException, IOException {
        String preamble = mmp.getPreamble();
        if (preamble != null) {
            cdata.append(preamble);
        }
        child.setResponseData(cdata.toString(), child.getDataEncodingNoDefault());
        int count = mmp.getCount();
        for (int j = 0; j < count; ++j) {
            BodyPart bodyPart = mmp.getBodyPart(j);
            Object bodyPartContent = bodyPart.getContent();
            String contentType = bodyPart.getContentType();
            SampleResult sr = new SampleResult();
            sr.setSampleLabel("Part: " + j);
            sr.setContentType(contentType);
            sr.setDataEncoding(RFC_822_DEFAULT_ENCODING);
            sr.setEncodingAndType(contentType);
            sr.sampleStart();
            if (bodyPartContent instanceof InputStream) {
                sr.setResponseData(IOUtils.toByteArray((InputStream)((InputStream)bodyPartContent)));
            } else if (bodyPartContent instanceof MimeMultipart) {
                this.appendMultiPart(sr, cdata, (MimeMultipart)bodyPartContent);
            } else {
                sr.setResponseData(bodyPartContent.toString(), sr.getDataEncodingNoDefault());
            }
            sr.setResponseOK();
            if (sr.getEndTime() == 0L) {
                sr.sampleEnd();
            }
            child.addSubResult(sr);
        }
    }

    public void setServerType(String serverType) {
        this.setProperty(SERVER_TYPE, serverType);
    }

    public String getServerType() {
        return this.getPropertyAsString(SERVER_TYPE);
    }

    public void setServer(String server) {
        this.setProperty(SERVER, server);
    }

    public String getServer() {
        return this.getPropertyAsString(SERVER);
    }

    public String getPort() {
        return this.getPropertyAsString(PORT);
    }

    private int getPortAsInt() {
        return this.getPropertyAsInt(PORT, -1);
    }

    public void setPort(String port) {
        this.setProperty(PORT, port, "");
    }

    public void setUserName(String username) {
        this.setProperty(USERNAME, username);
    }

    public String getUserName() {
        return this.getPropertyAsString(USERNAME);
    }

    public void setPassword(String password) {
        this.setProperty(PASSWORD, password);
    }

    public String getPassword() {
        return this.getPropertyAsString(PASSWORD);
    }

    public void setFolder(String folder) {
        this.setProperty(FOLDER, folder);
    }

    public String getFolder() {
        return this.getPropertyAsString(FOLDER);
    }

    public void setNumMessages(int numMessages) {
        this.setProperty((JMeterProperty)new IntegerProperty(NUM_MESSAGES, numMessages));
    }

    public void setNumMessages(String numMessages) {
        this.setProperty((JMeterProperty)new StringProperty(NUM_MESSAGES, numMessages));
    }

    public int getNumMessages() {
        return this.getPropertyAsInt(NUM_MESSAGES);
    }

    public String getNumMessagesString() {
        return this.getPropertyAsString(NUM_MESSAGES);
    }

    public void setDeleteMessages(boolean delete) {
        this.setProperty((JMeterProperty)new BooleanProperty(DELETE, delete));
    }

    public boolean getDeleteMessages() {
        return this.getPropertyAsBoolean(DELETE);
    }

    public boolean isStoreMimeMessage() {
        return this.getPropertyAsBoolean(STORE_MIME_MESSAGE, false);
    }

    public void setStoreMimeMessage(boolean storeMimeMessage) {
        this.setProperty(STORE_MIME_MESSAGE, storeMimeMessage, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getServerType());
        sb.append("://");
        String name = this.getUserName();
        if (name.length() > 0) {
            sb.append(name);
            sb.append("@");
        }
        sb.append(this.getServer());
        int port = this.getPortAsInt();
        if (port != -1) {
            sb.append(":").append(port);
        }
        sb.append("/");
        sb.append(this.getFolder());
        sb.append("[");
        sb.append(this.getNumMessages());
        sb.append("]");
        return sb.toString();
    }

    public boolean interrupt() {
        boolean wasbusy = this.busy;
        this.busy = false;
        return wasbusy;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }

    public boolean getHeaderOnly() {
        return this.getPropertyAsBoolean(HEADER_ONLY, false);
    }

    public void setHeaderOnly(boolean selected) {
        this.setProperty(HEADER_ONLY, selected, false);
    }

    private String mailProp(String protocol, String propname) {
        return "mail." + protocol + "." + propname;
    }
}

