/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.smtp.sampler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.smtp.sampler.protocol.SendMailCommand;
import org.apache.jmeter.protocol.smtp.sampler.tools.CounterOutputStream;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SmtpSampler
extends AbstractSampler {
    private static final long serialVersionUID = 1L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String SERVER = "SMTPSampler.server";
    public static final String SERVER_PORT = "SMTPSampler.serverPort";
    public static final String SERVER_TIMEOUT = "SMTPSampler.serverTimeout";
    public static final String SERVER_CONNECTION_TIMEOUT = "SMTPSampler.serverConnectionTimeout";
    public static final String USE_AUTH = "SMTPSampler.useAuth";
    public static final String USERNAME = "SMTPSampler.username";
    public static final String PASSWORD = "SMTPSampler.password";
    public static final String MAIL_FROM = "SMTPSampler.mailFrom";
    public static final String MAIL_REPLYTO = "SMTPSampler.replyTo";
    public static final String RECEIVER_TO = "SMTPSampler.receiverTo";
    public static final String RECEIVER_CC = "SMTPSampler.receiverCC";
    public static final String RECEIVER_BCC = "SMTPSampler.receiverBCC";
    public static final String SUBJECT = "SMTPSampler.subject";
    public static final String SUPPRESS_SUBJECT = "SMTPSampler.suppressSubject";
    public static final String MESSAGE = "SMTPSampler.message";
    public static final String PLAIN_BODY = "SMTPSampler.plainBody";
    public static final String INCLUDE_TIMESTAMP = "SMTPSampler.include_timestamp";
    public static final String ATTACH_FILE = "SMTPSampler.attachFile";
    public static final String MESSAGE_SIZE_STATS = "SMTPSampler.messageSizeStatistics";
    public static final String HEADER_FIELDS = "SMTPSampler.headerFields";
    public static final String USE_EML = "SMTPSampler.use_eml";
    public static final String EML_MESSAGE_TO_SEND = "SMTPSampler.emlMessageToSend";
    public static final String ENABLE_DEBUG = "SMTPSampler.enableDebug";
    public static final String FILENAME_SEPARATOR = ";";

    public SampleResult sample(Entry e) {
        StringBuilder sb;
        Message message = null;
        SampleResult res = new SampleResult();
        res.setSampleLabel(this.getName());
        boolean isOK = false;
        SendMailCommand instance = new SendMailCommand();
        instance.setSmtpServer(this.getPropertyAsString(SERVER));
        instance.setSmtpPort(this.getPropertyAsString(SERVER_PORT));
        instance.setConnectionTimeOut(this.getPropertyAsString(SERVER_CONNECTION_TIMEOUT));
        instance.setTimeOut(this.getPropertyAsString(SERVER_TIMEOUT));
        instance.setUseSSL(this.getPropertyAsBoolean("SMTPSampler.useSSL"));
        instance.setUseStartTLS(this.getPropertyAsBoolean("SMTPSampler.useStartTLS"));
        instance.setTrustAllCerts(this.getPropertyAsBoolean("SMTPSampler.trustAllCerts"));
        instance.setEnforceStartTLS(this.getPropertyAsBoolean("SMTPSampler.enforceStartTLS"));
        instance.setUseAuthentication(this.getPropertyAsBoolean(USE_AUTH));
        instance.setUsername(this.getPropertyAsString(USERNAME));
        instance.setPassword(this.getPropertyAsString(PASSWORD));
        instance.setUseLocalTrustStore(this.getPropertyAsBoolean("SMTPSampler.useLocalTrustStore"));
        instance.setTrustStoreToUse(this.getPropertyAsString("SMTPSampler.trustStoreToUse"));
        instance.setEmlMessage(this.getPropertyAsString(EML_MESSAGE_TO_SEND));
        instance.setUseEmlMessage(this.getPropertyAsBoolean(USE_EML));
        instance.setEnableDebug(this.getPropertyAsBoolean(ENABLE_DEBUG));
        if (this.getPropertyAsString(MAIL_FROM).matches(".*@.*")) {
            instance.setSender(this.getPropertyAsString(MAIL_FROM));
        }
        String receiverTo = this.getPropertyAsString(RECEIVER_TO).trim();
        String receiverCC = this.getPropertyAsString(RECEIVER_CC).trim();
        String receiverBcc = this.getPropertyAsString(RECEIVER_BCC).trim();
        String replyTo = this.getPropertyAsString(MAIL_REPLYTO).trim();
        try {
            instance.setReceiverTo(this.getPropNameAsAddresses(receiverTo));
            instance.setReceiverCC(this.getPropNameAsAddresses(receiverCC));
            instance.setReceiverBCC(this.getPropNameAsAddresses(receiverBcc));
            instance.setReplyTo(this.getPropNameAsAddresses(replyTo));
            if (this.getPropertyAsBoolean(SUPPRESS_SUBJECT)) {
                instance.setSubject(null);
            } else {
                String subject = this.getPropertyAsString(SUBJECT);
                if (this.getPropertyAsBoolean(INCLUDE_TIMESTAMP)) {
                    sb = new StringBuilder(subject);
                    sb.append(" <<< current timestamp: ");
                    sb.append(new Date().getTime());
                    sb.append(" >>>");
                    subject = sb.toString();
                }
                instance.setSubject(subject);
            }
            if (!this.getPropertyAsBoolean(USE_EML)) {
                instance.setMailBody(this.getPropertyAsString(MESSAGE));
                instance.setPlainBody(this.getPropertyAsBoolean(PLAIN_BODY));
                String filesToAttach = this.getPropertyAsString(ATTACH_FILE);
                if (!filesToAttach.isEmpty()) {
                    String[] attachments;
                    for (String attachment : attachments = filesToAttach.split(FILENAME_SEPARATOR)) {
                        File file = new File(attachment);
                        if (!file.isAbsolute() && !file.exists()) {
                            log.debug("loading file with relative path: " + attachment);
                            file = new File(FileServer.getFileServer().getBaseDir(), attachment);
                            log.debug("file path set to: " + attachment);
                        }
                        instance.addAttachment(file);
                    }
                }
            }
            instance.setSynchronousMode(true);
            instance.setHeaderFields((CollectionProperty)this.getProperty(HEADER_FIELDS));
            message = instance.prepareMessage();
            if (this.getPropertyAsBoolean(MESSAGE_SIZE_STATS)) {
                CounterOutputStream cs = new CounterOutputStream();
                message.writeTo((OutputStream)cs);
                res.setBytes(cs.getCount());
            } else {
                res.setBytes(-1);
            }
        }
        catch (Exception ex) {
            log.warn("Error while preparing message", (Throwable)ex);
            res.setResponseCode("500");
            res.setResponseMessage(ex.toString());
            return res;
        }
        res.setDataType("text");
        try {
            res.setRequestHeaders(this.getRequestHeaders(message));
            res.setSamplerData(this.getSamplerData(message));
        }
        catch (IOException | MessagingException e1) {
            res.setSamplerData("Error occurred trying to save request info: " + e1);
            log.warn("Error occurred trying to save request info", e1);
        }
        res.sampleStart();
        try {
            instance.execute(message);
            res.setResponseCodeOK();
            res.setResponseMessage("Message successfully sent!\n" + instance.getServerResponse());
            isOK = true;
        }
        catch (AuthenticationFailedException afex) {
            log.warn("", (Throwable)afex);
            res.setResponseCode("500");
            res.setResponseMessage("AuthenticationFailedException: authentication failed - wrong username / password!\n" + (Object)((Object)afex));
        }
        catch (MessagingException mex) {
            log.warn("", (Throwable)mex);
            res.setResponseCode("500");
            if (mex.getMessage().matches(".*Could not connect to SMTP host.*465.*") && mex.getCause().getMessage().matches(".*Connection timed out.*")) {
                res.setResponseMessage("MessagingException: Probably, SSL is not supported by the SMTP-Server!\n" + (Object)((Object)mex));
            } else if (mex.getMessage().matches(".*StartTLS failed.*")) {
                res.setResponseMessage("MessagingException: StartTLS not supported by server or initializing failed!\n" + (Object)((Object)mex));
            } else if (mex.getMessage().matches(".*send command to.*") && mex.getCause().getMessage().matches(".*unable to find valid certification path to requested target.*")) {
                res.setResponseMessage("MessagingException: Server certificate not trusted - perhaps you have to restart JMeter!\n" + (Object)((Object)mex));
            } else {
                res.setResponseMessage("Other MessagingException: " + mex.toString());
            }
        }
        catch (Exception ex) {
            log.warn("", (Throwable)ex);
            res.setResponseCode("500");
            if (null != ex.getMessage() && ex.getMessage().matches("Failed to build truststore")) {
                res.setResponseMessage("Failed to build truststore - did not try to send mail!");
            }
            res.setResponseMessage("Other Exception: " + ex.toString());
        }
        res.sampleEnd();
        try {
            InputStream is = message.getInputStream();
            sb = new StringBuilder();
            byte[] buf = new byte[1024];
            int read = is.read(buf);
            while (read > 0) {
                sb.append(new String(buf, 0, read));
                read = is.read(buf);
            }
            res.setResponseData(sb.toString().getBytes());
        }
        catch (IOException | MessagingException ex) {
            log.warn("", ex);
        }
        res.setSuccessful(isOK);
        return res;
    }

    private String getRequestHeaders(Message message) throws MessagingException {
        StringBuilder sb = new StringBuilder();
        Enumeration headers = message.getAllHeaders();
        this.writeHeaders(headers, sb);
        return sb.toString();
    }

    private String getSamplerData(Message message) throws MessagingException, IOException {
        StringBuilder sb = new StringBuilder();
        Object content = message.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            String contentType = multipart.getContentType();
            ContentType ct = new ContentType(contentType);
            String boundary = ct.getParameter("boundary");
            for (int i = 0; i < multipart.getCount(); ++i) {
                sb.append("--");
                sb.append(boundary);
                sb.append("\n");
                BodyPart bodyPart = multipart.getBodyPart(i);
                this.writeBodyPart(sb, bodyPart);
            }
            sb.append("--");
            sb.append(boundary);
            sb.append("--");
            sb.append("\n");
        } else if (content instanceof BodyPart) {
            BodyPart bodyPart = (BodyPart)content;
            this.writeBodyPart(sb, bodyPart);
        } else if (content instanceof String) {
            sb.append(content);
        } else {
            sb.append("Content has class: " + content.getClass().getCanonicalName());
        }
        return sb.toString();
    }

    private void writeHeaders(Enumeration<Header> headers, StringBuilder sb) {
        while (headers.hasMoreElements()) {
            Header header = headers.nextElement();
            sb.append(header.getName());
            sb.append(": ");
            sb.append(header.getValue());
            sb.append("\n");
        }
    }

    private void writeBodyPart(StringBuilder sb, BodyPart bodyPart) throws MessagingException, IOException {
        Enumeration allHeaders = bodyPart.getAllHeaders();
        this.writeHeaders(allHeaders, sb);
        String disposition = bodyPart.getDisposition();
        sb.append("\n");
        if ("attachment".equals(disposition)) {
            sb.append("<attachment content not shown>");
        } else {
            sb.append(bodyPart.getContent());
        }
        sb.append("\n");
    }

    private List<InternetAddress> getPropNameAsAddresses(String propValue) throws AddressException {
        if (propValue.length() > 0) {
            ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
            for (String address : propValue.split(FILENAME_SEPARATOR)) {
                addresses.add(new InternetAddress(address.trim()));
            }
            return addresses;
        }
        return null;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

