/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.mail.sampler.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.mail.sampler.MailReaderSampler;
import org.apache.jmeter.protocol.smtp.sampler.gui.SecuritySettingsPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class MailReaderSamplerGui
extends AbstractSamplerGui
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 240L;
    private JTextField serverTypeBox;
    private JTextField serverBox;
    private JTextField portBox;
    private JTextField usernameBox;
    private JTextField passwordBox;
    private JTextField folderBox;
    private JLabel folderLabel;
    private JRadioButton allMessagesButton;
    private JRadioButton someMessagesButton;
    private JTextField someMessagesField;
    private JCheckBox deleteBox;
    private JCheckBox storeMimeMessageBox;
    private final String ServerTypeLabel = JMeterUtils.getResString((String)"mail_reader_server_type");
    private final String ServerLabel = JMeterUtils.getResString((String)"mail_reader_server");
    private final String PortLabel = JMeterUtils.getResString((String)"mail_reader_port");
    private final String AccountLabel = JMeterUtils.getResString((String)"mail_reader_account");
    private final String PasswordLabel = JMeterUtils.getResString((String)"mail_reader_password");
    private final String NumMessagesLabel = JMeterUtils.getResString((String)"mail_reader_num_messages");
    private final String AllMessagesLabel = JMeterUtils.getResString((String)"mail_reader_all_messages");
    private final String DeleteLabel = JMeterUtils.getResString((String)"mail_reader_delete");
    private final String FolderLabel = JMeterUtils.getResString((String)"mail_reader_folder");
    private final String STOREMIME = JMeterUtils.getResString((String)"mail_reader_storemime");
    private static final String INBOX = "INBOX";
    private SecuritySettingsPanel securitySettingsPanel;

    public MailReaderSamplerGui() {
        this.init();
        this.initGui();
    }

    public String getLabelResource() {
        return "mail_reader_title";
    }

    public void configure(TestElement element) {
        MailReaderSampler mrs = (MailReaderSampler)element;
        this.serverTypeBox.setText(mrs.getServerType());
        this.folderBox.setText(mrs.getFolder());
        this.serverBox.setText(mrs.getServer());
        this.portBox.setText(mrs.getPort());
        this.usernameBox.setText(mrs.getUserName());
        this.passwordBox.setText(mrs.getPassword());
        if (mrs.getNumMessages() == -1) {
            this.allMessagesButton.setSelected(true);
            this.someMessagesField.setText("0");
        } else {
            this.someMessagesButton.setSelected(true);
            this.someMessagesField.setText(mrs.getNumMessagesString());
        }
        this.deleteBox.setSelected(mrs.getDeleteMessages());
        this.storeMimeMessageBox.setSelected(mrs.isStoreMimeMessage());
        this.securitySettingsPanel.configure(element);
        super.configure(element);
    }

    public TestElement createTestElement() {
        MailReaderSampler sampler = new MailReaderSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement te) {
        te.clear();
        this.configureTestElement(te);
        MailReaderSampler mrs = (MailReaderSampler)te;
        mrs.setServerType(this.serverTypeBox.getText());
        mrs.setFolder(this.folderBox.getText());
        mrs.setServer(this.serverBox.getText());
        mrs.setPort(this.portBox.getText());
        mrs.setUserName(this.usernameBox.getText());
        mrs.setPassword(this.passwordBox.getText());
        if (this.allMessagesButton.isSelected()) {
            mrs.setNumMessages(-1);
        } else {
            mrs.setNumMessages(this.someMessagesField.getText());
        }
        mrs.setDeleteMessages(this.deleteBox.isSelected());
        mrs.setStoreMimeMessage(this.storeMimeMessageBox.isSelected());
        this.securitySettingsPanel.modifyTestElement(te);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = this.getConstraints();
        this.serverTypeBox = new JTextField(20);
        this.serverTypeBox.addActionListener(this);
        this.serverTypeBox.addFocusListener(this);
        this.addField(settingsPanel, this.ServerTypeLabel, (JComponent)this.serverTypeBox, gbc);
        this.serverBox = new JTextField(20);
        this.addField(settingsPanel, this.ServerLabel, (JComponent)this.serverBox, gbc);
        this.portBox = new JTextField(20);
        this.addField(settingsPanel, this.PortLabel, (JComponent)this.portBox, gbc);
        this.usernameBox = new JTextField(20);
        this.addField(settingsPanel, this.AccountLabel, (JComponent)this.usernameBox, gbc);
        this.passwordBox = new JPasswordField(20);
        this.addField(settingsPanel, this.PasswordLabel, (JComponent)this.passwordBox, gbc);
        this.folderLabel = new JLabel(this.FolderLabel);
        this.folderBox = new JTextField(INBOX, 20);
        this.addField(settingsPanel, this.folderLabel, (JComponent)this.folderBox, gbc);
        HorizontalPanel numMessagesPanel = new HorizontalPanel();
        numMessagesPanel.add((Component)new JLabel(this.NumMessagesLabel));
        ButtonGroup nmbg = new ButtonGroup();
        this.allMessagesButton = new JRadioButton(this.AllMessagesLabel);
        this.allMessagesButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (MailReaderSamplerGui.this.allMessagesButton.isSelected()) {
                    MailReaderSamplerGui.this.someMessagesField.setEnabled(false);
                }
            }
        });
        this.someMessagesButton = new JRadioButton();
        this.someMessagesButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (MailReaderSamplerGui.this.someMessagesButton.isSelected()) {
                    MailReaderSamplerGui.this.someMessagesField.setEnabled(true);
                }
            }
        });
        nmbg.add(this.allMessagesButton);
        nmbg.add(this.someMessagesButton);
        this.someMessagesField = new JTextField(5);
        this.allMessagesButton.setSelected(true);
        numMessagesPanel.add((Component)this.allMessagesButton);
        numMessagesPanel.add((Component)this.someMessagesButton);
        numMessagesPanel.add((Component)this.someMessagesField);
        this.deleteBox = new JCheckBox(this.DeleteLabel);
        this.storeMimeMessageBox = new JCheckBox(this.STOREMIME);
        this.securitySettingsPanel = new SecuritySettingsPanel();
        VerticalPanel settings = new VerticalPanel();
        settings.add(Box.createVerticalStrut(5));
        settings.add(settingsPanel);
        settings.add((Component)numMessagesPanel);
        settings.add(this.deleteBox);
        settings.add(this.storeMimeMessageBox);
        settings.add(this.securitySettingsPanel);
        this.add(this.makeTitlePanel(), "North");
        this.add((Component)settings, "Center");
    }

    private void addField(JPanel panel, JLabel label, JComponent field, GridBagConstraints gbc) {
        gbc.fill = 0;
        gbc.anchor = 22;
        panel.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 21;
        panel.add((Component)field, gbc);
        this.nextLine(gbc);
    }

    private void addField(JPanel panel, String text, JComponent field, GridBagConstraints gbc) {
        this.addField(panel, new JLabel(text), field, gbc);
    }

    private void nextLine(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
    }

    private GridBagConstraints getConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        return gbc;
    }

    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    private void initGui() {
        this.allMessagesButton.setSelected(true);
        this.deleteBox.setSelected(false);
        this.storeMimeMessageBox.setSelected(false);
        this.folderBox.setText(INBOX);
        this.serverTypeBox.setText("pop3");
        this.passwordBox.setText("");
        this.serverBox.setText("");
        this.portBox.setText("");
        this.usernameBox.setText("");
    }

    public void actionPerformed(ActionEvent e) {
        String item = this.serverTypeBox.getText();
        if (item.equals("pop3") || item.equals("pop3s")) {
            this.folderLabel.setEnabled(false);
            this.folderBox.setText(INBOX);
            this.folderBox.setEnabled(false);
        } else {
            this.folderLabel.setEnabled(true);
            this.folderBox.setEnabled(true);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.actionPerformed(null);
    }
}

