/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.sampler;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.ldap.config.gui.LDAPArgument;
import org.apache.jmeter.protocol.ldap.config.gui.LDAPArguments;
import org.apache.jmeter.protocol.ldap.sampler.LdapExtClient;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.XMLBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPExtSampler
extends AbstractSampler
implements TestStateListener {
    private static final Logger log = LoggerFactory.getLogger(LDAPExtSampler.class);
    private static final long serialVersionUID = 240L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.protocol.ldap.config.gui.LdapConfigGui", "org.apache.jmeter.protocol.ldap.config.gui.LdapExtConfigGui", "org.apache.jmeter.config.gui.SimpleConfigGui"));
    public static final String SERVERNAME = "servername";
    public static final String PORT = "port";
    public static final String SECURE = "secure";
    public static final String ROOTDN = "rootdn";
    public static final String TEST = "test";
    public static final String ADD = "add";
    public static final String MODIFY = "modify";
    public static final String BIND = "bind";
    public static final String UNBIND = "unbind";
    public static final String DELETE = "delete";
    public static final String SEARCH = "search";
    public static final String SEARCHBASE = "search";
    public static final String SEARCHFILTER = "searchfilter";
    public static final String ARGUMENTS = "arguments";
    public static final String LDAPARGUMENTS = "ldaparguments";
    public static final String BASE_ENTRY_DN = "base_entry_dn";
    public static final String SCOPE = "scope";
    public static final String COUNTLIM = "countlimit";
    public static final String TIMELIM = "timelimit";
    public static final String ATTRIBS = "attributes";
    public static final String RETOBJ = "return_object";
    public static final String DEREF = "deref_aliases";
    public static final String USERDN = "user_dn";
    public static final String USERPW = "user_pw";
    public static final String SBIND = "sbind";
    public static final String COMPARE = "compare";
    public static final String CONNTO = "connection_timeout";
    public static final String COMPAREDN = "comparedn";
    public static final String COMPAREFILT = "comparefilt";
    public static final String PARSEFLAG = "parseflag";
    public static final String RENAME = "rename";
    public static final String MODDDN = "modddn";
    public static final String NEWDN = "newdn";
    private static final String SEMI_COLON = ";";
    private static final ConcurrentHashMap<String, DirContext> ldapContexts = new ConcurrentHashMap();
    private static final int MAX_SORTED_RESULTS = JMeterUtils.getPropDefault((String)"ldapsampler.max_sorted_results", (int)1000);

    public void setConnTimeOut(String connto) {
        this.setProperty((JMeterProperty)new StringProperty(CONNTO, connto));
    }

    public String getConnTimeOut() {
        return this.getPropertyAsString(CONNTO);
    }

    public void setSecure(String sec) {
        this.setProperty((JMeterProperty)new StringProperty(SECURE, sec));
    }

    public boolean isSecure() {
        return this.getPropertyAsBoolean(SECURE);
    }

    public boolean isParseFlag() {
        return this.getPropertyAsBoolean(PARSEFLAG);
    }

    public void setParseFlag(String parseFlag) {
        this.setProperty((JMeterProperty)new StringProperty(PARSEFLAG, parseFlag));
    }

    public String getUserDN() {
        return this.getPropertyAsString(USERDN);
    }

    public void setUserDN(String newUserDN) {
        this.setProperty((JMeterProperty)new StringProperty(USERDN, newUserDN));
    }

    public String getUserPw() {
        return this.getPropertyAsString(USERPW);
    }

    public void setUserPw(String newUserPw) {
        this.setProperty((JMeterProperty)new StringProperty(USERPW, newUserPw));
    }

    public void setServername(String servername) {
        this.setProperty((JMeterProperty)new StringProperty(SERVERNAME, servername));
    }

    public void setPort(String port) {
        this.setProperty((JMeterProperty)new StringProperty(PORT, port));
    }

    public String getServername() {
        return this.getPropertyAsString(SERVERNAME);
    }

    public String getPort() {
        return this.getPropertyAsString(PORT);
    }

    public void setRootdn(String newRootdn) {
        this.setProperty(ROOTDN, newRootdn);
    }

    public String getRootdn() {
        return this.getPropertyAsString(ROOTDN);
    }

    public String getScope() {
        return this.getPropertyAsString(SCOPE);
    }

    public int getScopeAsInt() {
        return this.getPropertyAsInt(SCOPE);
    }

    public void setScope(String newScope) {
        this.setProperty(SCOPE, newScope);
    }

    public String getCountlim() {
        return this.getPropertyAsString(COUNTLIM);
    }

    public long getCountlimAsLong() {
        return this.getPropertyAsLong(COUNTLIM);
    }

    public void setCountlim(String newClim) {
        this.setProperty(COUNTLIM, newClim);
    }

    public String getTimelim() {
        return this.getPropertyAsString(TIMELIM);
    }

    public int getTimelimAsInt() {
        return this.getPropertyAsInt(TIMELIM);
    }

    public void setTimelim(String newTlim) {
        this.setProperty(TIMELIM, newTlim);
    }

    public boolean isRetobj() {
        return this.getPropertyAsBoolean(RETOBJ);
    }

    public void setRetobj(String newRobj) {
        this.setProperty(RETOBJ, newRobj);
    }

    public boolean isDeref() {
        return this.getPropertyAsBoolean(DEREF);
    }

    public void setDeref(String newDref) {
        this.setProperty(DEREF, newDref);
    }

    public void setTest(String newTest) {
        this.setProperty(TEST, newTest);
    }

    public String getTest() {
        return this.getPropertyAsString(TEST);
    }

    public void setAttrs(String newAttrs) {
        this.setProperty(ATTRIBS, newAttrs);
    }

    public String getAttrs() {
        return this.getPropertyAsString(ATTRIBS);
    }

    public void setBaseEntryDN(String newbaseentry) {
        this.setProperty((JMeterProperty)new StringProperty(BASE_ENTRY_DN, newbaseentry));
    }

    public String getBaseEntryDN() {
        return this.getPropertyAsString(BASE_ENTRY_DN);
    }

    public void setArguments(Arguments value) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)value));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public void setLDAPArguments(LDAPArguments value) {
        this.setProperty((JMeterProperty)new TestElementProperty(LDAPARGUMENTS, (TestElement)value));
    }

    public LDAPArguments getLDAPArguments() {
        return (LDAPArguments)this.getProperty(LDAPARGUMENTS).getObjectValue();
    }

    private Attributes getUserAttributes() {
        BasicAttributes attrs = new BasicAttributes(true);
        for (JMeterProperty jMeterProperty : this.getArguments()) {
            Argument item = (Argument)jMeterProperty.getObjectValue();
            Attribute attr = attrs.get(item.getName());
            if (attr == null) {
                attr = this.getBasicAttribute(item.getName(), item.getValue());
            } else {
                attr.add(item.getValue());
            }
            attrs.put(attr);
        }
        return attrs;
    }

    private ModificationItem[] getUserModAttributes() {
        ModificationItem[] mods = new ModificationItem[this.getLDAPArguments().getArguments().size()];
        PropertyIterator iter = this.getLDAPArguments().iterator();
        int count = 0;
        while (iter.hasNext()) {
            LDAPArgument item = (LDAPArgument)iter.next().getObjectValue();
            BasicAttribute attr = item.getValue().length() == 0 ? new BasicAttribute(item.getName()) : this.getBasicAttribute(item.getName(), item.getValue());
            String opcode = item.getOpcode();
            if (ADD.equals(opcode)) {
                mods[count++] = new ModificationItem(1, attr);
                continue;
            }
            if (DELETE.equals(opcode) || "remove".equals(opcode)) {
                mods[count++] = new ModificationItem(3, attr);
                continue;
            }
            if ("replace".equals(opcode)) {
                mods[count++] = new ModificationItem(2, attr);
                continue;
            }
            log.warn("Invalid opCode: " + opcode);
        }
        return mods;
    }

    private String[] getRequestAttributes(String reqAttr) {
        String[] mods;
        int index;
        int count = 0;
        if (reqAttr.length() == 0) {
            return null;
        }
        if (!reqAttr.endsWith(SEMI_COLON)) {
            reqAttr = reqAttr + SEMI_COLON;
        }
        String attr = reqAttr;
        while (attr.length() > 0) {
            index = attr.indexOf(SEMI_COLON);
            ++count;
            attr = attr.substring(index + 1);
        }
        if (count > 0) {
            mods = new String[count];
            attr = reqAttr;
            count = 0;
            while (attr.length() > 0) {
                index = attr.indexOf(SEMI_COLON);
                mods[count] = attr.substring(0, index);
                ++count;
                attr = attr.substring(index + 1);
            }
        } else {
            mods = null;
        }
        return mods;
    }

    private BasicAttribute getBasicAttribute(String name, String value) {
        return new BasicAttribute(name, value);
    }

    public String getLabel() {
        return "ldap://" + this.getServername() + ":" + this.getPort() + "/" + this.getRootdn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTest(DirContext dirContext, SampleResult res) throws NamingException {
        try {
            res.sampleStart();
            DirContext ctx = LdapExtClient.createTest(dirContext, this.getUserAttributes(), this.getBaseEntryDN());
            ctx.close();
        }
        finally {
            res.sampleEnd();
        }
    }

    private void deleteTest(DirContext dirContext, SampleResult res) throws NamingException {
        try {
            res.sampleStart();
            LdapExtClient.deleteTest(dirContext, this.getPropertyAsString(DELETE));
        }
        finally {
            res.sampleEnd();
        }
    }

    private void modifyTest(DirContext dirContext, SampleResult res) throws NamingException {
        try {
            res.sampleStart();
            LdapExtClient.modifyTest(dirContext, this.getUserModAttributes(), this.getBaseEntryDN());
        }
        finally {
            res.sampleEnd();
        }
    }

    private void bindOp(SampleResult res) throws NamingException {
        DirContext ctx = ldapContexts.remove(this.getThreadName());
        if (ctx != null) {
            log.warn("Closing previous context for thread: " + this.getThreadName());
            ctx.close();
        }
        try {
            res.sampleStart();
            ctx = LdapExtClient.connect(this.getServername(), this.getPort(), this.getRootdn(), this.getUserDN(), this.getUserPw(), this.getConnTimeOut(), this.isSecure());
        }
        finally {
            res.sampleEnd();
        }
        ldapContexts.put(this.getThreadName(), ctx);
    }

    private void singleBindOp(SampleResult res) throws NamingException {
        try {
            res.sampleStart();
            DirContext ctx = LdapExtClient.connect(this.getServername(), this.getPort(), this.getRootdn(), this.getUserDN(), this.getUserPw(), this.getConnTimeOut(), this.isSecure());
            LdapExtClient.disconnect(ctx);
        }
        finally {
            res.sampleEnd();
        }
    }

    private void renameTest(DirContext dirContext, SampleResult res) throws NamingException {
        try {
            res.sampleStart();
            LdapExtClient.moddnOp(dirContext, this.getPropertyAsString(MODDDN), this.getPropertyAsString(NEWDN));
        }
        finally {
            res.sampleEnd();
        }
    }

    private void unbindOp(DirContext dirContext, SampleResult res) {
        try {
            res.sampleStart();
            LdapExtClient.disconnect(dirContext);
        }
        finally {
            res.sampleEnd();
        }
        ldapContexts.remove(this.getThreadName());
        log.info("context and LdapExtClients removed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult sample(Entry e) {
        SampleResult res;
        block28: {
            XMLBuffer xmlBuffer = new XMLBuffer();
            xmlBuffer.openTag("ldapanswer");
            res = new SampleResult();
            res.setResponseData("successfull", null);
            res.setResponseMessage("Success");
            res.setResponseCode("0");
            res.setContentType("text/xml");
            boolean isSuccessful = true;
            res.setSampleLabel(this.getName());
            DirContext dirContext = ldapContexts.get(this.getThreadName());
            try {
                xmlBuffer.openTag("operation");
                String testType = this.getTest();
                xmlBuffer.tag("opertype", (CharSequence)testType);
                log.debug("performing test: " + testType);
                if (testType.equals(UNBIND)) {
                    res.setSamplerData("Unbind");
                    xmlBuffer.tag("baseobj", (CharSequence)this.getRootdn());
                    xmlBuffer.tag("binddn", (CharSequence)this.getUserDN());
                    this.unbindOp(dirContext, res);
                    break block28;
                }
                if (testType.equals(BIND)) {
                    res.setSamplerData("Bind as " + this.getUserDN());
                    xmlBuffer.tag("baseobj", (CharSequence)this.getRootdn());
                    xmlBuffer.tag("binddn", (CharSequence)this.getUserDN());
                    xmlBuffer.tag("connectionTO", (CharSequence)this.getConnTimeOut());
                    this.bindOp(res);
                    break block28;
                }
                if (testType.equals(SBIND)) {
                    res.setSamplerData("SingleBind as " + this.getUserDN());
                    xmlBuffer.tag("baseobj", (CharSequence)this.getRootdn());
                    xmlBuffer.tag("binddn", (CharSequence)this.getUserDN());
                    xmlBuffer.tag("connectionTO", (CharSequence)this.getConnTimeOut());
                    this.singleBindOp(res);
                    break block28;
                }
                if (testType.equals(COMPARE)) {
                    res.setSamplerData("Compare " + this.getPropertyAsString(COMPAREFILT) + " " + this.getPropertyAsString(COMPAREDN));
                    xmlBuffer.tag(COMPAREDN, (CharSequence)this.getPropertyAsString(COMPAREDN));
                    xmlBuffer.tag("comparefilter", (CharSequence)this.getPropertyAsString(COMPAREFILT));
                    NamingEnumeration<SearchResult> cmp = null;
                    try {
                        res.sampleStart();
                        cmp = LdapExtClient.compare(dirContext, this.getPropertyAsString(COMPAREFILT), this.getPropertyAsString(COMPAREDN));
                        if (!cmp.hasMore()) {
                            res.setResponseCode("5");
                            res.setResponseMessage("compareFalse");
                            isSuccessful = false;
                        }
                        break block28;
                    }
                    finally {
                        res.sampleEnd();
                        if (cmp != null) {
                            cmp.close();
                        }
                    }
                }
                if (testType.equals(ADD)) {
                    res.setSamplerData("Add object " + this.getBaseEntryDN());
                    xmlBuffer.tag(ATTRIBS, (CharSequence)this.getArguments().toString());
                    xmlBuffer.tag("dn", (CharSequence)this.getBaseEntryDN());
                    this.addTest(dirContext, res);
                    break block28;
                }
                if (testType.equals(DELETE)) {
                    res.setSamplerData("Delete object " + this.getBaseEntryDN());
                    xmlBuffer.tag("dn", (CharSequence)this.getBaseEntryDN());
                    this.deleteTest(dirContext, res);
                    break block28;
                }
                if (testType.equals(MODIFY)) {
                    res.setSamplerData("Modify object " + this.getBaseEntryDN());
                    xmlBuffer.tag("dn", (CharSequence)this.getBaseEntryDN());
                    xmlBuffer.tag(ATTRIBS, (CharSequence)this.getLDAPArguments().toString());
                    this.modifyTest(dirContext, res);
                    break block28;
                }
                if (testType.equals(RENAME)) {
                    res.setSamplerData("ModDN object " + this.getPropertyAsString(MODDDN) + " to " + this.getPropertyAsString(NEWDN));
                    xmlBuffer.tag("dn", (CharSequence)this.getPropertyAsString(MODDDN));
                    xmlBuffer.tag(NEWDN, (CharSequence)this.getPropertyAsString(NEWDN));
                    this.renameTest(dirContext, res);
                    break block28;
                }
                if (!testType.equals("search")) break block28;
                String scopeStr = this.getScope();
                int scope = this.getScopeAsInt();
                String searchFilter = this.getPropertyAsString(SEARCHFILTER);
                String searchBase = this.getPropertyAsString("search");
                String timeLimit = this.getTimelim();
                String countLimit = this.getCountlim();
                res.setSamplerData("Search with filter " + searchFilter);
                xmlBuffer.tag(SEARCHFILTER, (CharSequence)StringEscapeUtils.escapeXml10((String)searchFilter));
                xmlBuffer.tag("baseobj", (CharSequence)this.getRootdn());
                xmlBuffer.tag("searchbase", (CharSequence)searchBase);
                xmlBuffer.tag(SCOPE, (CharSequence)scopeStr);
                xmlBuffer.tag(COUNTLIM, (CharSequence)countLimit);
                xmlBuffer.tag(TIMELIM, (CharSequence)timeLimit);
                NamingEnumeration<SearchResult> srch = null;
                try {
                    res.sampleStart();
                    srch = LdapExtClient.searchTest(dirContext, searchBase, searchFilter, scope, this.getCountlimAsLong(), this.getTimelimAsInt(), this.getRequestAttributes(this.getAttrs()), this.isRetobj(), this.isDeref());
                    if (this.isParseFlag()) {
                        try {
                            xmlBuffer.openTag("searchresults");
                            this.writeSearchResults(xmlBuffer, srch);
                            break block28;
                        }
                        finally {
                            xmlBuffer.closeTag("searchresults");
                        }
                    }
                    xmlBuffer.tag("searchresults", (CharSequence)("hasElements=" + srch.hasMoreElements()));
                }
                finally {
                    if (srch != null) {
                        srch.close();
                    }
                    res.sampleEnd();
                }
            }
            catch (NamingException ex) {
                String returnData = ex.toString();
                int indexOfLDAPErrCode = returnData.indexOf("LDAP: error code");
                if (indexOfLDAPErrCode >= 0) {
                    res.setResponseMessage(returnData.substring(indexOfLDAPErrCode + 21, returnData.indexOf(93)));
                    res.setResponseCode(returnData.substring(indexOfLDAPErrCode + 17, indexOfLDAPErrCode + 19));
                } else {
                    res.setResponseMessage(returnData);
                    res.setResponseCode("800");
                }
                isSuccessful = false;
            }
            finally {
                xmlBuffer.closeTag("operation");
                xmlBuffer.tag("responsecode", (CharSequence)res.getResponseCode());
                xmlBuffer.tag("responsemessage", (CharSequence)res.getResponseMessage());
                res.setResponseData(xmlBuffer.toString(), null);
                res.setDataType("text");
                res.setSuccessful(isSuccessful);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSearchResults(XMLBuffer xmlb, NamingEnumeration<SearchResult> srch) throws NamingException {
        Object sr;
        ArrayList<SearchResult> sortedResults = new ArrayList<SearchResult>(MAX_SORTED_RESULTS);
        String searchBase = this.getPropertyAsString("search");
        String rootDn = this.getRootdn();
        try {
            while (srch.hasMore() && sortedResults.size() < MAX_SORTED_RESULTS) {
                sr = srch.next();
                this.normaliseSearchDN((SearchResult)sr, searchBase, rootDn);
                sortedResults.add((SearchResult)sr);
            }
            this.sortResults(sortedResults);
        }
        catch (Throwable throwable) {
            this.sortResults(sortedResults);
            for (SearchResult sr2 : sortedResults) {
                this.writeSearchResult(sr2, xmlb);
            }
            throw throwable;
        }
        for (SearchResult sr3 : sortedResults) {
            this.writeSearchResult(sr3, xmlb);
        }
        while (srch.hasMore()) {
            sr = srch.next();
            this.normaliseSearchDN((SearchResult)sr, searchBase, rootDn);
            this.writeSearchResult((SearchResult)sr, xmlb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSearchResult(SearchResult sr, XMLBuffer xmlb) throws NamingException {
        Attributes attrs = sr.getAttributes();
        int size = attrs.size();
        ArrayList<Attribute> sortedAttrs = new ArrayList<Attribute>(size);
        xmlb.openTag("searchresult");
        xmlb.tag("dn", (CharSequence)sr.getName());
        xmlb.tag("returnedattr", (CharSequence)Integer.toString(size));
        xmlb.openTag(ATTRIBS);
        try {
            NamingEnumeration<? extends Attribute> en = attrs.getAll();
            while (en.hasMore()) {
                Attribute attr = en.next();
                sortedAttrs.add(attr);
            }
            this.sortAttributes(sortedAttrs);
            for (Attribute attr : sortedAttrs) {
                StringBuilder sb = new StringBuilder();
                if (attr.size() == 1) {
                    sb.append(this.getWriteValue(attr.get()));
                } else {
                    ArrayList<String> sortedVals = new ArrayList<String>(attr.size());
                    boolean first = true;
                    NamingEnumeration<?> ven = attr.getAll();
                    while (ven.hasMore()) {
                        String value = this.getWriteValue(ven.next());
                        sortedVals.add(value.toString());
                    }
                    Collections.sort(sortedVals);
                    for (String value : sortedVals) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(value);
                    }
                }
                xmlb.tag(attr.getID(), (CharSequence)sb);
            }
        }
        finally {
            xmlb.closeTag(ATTRIBS);
            xmlb.closeTag("searchresult");
        }
    }

    private void sortAttributes(List<Attribute> sortedAttrs) {
        sortedAttrs.sort((o1, o2) -> {
            String nm1 = o1.getID();
            String nm2 = o2.getID();
            return nm1.compareTo(nm2);
        });
    }

    private void sortResults(List<SearchResult> sortedResults) {
        sortedResults.sort(new Comparator<SearchResult>(){

            private int compareToReverse(String s1, String s2) {
                int len1 = s1.length();
                int len2 = s2.length();
                int s1i = len1 - 1;
                for (int s2i = len2 - 1; s1i >= 0 && s2i >= 0; --s1i, --s2i) {
                    char c2;
                    char c1 = s1.charAt(s1i);
                    if (c1 == (c2 = s2.charAt(s2i))) continue;
                    return c1 - c2;
                }
                return len1 - len2;
            }

            @Override
            public int compare(SearchResult o1, SearchResult o2) {
                String nm1 = o1.getName();
                String nm2 = o2.getName();
                if (nm1 == null) {
                    nm1 = "";
                }
                if (nm2 == null) {
                    nm2 = "";
                }
                return this.compareToReverse(nm1, nm2);
            }
        });
    }

    private String normaliseSearchDN(SearchResult sr, String searchBase, String rootDn) {
        String srName = sr.getName();
        if (!srName.endsWith(searchBase)) {
            if (srName.length() > 0) {
                srName = srName + ',';
            }
            srName = srName + searchBase;
        }
        if (rootDn.length() > 0 && !srName.endsWith(rootDn)) {
            if (srName.length() > 0) {
                srName = srName + ',';
            }
            srName = srName + rootDn;
        }
        sr.setName(srName);
        return srName;
    }

    private String getWriteValue(Object value) {
        if (value instanceof String) {
            return StringEscapeUtils.escapeXml10((String)((String)value));
        }
        if (value instanceof byte[]) {
            return StringEscapeUtils.escapeXml10((String)new String((byte[])value, StandardCharsets.UTF_8));
        }
        return StringEscapeUtils.escapeXml10((String)value.toString());
    }

    public void testStarted() {
        this.testStarted("");
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testStarted(String host) {
    }

    public void testEnded(String host) {
        for (Map.Entry<String, DirContext> entry : ldapContexts.entrySet()) {
            DirContext dc = entry.getValue();
            try {
                log.warn("Tidying old Context for thread: " + entry.getKey());
                dc.close();
            }
            catch (NamingException namingException) {}
        }
        ldapContexts.clear();
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

