/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.sampler;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapExtClient {
    private static final Logger log = LoggerFactory.getLogger(LdapExtClient.class);
    private static final String CONTEXT_IS_NULL = "Context is null";

    public static DirContext connect(String host, String port, String rootdn, String username, String password, String connTimeOut, boolean secure) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        StringBuilder sb = new StringBuilder(80);
        if (secure) {
            sb.append("ldaps://");
        } else {
            sb.append("ldap://");
        }
        sb.append(host);
        if (port.length() > 0) {
            sb.append(":");
            sb.append(port);
        }
        sb.append("/");
        sb.append(rootdn);
        env.put("java.naming.provider.url", sb.toString());
        log.info("prov_url= " + (String)env.get("java.naming.provider.url"));
        if (connTimeOut.length() > 0) {
            env.put("com.sun.jndi.ldap.connect.timeout", connTimeOut);
        }
        env.put("java.naming.referral", "throw");
        env.put("java.naming.batchsize", "0");
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.principal", username);
        InitialDirContext dirContext = new InitialDirContext(env);
        return dirContext;
    }

    public static void disconnect(DirContext dirContext) {
        if (dirContext == null) {
            log.info("Cannot disconnect null context");
            return;
        }
        try {
            dirContext.close();
        }
        catch (NamingException e) {
            log.warn("Ldap client disconnect - ", (Throwable)e);
        }
    }

    public static NamingEnumeration<SearchResult> searchTest(DirContext dirContext, String searchBase, String searchFilter, int scope, long countlim, int timelim, String[] attrs, boolean retobj, boolean deref) throws NamingException {
        if (dirContext == null) {
            throw new NamingException(CONTEXT_IS_NULL);
        }
        if (log.isDebugEnabled()) {
            log.debug("searchBase=" + searchBase + " scope=" + scope + " countlim=" + countlim + " timelim=" + timelim + " attrs=" + JMeterUtils.unsplit((Object[])attrs, (Object)",") + " retobj=" + retobj + " deref=" + deref + " filter=" + searchFilter);
        }
        SearchControls searchcontrols = new SearchControls(scope, countlim, timelim, attrs, retobj, deref);
        return dirContext.search(searchBase, searchFilter, searchcontrols);
    }

    public static NamingEnumeration<SearchResult> compare(DirContext dirContext, String filter, String entrydn) throws NamingException {
        if (dirContext == null) {
            throw new NamingException(CONTEXT_IS_NULL);
        }
        SearchControls searchcontrols = new SearchControls(0, 1L, 0, new String[0], false, false);
        return dirContext.search(entrydn, filter, searchcontrols);
    }

    public static void moddnOp(DirContext dirContext, String ddn, String newdn) throws NamingException {
        log.debug("ddn and newDn= " + ddn + "@@@@" + newdn);
        if (dirContext == null) {
            throw new NamingException(CONTEXT_IS_NULL);
        }
        dirContext.rename(ddn, newdn);
    }

    public static void modifyTest(DirContext dirContext, ModificationItem[] mods, String string) throws NamingException {
        if (dirContext == null) {
            throw new NamingException(CONTEXT_IS_NULL);
        }
        dirContext.modifyAttributes(string, mods);
    }

    public static DirContext createTest(DirContext dirContext, Attributes attributes, String string) throws NamingException {
        if (dirContext == null) {
            throw new NamingException(CONTEXT_IS_NULL);
        }
        return dirContext.createSubcontext(string, attributes);
    }

    public static void deleteTest(DirContext dirContext, String string) throws NamingException {
        if (dirContext == null) {
            throw new NamingException(CONTEXT_IS_NULL);
        }
        dirContext.destroySubcontext(string);
    }
}

