/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler.render;

import com.github.benmanes.caffeine.cache.Cache;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.jmeter.protocol.jms.sampler.render.MessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.TextMessageRenderer;

class ObjectMessageRenderer
implements MessageRenderer<Serializable> {
    TextMessageRenderer delegate;

    public ObjectMessageRenderer(TextMessageRenderer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Serializable getValueFromFile(String filename, String encoding, boolean hasVariable, Cache<Object, Object> cache) {
        Serializable value = hasVariable ? this.getInterpretedContent(filename, encoding, hasVariable, cache) : (Serializable)cache.get((Object)filename, _p -> this.getContent(filename));
        return value;
    }

    @Override
    public Serializable getValueFromText(String xmlMessage) {
        Serializable readObject = null;
        try {
            XStream xstream = new XStream();
            readObject = (Serializable)xstream.fromXML(xmlMessage, readObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load object instance from text", e);
        }
        return readObject;
    }

    protected Serializable getInterpretedContent(String filename, String encoding, boolean hasVariable, Cache<Object, Object> cache) {
        if ("<DEFAULT>".equals(encoding)) {
            encoding = this.findEncoding(filename);
        }
        Object stringValue = this.delegate.getValueFromFile(filename, encoding, hasVariable, (Cache)cache);
        Serializable value = (Serializable)new XStream().fromXML((String)stringValue);
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String findEncoding(String filename) {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        try (FileInputStream input = new FileInputStream(filename);){
            XMLStreamReader reader = factory.createXMLStreamReader(input);
            String string = reader.getEncoding();
            return string;
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(String.format("Unable to read %s", filename), e);
        }
    }

    protected Serializable getContent(String filename) {
        Serializable object = (Serializable)new XStream().fromXML(new File(filename));
        return object;
    }
}

