/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.jms.Message;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class MessageAdmin {
    private static final MessageAdmin SINGLETON = new MessageAdmin();
    private final Map<String, PlaceHolder> table = new ConcurrentHashMap<String, PlaceHolder>();
    private static final Logger log = LoggingManager.getLoggerForClass();

    private MessageAdmin() {
    }

    public static MessageAdmin getAdmin() {
        return SINGLETON;
    }

    public void putRequest(String id, Message request, CountDownLatch latch) {
        if (log.isDebugEnabled()) {
            log.debug("REQ_ID [" + id + "]");
        }
        this.table.put(id, new PlaceHolder(request, latch));
    }

    public void putReply(String id, Message reply) {
        PlaceHolder holder = this.table.get(id);
        if (log.isDebugEnabled()) {
            log.debug("RPL_ID [" + id + "] for holder " + holder);
        }
        if (holder != null) {
            holder.setReply(reply);
            CountDownLatch latch = holder.getLatch();
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + " releasing latch : " + latch);
            }
            latch.countDown();
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + " released latch : " + latch);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Failed to match reply: " + reply);
        }
    }

    public Message get(String id) {
        PlaceHolder holder = this.table.remove(id);
        if (log.isDebugEnabled()) {
            log.debug("GET_ID [" + id + "] for " + holder);
        }
        if (holder == null || !holder.hasReply()) {
            log.debug("Message with " + id + " not found.");
        }
        return holder == null ? null : (Message)holder.getReply();
    }

    private static final class PlaceHolder {
        private final CountDownLatch latch;
        private final Object request;
        private Object reply;

        PlaceHolder(Object original, CountDownLatch latch) {
            this.request = original;
            this.latch = latch;
        }

        void setReply(Object reply) {
            this.reply = reply;
        }

        public Object getReply() {
            return this.reply;
        }

        public Object getRequest() {
            return this.request;
        }

        boolean hasReply() {
            return this.reply != null;
        }

        public String toString() {
            return "request=" + this.request + ", reply=" + this.reply;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

