/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.client;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.client.InitialContextFactory;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Publisher
implements Closeable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final Connection connection;
    private final Session session;
    private final MessageProducer producer;
    private final Context ctx;
    private final boolean staticDest;

    public Publisher(boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, boolean useAuth, String securityPrincipal, String securityCredentials) throws JMSException, NamingException {
        this(useProps, initialContextFactory, providerUrl, connfactory, destinationName, useAuth, securityPrincipal, securityCredentials, true, false);
    }

    public Publisher(boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, boolean useAuth, String securityPrincipal, String securityCredentials, boolean useNonPersistentMessages) throws JMSException, NamingException {
        this(useProps, initialContextFactory, providerUrl, connfactory, destinationName, useAuth, securityPrincipal, securityCredentials, true, useNonPersistentMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publisher(boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, boolean useAuth, String securityPrincipal, String securityCredentials, boolean staticDestination, boolean useNonPersistentMessages) throws JMSException, NamingException {
        boolean initSuccess = false;
        try {
            this.ctx = InitialContextFactory.getContext(useProps, initialContextFactory, providerUrl, useAuth, securityPrincipal, securityCredentials);
            this.connection = Utils.getConnection(this.ctx, connfactory);
            this.session = this.connection.createSession(false, 1);
            this.staticDest = staticDestination;
            if (this.staticDest) {
                Destination dest = Utils.lookupDestination(this.ctx, destinationName);
                this.producer = this.session.createProducer(dest);
            } else {
                this.producer = this.session.createProducer(null);
            }
            if (useNonPersistentMessages) {
                this.producer.setDeliveryMode(1);
            }
            initSuccess = true;
        }
        finally {
            if (!initSuccess) {
                this.close();
            }
        }
    }

    public TextMessage publish(String text) throws JMSException, NamingException {
        return this.publish(text, null, null);
    }

    public TextMessage publish(String text, String destinationName) throws JMSException, NamingException {
        return this.publish(text, destinationName, null);
    }

    public TextMessage publish(String text, String destinationName, Map<String, String> properties) throws JMSException, NamingException {
        TextMessage msg = this.session.createTextMessage(text);
        Utils.addJMSProperties((Message)msg, properties);
        if (this.staticDest || destinationName == null) {
            this.producer.send((Message)msg);
        } else {
            Destination dest = Utils.lookupDestination(this.ctx, destinationName);
            this.producer.send(dest, (Message)msg);
        }
        return msg;
    }

    public ObjectMessage publish(Serializable contents) throws JMSException, NamingException {
        return this.publish(contents, null);
    }

    public ObjectMessage publish(Serializable contents, String destinationName) throws JMSException, NamingException {
        return this.publish(contents, destinationName, null);
    }

    public ObjectMessage publish(Serializable contents, String destinationName, Map<String, String> properties) throws JMSException, NamingException {
        ObjectMessage msg = this.session.createObjectMessage(contents);
        Utils.addJMSProperties((Message)msg, properties);
        if (this.staticDest || destinationName == null) {
            this.producer.send((Message)msg);
        } else {
            Destination dest = Utils.lookupDestination(this.ctx, destinationName);
            this.producer.send(dest, (Message)msg);
        }
        return msg;
    }

    public MapMessage publish(Map<String, Object> map) throws JMSException, NamingException {
        return this.publish(map, null, null);
    }

    public MapMessage publish(Map<String, Object> map, String destinationName) throws JMSException, NamingException {
        return this.publish(map, destinationName, null);
    }

    public MapMessage publish(Map<String, Object> map, String destinationName, Map<String, String> properties) throws JMSException, NamingException {
        MapMessage msg = this.session.createMapMessage();
        Utils.addJMSProperties((Message)msg, properties);
        for (Map.Entry<String, Object> me : map.entrySet()) {
            msg.setObject(me.getKey(), me.getValue());
        }
        if (this.staticDest || destinationName == null) {
            this.producer.send((Message)msg);
        } else {
            Destination dest = Utils.lookupDestination(this.ctx, destinationName);
            this.producer.send(dest, (Message)msg);
        }
        return msg;
    }

    @Override
    public void close() {
        Utils.close(this.producer, log);
        Utils.close(this.session, log);
        Utils.close(this.connection, log);
    }
}

