/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.sampler;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.util.ConfigMergabilityIndicator;
import org.apache.jmeter.protocol.jdbc.AbstractJDBCTestElement;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElement;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jorphan.util.JOrphanUtils;

public class JDBCSampler
extends AbstractJDBCTestElement
implements Sampler,
TestBean,
ConfigMergabilityIndicator {
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private static final long serialVersionUID = 234L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.toString());
        res.setDataType("text");
        res.setContentType("text/plain");
        res.setDataEncoding(ENCODING);
        res.setSuccessful(true);
        res.setResponseMessageOK();
        res.setResponseCodeOK();
        res.sampleStart();
        Connection conn = null;
        try {
            if (JOrphanUtils.isBlank((String)this.getDataSource())) {
                throw new IllegalArgumentException("Variable Name must not be null in " + this.getName());
            }
            try {
                conn = DataSourceElement.getConnection(this.getDataSource());
            }
            finally {
                res.connectEnd();
            }
            res.setResponseHeaders(conn.toString());
            res.setResponseData(this.execute(conn, res));
        }
        catch (SQLException ex) {
            String errCode = Integer.toString(ex.getErrorCode());
            res.setResponseMessage(ex.toString());
            res.setResponseCode(ex.getSQLState() + " " + errCode);
            res.setResponseData(ex.getMessage().getBytes());
            res.setSuccessful(false);
            JDBCSampler.close(conn);
        }
        catch (Exception ex2) {
            res.setResponseMessage(ex2.toString());
            res.setResponseCode("000");
            res.setResponseData(((String)ObjectUtils.defaultIfNull((Object)ex2.getMessage(), (Object)"NO MESSAGE")).getBytes());
            res.setSuccessful(false);
            {
                catch (Throwable throwable) {
                    JDBCSampler.close(conn);
                    throw throwable;
                }
            }
            JDBCSampler.close(conn);
        }
        JDBCSampler.close(conn);
        res.sampleEnd();
        return res;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

