/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.curl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.avalon.CLArgsParser;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCurlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicCurlParser.class);
    private static final int METHOD_OPT = 88;
    private static final int COMPRESSED_OPT = 99;
    private static final int HEADER_OPT = 72;
    private static final int DATA_OPT = 100;
    private static final int DATA_ASCII_OPT = "data-ascii".hashCode();
    private static final int DATA_BINARY_OPT = "data-binary".hashCode();
    private static final int DATA_URLENCODE_OPT = "data-urlencode".hashCode();
    private static final int DATA_RAW_OPT = "data-raw".hashCode();
    private static final int FORM_OPT = 70;
    private static final int FORM_STRING_OPT = "form".hashCode();
    private static final int USER_AGENT_OPT = 65;
    private static final int CONNECT_TIMEOUT_OPT = "connect-timeout".hashCode();
    private static final int COOKIE_OPT = 98;
    private static final int USER_OPT = 117;
    private static final int BASIC_OPT = "basic".hashCode();
    private static final int DIGEST_OPT = "digest".hashCode();
    private static final int CERT_OPT = 69;
    private static final int CAFILE_OPT = "cacert".hashCode();
    private static final int CAPATH_OPT = "capath".hashCode();
    private static final int CIPHERS_OPT = "ciphers".hashCode();
    private static final int CERT_STATUS_OPT = "cert-status".hashCode();
    private static final int CERT_TYPE_OPT = "cert-type".hashCode();
    private static final int KEY_OPT = "key".hashCode();
    private static final int KEY_TYPE_OPT = "key-type".hashCode();
    private static final int GET_OPT = 71;
    private static final int DNS_OPT = "dns-servers".hashCode();
    private static final int NO_KEEPALIVE_OPT = "no-keepalive".hashCode();
    private static final int REFERER_OPT = 101;
    private static final int LOCATION_OPT = 76;
    private static final int INCLUDE_OPT = 105;
    private static final int HEAD_OPT = 73;
    private static final int PROXY_OPT = 120;
    private static final int PROXY_USER_OPT = 85;
    private static final int PROXY_NTLM_OPT = "proxy-ntlm".hashCode();
    private static final int PROXY_NEGOTIATE_OPT = "proxy-negotiate".hashCode();
    private static final int KEEPALIVETILE_OPT = "keepalive-time".hashCode();
    private static final int MAX_TIME_OPT = 109;
    private static final int OUTPUT_OPT = 111;
    private static final int CREATE_DIRS_OPT = "create-dir".hashCode();
    private static final int INSECURE_OPT = 107;
    private static final int RAW_OPT = "raw".hashCode();
    private static final int INTERFACE_OPT = "interface".hashCode();
    private static final int DNS_RESOLVER_OPT = "resolve".hashCode();
    private static final int LIMIT_RATE_OPT = "limit-rate".hashCode();
    private static final int MAX_REDIRS_OPT = "max-redirs".hashCode();
    private static final int NOPROXY_OPT = "noproxy".hashCode();
    private static final int URL_OPT = "url".hashCode();
    private static final int VERBOSE_OPT = 118;
    private static final int SILENT_OPT = 115;
    private static final List<Integer> AUTH_OPT = Arrays.asList(BASIC_OPT, DIGEST_OPT);
    private static final List<Integer> SSL_OPT = Arrays.asList(CAFILE_OPT, CAPATH_OPT, 69, CIPHERS_OPT, CERT_STATUS_OPT, CERT_TYPE_OPT, KEY_OPT, KEY_TYPE_OPT);
    private static final List<Integer> DATAS_OPT = Arrays.asList(100, DATA_ASCII_OPT, DATA_BINARY_OPT, DATA_URLENCODE_OPT, DATA_RAW_OPT);
    private static final List<Integer> FORMS_OPT = Arrays.asList(70, FORM_STRING_OPT);
    private static final List<Integer> IGNORE_OPTIONS_OPT = Arrays.asList(111, CREATE_DIRS_OPT, RAW_OPT, 105, KEEPALIVETILE_OPT, 118, 115);
    private static final List<Integer> NOSUPPORT_OPTIONS_OPT = Arrays.asList(PROXY_NTLM_OPT, PROXY_NEGOTIATE_OPT);
    private static final List<Integer> PROPERTIES_OPT = Arrays.asList(MAX_REDIRS_OPT);
    private static final List<String> DYNAMIC_COOKIES = Arrays.asList("PHPSESSID", "JSESSIONID", "ASPSESSIONID", "connect.sid");
    private static final CLOptionDescriptor D_COMPRESSED_OPT = new CLOptionDescriptor("compressed", 8, 99, "Request compressed response (using deflate or gzip)");
    private static final CLOptionDescriptor D_HEADER_OPT = new CLOptionDescriptor("header", 34, 72, "Pass custom header LINE to server");
    private static final CLOptionDescriptor D_METHOD_OPT = new CLOptionDescriptor("request", 2, 88, "Pass custom header LINE to server");
    private static final CLOptionDescriptor D_DATA_OPT = new CLOptionDescriptor("data", 2, 100, "HTTP POST data");
    private static final CLOptionDescriptor D_DATA_ASCII_OPT = new CLOptionDescriptor("data-ascii", 2, DATA_ASCII_OPT, "HTTP POST ascii data ");
    private static final CLOptionDescriptor D_DATA_BINARY_OPT = new CLOptionDescriptor("data-binary", 2, DATA_BINARY_OPT, "HTTP POST binary data ");
    private static final CLOptionDescriptor D_DATA_URLENCODE_OPT = new CLOptionDescriptor("data-urlencode", 2, DATA_URLENCODE_OPT, "HTTP POST url encoding data ");
    private static final CLOptionDescriptor D_DATA_RAW_OPT = new CLOptionDescriptor("data-raw", 2, DATA_RAW_OPT, "HTTP POST url allowed '@' ");
    private static final CLOptionDescriptor D_FORM_OPT = new CLOptionDescriptor("form", 34, 70, "HTTP POST form data allowed '@' and ';Type='");
    private static final CLOptionDescriptor D_FORM_STRING_OPT = new CLOptionDescriptor("form-string", 34, FORM_STRING_OPT, "HTTP POST form data  ");
    private static final CLOptionDescriptor D_USER_AGENT_OPT = new CLOptionDescriptor("user-agent", 2, 65, "The User-Agent string");
    private static final CLOptionDescriptor D_CONNECT_TIMEOUT_OPT = new CLOptionDescriptor("connect-timeout", 2, CONNECT_TIMEOUT_OPT, "Maximum time in seconds that the connection to the server");
    private static final CLOptionDescriptor D_REFERER_OPT = new CLOptionDescriptor("referer", 2, 101, "Sends the 'Referer Page' information to the HTTP server ");
    private static final CLOptionDescriptor D_COOKIE_OPT = new CLOptionDescriptor("cookie", 2, 98, "Pass the data to the HTTP server as a cookie");
    private static final CLOptionDescriptor D_URL_OPT = new CLOptionDescriptor("url", 2, URL_OPT, "url");
    private static final CLOptionDescriptor D_USER_OPT = new CLOptionDescriptor("user", 2, 117, "User and password to use for server authentication. ");
    private static final CLOptionDescriptor D_BASIC_OPT = new CLOptionDescriptor("basic", 8, BASIC_OPT, "HTTP Basic authentication ");
    private static final CLOptionDescriptor D_DIGEST_OPT = new CLOptionDescriptor("digest", 8, DIGEST_OPT, "HTTP digest authentication ");
    private static final CLOptionDescriptor D_CERT_OPT = new CLOptionDescriptor("cert", 2, 69, " The specified client certificate file for SSL");
    private static final CLOptionDescriptor D_CACERT_OPT = new CLOptionDescriptor("cacert", 2, CAFILE_OPT, "Use the specified certificate file to verify the peer. ");
    private static final CLOptionDescriptor D_CAPATH_OPT = new CLOptionDescriptor("capath", 2, CAPATH_OPT, "Use the specified certificate directory to verify the peer. ");
    private static final CLOptionDescriptor D_CIPHERS_OPT = new CLOptionDescriptor("ciphers", 2, CIPHERS_OPT, "The ciphers to use in the connection. ");
    private static final CLOptionDescriptor D_CERT_STATUS_OPT = new CLOptionDescriptor("cert-status", 8, CERT_STATUS_OPT, "Tells curl to verify the status of the server certificate by using the Certificate Status Request TLS extension. ");
    private static final CLOptionDescriptor D_CERT_TYPE_OPT = new CLOptionDescriptor("cert-type", 2, CERT_TYPE_OPT, "Tells curl the type of certificate type of the provided certificate. PEM, DER and ENG are recognized types ");
    private static final CLOptionDescriptor D_KEY_OPT = new CLOptionDescriptor("key", 2, KEY_OPT, "Private key file name. Allows you to provide your private key in this separate file. ");
    private static final CLOptionDescriptor D_KEY_TYPE_OPT = new CLOptionDescriptor("key-type", 2, KEY_TYPE_OPT, "Private key file type. Specify which type your --key provided private key is.");
    private static final CLOptionDescriptor D_GET_OPT = new CLOptionDescriptor("get", 8, 71, "Put the post data in the url and use get to replace post. ");
    private static final CLOptionDescriptor D_DNS_SERVERS_OPT = new CLOptionDescriptor("dns-servers", 2, DNS_OPT, "Resolve host name over DOH. ");
    private static final CLOptionDescriptor D_NO_KEEPALIVE_OPT = new CLOptionDescriptor("no-keepalive", 8, NO_KEEPALIVE_OPT, "Disabled keep-alive ");
    private static final CLOptionDescriptor D_LOCATION_OPT = new CLOptionDescriptor("location", 8, 76, "Follow Redirect ");
    private static final CLOptionDescriptor D_INCLUDE_OPT = new CLOptionDescriptor("include", 8, 105, "Include the HTTP-header in the output ");
    private static final CLOptionDescriptor D_HEAD_OPT = new CLOptionDescriptor("head", 8, 73, "Fetch the HTTP-header only");
    private static final CLOptionDescriptor D_INSECURE_OPT = new CLOptionDescriptor("insecure", 8, 107, "Allows curl to perform insecure SSL connections and transfers");
    private static final CLOptionDescriptor D_PROXY_OPT = new CLOptionDescriptor("proxy", 2, 120, "Use the specified HTTP proxy. If the port number is not specified, it is assumed at port 1080.");
    private static final CLOptionDescriptor D_PROXY_USER_OPT = new CLOptionDescriptor("proxy-user", 2, 85, "Specify user and password to use for proxy authentication.");
    private static final CLOptionDescriptor D_PROXY_NTLM_OPT = new CLOptionDescriptor("proxy-ntlm", 8, PROXY_NTLM_OPT, "Tells curl to use HTTP ntlm authentication when communicating with the given proxy. ");
    private static final CLOptionDescriptor D_PROXY_NEGOTIATE_OPT = new CLOptionDescriptor("proxy-negotiate", 8, PROXY_NEGOTIATE_OPT, "Tells curl to use HTTP negotiate authentication when communicating with the given proxy. ");
    private static final CLOptionDescriptor D_KEEPALIVETILE_OPT = new CLOptionDescriptor("keepalive-time", 2, KEEPALIVETILE_OPT, " This option sets the  time  a  connection  needs  to  remain  idle  before  sending keepalive  probes and the time between individual keepalive probes..");
    private static final CLOptionDescriptor D_MAX_TIME_OPT = new CLOptionDescriptor("max-time", 2, 109, "Maximum time in seconds that you allow the whole operation to take. ");
    private static final CLOptionDescriptor D_OUTPUT_OPT = new CLOptionDescriptor("output", 2, 111, "Write result to a file");
    private static final CLOptionDescriptor D_CREATE_DIRS_OPT = new CLOptionDescriptor("create-dir", 8, CREATE_DIRS_OPT, "Create the necessary local directory hierarchy as needed for output file");
    private static final CLOptionDescriptor D_RAW_OPT = new CLOptionDescriptor("raw", 8, RAW_OPT, "When used, it disables all internal HTTP decoding of content or transfer encodings and instead makes them passed on unaltered raw. ");
    private static final CLOptionDescriptor D_INTERFACE_OPT = new CLOptionDescriptor("interface", 2, INTERFACE_OPT, "Perform an operation using a specified interface");
    private static final CLOptionDescriptor D_DNS_RESOLVER_OPT = new CLOptionDescriptor("resolve", 2, DNS_RESOLVER_OPT, "Provide a custom address for a specific host and port pair");
    private static final CLOptionDescriptor D_LIMIT_RATE_OPT = new CLOptionDescriptor("limit-rate", 2, LIMIT_RATE_OPT, "Specify the maximum transfer rate you want curl to use");
    private static final CLOptionDescriptor D_MAX_REDIRS = new CLOptionDescriptor("max-redirs", 2, MAX_REDIRS_OPT, "Set maximum number of redirections");
    private static final CLOptionDescriptor D_NOPROXY = new CLOptionDescriptor("noproxy", 2, NOPROXY_OPT, "Comma-separated list of hosts which do not use a proxy, if one is specified. ");
    private static final CLOptionDescriptor D_SILENT = new CLOptionDescriptor("silent", 4, 115, "silent mode");
    private static final CLOptionDescriptor D_VERBOSE = new CLOptionDescriptor("verbose", 4, 118, "verbose mode");
    private static final Pattern deleteLinePattern = Pattern.compile("\r|\n|\r\n");
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{D_COMPRESSED_OPT, D_HEADER_OPT, D_METHOD_OPT, D_DATA_OPT, D_DATA_ASCII_OPT, D_DATA_URLENCODE_OPT, D_DATA_RAW_OPT, D_DATA_BINARY_OPT, D_FORM_OPT, D_FORM_STRING_OPT, D_USER_AGENT_OPT, D_CONNECT_TIMEOUT_OPT, D_COOKIE_OPT, D_URL_OPT, D_USER_OPT, D_BASIC_OPT, D_DIGEST_OPT, D_CACERT_OPT, D_CAPATH_OPT, D_CERT_OPT, D_CERT_STATUS_OPT, D_CERT_TYPE_OPT, D_CIPHERS_OPT, D_KEY_OPT, D_KEY_TYPE_OPT, D_GET_OPT, D_DNS_SERVERS_OPT, D_NO_KEEPALIVE_OPT, D_REFERER_OPT, D_LOCATION_OPT, D_INCLUDE_OPT, D_INSECURE_OPT, D_HEAD_OPT, D_PROXY_OPT, D_PROXY_USER_OPT, D_PROXY_NTLM_OPT, D_PROXY_NEGOTIATE_OPT, D_KEEPALIVETILE_OPT, D_MAX_TIME_OPT, D_OUTPUT_OPT, D_CREATE_DIRS_OPT, D_RAW_OPT, D_INTERFACE_OPT, D_DNS_RESOLVER_OPT, D_LIMIT_RATE_OPT, D_MAX_REDIRS, D_NOPROXY, D_VERBOSE, D_SILENT};

    public Request parse(String commandLine) {
        String[] args = BasicCurlParser.translateCommandline(commandLine);
        CLArgsParser parser = new CLArgsParser(args, OPTIONS);
        String error = parser.getErrorString();
        boolean isPostToGet = false;
        if (error == null) {
            Vector clOptions = parser.getArguments();
            Request request = new Request();
            for (CLOption option : clOptions) {
                String value;
                String nameAndValue;
                if (option.getDescriptor().getId() == URL_OPT) {
                    request.setUrl(option.getArgument());
                    continue;
                }
                if (option.getDescriptor().getId() == 99) {
                    request.setCompressed(true);
                    continue;
                }
                if (option.getDescriptor().getId() == 72) {
                    nameAndValue = option.getArgument(0);
                    int indexOfSemicolon = nameAndValue.indexOf(58);
                    String name = nameAndValue.substring(0, indexOfSemicolon).trim();
                    String value2 = nameAndValue.substring(indexOfSemicolon + 1).trim();
                    request.addHeader(name, value2);
                    continue;
                }
                if (option.getDescriptor().getId() == 88) {
                    value = option.getArgument(0);
                    request.setMethod(value);
                    continue;
                }
                if (DATAS_OPT.contains(option.getDescriptor().getId())) {
                    value = option.getArgument(0);
                    String dataOptionName = option.getDescriptor().getName();
                    value = this.getPostDataByDifferentOption(value.trim(), dataOptionName);
                    request.setMethod("POST");
                    request.setPostData(value);
                    continue;
                }
                if (FORMS_OPT.contains(option.getDescriptor().getId())) {
                    nameAndValue = option.getArgument(0);
                    int indexOfEqual = nameAndValue.indexOf(61);
                    String key = nameAndValue.substring(0, indexOfEqual).trim();
                    String value3 = nameAndValue.substring(indexOfEqual + 1).trim();
                    if ("form-string".equals(option.getDescriptor().getName())) {
                        request.addFormStringData(key, value3);
                    } else {
                        request.addFormData(key, value3);
                    }
                    request.setMethod("POST");
                    continue;
                }
                if (option.getDescriptor().getId() == 65) {
                    request.addHeader("User-Agent", option.getArgument(0));
                    continue;
                }
                if (option.getDescriptor().getId() == 101) {
                    request.addHeader("Referer", option.getArgument(0));
                    continue;
                }
                if (option.getDescriptor().getId() == CONNECT_TIMEOUT_OPT) {
                    value = option.getArgument(0);
                    request.setConnectTimeout(Double.parseDouble(value) * 1000.0);
                    continue;
                }
                if (option.getDescriptor().getId() == 98) {
                    value = option.getArgument(0);
                    if (BasicCurlParser.isValidCookie(value)) {
                        request.setCookies(value);
                        continue;
                    }
                    request.setFilepathCookie(value);
                    continue;
                }
                if (option.getDescriptor().getId() == 117) {
                    value = option.getArgument(0);
                    this.setAuthUserPasswd(value, request.getUrl(), request.getAuthorization());
                    continue;
                }
                if (AUTH_OPT.contains(option.getDescriptor().getId())) {
                    String authOption = option.getDescriptor().getName();
                    this.setAuthMechanism(authOption, request.getAuthorization());
                    continue;
                }
                if (SSL_OPT.contains(option.getDescriptor().getId())) {
                    request.setCaCert(option.getDescriptor().getName());
                    continue;
                }
                if (option.getDescriptor().getId() == 71) {
                    isPostToGet = true;
                    continue;
                }
                if (option.getDescriptor().getId() == DNS_OPT) {
                    String[] dnsServer;
                    value = option.getArgument(0);
                    for (String s : dnsServer = value.split(",")) {
                        request.addDnsServers(s);
                    }
                    continue;
                }
                if (option.getDescriptor().getId() == NO_KEEPALIVE_OPT) {
                    request.setKeepAlive(false);
                    continue;
                }
                if (option.getDescriptor().getId() == 120) {
                    value = option.getArgument(0);
                    this.setProxyServer(request, value);
                    continue;
                }
                if (option.getDescriptor().getId() == 85) {
                    value = option.getArgument(0);
                    this.setProxyServerUserInfo(request, value);
                    continue;
                }
                if (option.getDescriptor().getId() == 109) {
                    value = option.getArgument(0);
                    request.setMaxTime(Double.parseDouble(value) * 1000.0);
                    continue;
                }
                if (option.getDescriptor().getId() == 73) {
                    request.setMethod("HEAD");
                    continue;
                }
                if (option.getDescriptor().getId() == INTERFACE_OPT) {
                    value = option.getArgument(0);
                    request.setInterfaceName(value);
                    continue;
                }
                if (option.getDescriptor().getId() == DNS_RESOLVER_OPT) {
                    value = option.getArgument(0);
                    request.setDnsResolver(value);
                    continue;
                }
                if (option.getDescriptor().getId() == LIMIT_RATE_OPT) {
                    value = option.getArgument(0);
                    request.setLimitRate(value);
                    continue;
                }
                if (option.getDescriptor().getId() == NOPROXY_OPT) {
                    value = option.getArgument(0);
                    request.setNoproxy(value);
                    continue;
                }
                if (IGNORE_OPTIONS_OPT.contains(option.getDescriptor().getId())) {
                    request.addOptionsIgnored(option.getDescriptor().getName());
                    continue;
                }
                if (NOSUPPORT_OPTIONS_OPT.contains(option.getDescriptor().getId())) {
                    request.addOptionsNoSupport(option.getDescriptor().getName());
                    continue;
                }
                if (PROPERTIES_OPT.contains(option.getDescriptor().getId())) {
                    request.addOptionsInProperties("--" + option.getDescriptor().getName() + " is in 'httpsampler.max_redirects(1062 line)'");
                    continue;
                }
                if (option.getDescriptor().getId() != 0 || "CURL".equalsIgnoreCase(option.getArgument())) continue;
                try {
                    request.setUrl(new URL(option.getArgument()).toExternalForm());
                }
                catch (MalformedURLException ex) {
                    LOGGER.warn("Unhandled option {}", (Object)option.getArgument());
                }
            }
            if (isPostToGet) {
                String url = request.getUrl() + "?" + request.getPostData();
                request.setUrl(url);
                request.setPostData(null);
                request.setMethod("GET");
            }
            return request;
        }
        throw new IllegalArgumentException("Unexpected format for command line:" + commandLine + ", error:" + error);
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.isEmpty()) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() > 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("unbalanced quotes in " + toProcess);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setAuthUserPasswd(String authentication, String url, Authorization authorization) {
        String[] authorizationParameters = authentication.split(":", 2);
        authorization.setUser(authorizationParameters[0].trim());
        authorization.setPass(authorizationParameters[1].trim());
        authorization.setURL(url);
    }

    private void setAuthMechanism(String mechanism, Authorization authorization) {
        switch (mechanism.toLowerCase()) {
            case "basic": {
                authorization.setMechanism(AuthManager.Mechanism.BASIC);
                break;
            }
            case "digest": {
                authorization.setMechanism(AuthManager.Mechanism.DIGEST);
                break;
            }
        }
    }

    private void setProxyServer(Request request, String originalProxyServerParameters) {
        String proxyServerParameters = originalProxyServerParameters;
        if (!proxyServerParameters.contains("://")) {
            proxyServerParameters = "http://" + proxyServerParameters;
        }
        try {
            URI uriProxy = new URI(proxyServerParameters);
            request.setProxyServer("scheme", uriProxy.getScheme());
            Optional<String> userInfoOptional = Optional.ofNullable(uriProxy.getUserInfo());
            userInfoOptional.ifPresent(s -> this.setProxyServerUserInfo(request, (String)s));
            Optional<String> hostOptional = Optional.ofNullable(uriProxy.getHost());
            hostOptional.ifPresent(s -> request.setProxyServer("servername", (String)s));
            if (uriProxy.getPort() != -1) {
                request.setProxyServer("port", String.valueOf(uriProxy.getPort()));
            } else {
                request.setProxyServer("port", "1080");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(proxyServerParameters + " cannot be converted to a URL", e);
        }
    }

    private void setProxyServerUserInfo(Request request, String authentication) {
        if (authentication.contains(":")) {
            String[] userInfo = authentication.split(":", 2);
            request.setProxyServer("username", userInfo[0]);
            request.setProxyServer("password", userInfo[1]);
        }
    }

    private String getPostDataByDifferentOption(String originalPostdata, String dataOptionName) {
        String postdata = originalPostdata;
        if ("data-urlencode".equals(dataOptionName)) {
            postdata = this.encodePostdata(postdata);
        } else if (postdata.charAt(0) == '@' && !"data-raw".equals(dataOptionName)) {
            postdata = postdata.substring(1, postdata.length());
            postdata = BasicCurlParser.readFromFile(postdata);
            if (!"data-binary".equals(dataOptionName)) {
                postdata = BasicCurlParser.deleteLineBreak(postdata);
            }
        }
        return postdata;
    }

    private String encodePostdata(String postdata) {
        if (postdata.contains("@")) {
            String contentFile = null;
            String[] arr = postdata.split("@", 2);
            String dataToEncode = BasicCurlParser.readFromFile(arr[1]);
            try {
                contentFile = URLEncoder.encode(dataToEncode, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(dataToEncode + " cannot be encoded", e);
            }
            if (!arr[0].isEmpty()) {
                contentFile = arr[0] + "=" + contentFile;
            }
            return contentFile;
        }
        if (!postdata.contains("=")) {
            try {
                return URLEncoder.encode(postdata, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(postdata + " cannot be encoded", e);
            }
        }
        int index = postdata.indexOf(61);
        try {
            return postdata.substring(0, index + 1) + URLEncoder.encode(postdata.substring(index + 1, postdata.length()), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(postdata.substring(index + 1, postdata.length()) + " cannot be encoded", e);
        }
    }

    private static String readFromFile(String filePath) {
        File file = new File(filePath.trim());
        if (file.isFile() && file.exists()) {
            try {
                return FileUtils.readFileToString((File)file, (String)StandardCharsets.UTF_8.name());
            }
            catch (IOException e) {
                LOGGER.error("Failed to read from File {}", (Object)filePath, (Object)e);
                throw new IllegalArgumentException("Failed to read from File " + filePath);
            }
        }
        throw new IllegalArgumentException(filePath + " is a directory or does not exist");
    }

    private static String deleteLineBreak(String postdata) {
        Matcher m = deleteLinePattern.matcher(postdata);
        return m.replaceAll("");
    }

    public static boolean isValidCookie(String str) {
        for (String r : str.split(";")) {
            if (r.contains("=")) continue;
            return false;
        }
        return true;
    }

    public static List<Cookie> stringToCookie(String cookieStr, String url) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        StringTokenizer tok = new StringTokenizer(cookieStr, "; ", true);
        while (tok.hasMoreTokens()) {
            String[] cookieParameters;
            String nextCookie = tok.nextToken();
            if (!nextCookie.contains("=") || DYNAMIC_COOKIES.contains((cookieParameters = nextCookie.split("=", 2))[0])) continue;
            Cookie newCookie = new Cookie();
            newCookie.setName(cookieParameters[0]);
            newCookie.setValue(cookieParameters[1]);
            try {
                URL newUrl = new URL(url.trim());
                newCookie.setDomain(newUrl.getHost());
                newCookie.setPath(newUrl.getPath());
                cookies.add(newCookie);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("unqualified url " + url.trim() + ", unable to create cookies.");
            }
        }
        return cookies;
    }

    public static final class Request {
        private boolean compressed;
        private String url;
        private Map<String, String> headers = new LinkedHashMap<String, String>();
        private String method = "GET";
        private String postData;
        private String interfaceName;
        private double connectTimeout = -1.0;
        private String cookies = "";
        private String cookieInHeaders = "";
        private String filepathCookie = "";
        private Authorization authorization = new Authorization();
        private String caCert = "";
        private Map<String, String> formData = new LinkedHashMap<String, String>();
        private Map<String, String> formStringData = new LinkedHashMap<String, String>();
        private Set<String> dnsServers = new HashSet<String>();
        private boolean isKeepAlive = true;
        private double maxTime = -1.0;
        private List<String> optionsIgnored = new ArrayList<String>();
        private List<String> optionsNoSupport = new ArrayList<String>();
        private List<String> optionsInProperties = new ArrayList<String>();
        private Map<String, String> proxyServer = new LinkedHashMap<String, String>();
        private String dnsResolver;
        private int limitRate = 0;
        private String noproxy;
        private static final List<String> HEADERS_TO_IGNORE = Arrays.asList("Connection", "Host");
        private static final int ONE_KILOBYTE_IN_CPS = 1024;

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setPostData(String value) {
            this.postData = value;
        }

        public String getPostData() {
            return this.postData;
        }

        public boolean isCompressed() {
            return this.compressed;
        }

        public void setCompressed(boolean compressed) {
            this.compressed = compressed;
        }

        public void addHeader(String name, String value) {
            if ("COOKIE".equalsIgnoreCase(name)) {
                this.cookieInHeaders = value;
            } else if (!HEADERS_TO_IGNORE.contains(name)) {
                this.headers.put(name, value);
            }
        }

        public List<Cookie> getCookieInHeaders(String url) {
            return Collections.unmodifiableList(BasicCurlParser.stringToCookie(this.cookieInHeaders, url));
        }

        public void setCookieInHeaders(String cookieInHeaders) {
            this.cookieInHeaders = cookieInHeaders;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.headers);
        }

        public List<String> getOptionsInProperties() {
            return Collections.unmodifiableList(this.optionsInProperties);
        }

        public void addOptionsInProperties(String option) {
            this.optionsInProperties.add(option);
        }

        public int getLimitRate() {
            return this.limitRate;
        }

        public void setLimitRate(String limitRate) {
            String unit = limitRate.substring(limitRate.length() - 1, limitRate.length()).toLowerCase();
            int value = Integer.parseInt(limitRate.substring(0, limitRate.length() - 1).toLowerCase());
            switch (unit) {
                case "k": {
                    this.limitRate = value * 1024;
                    break;
                }
                case "m": {
                    this.limitRate = value * 1024 * 1000;
                    break;
                }
                case "g": {
                    this.limitRate = value * 1024 * 1000000;
                    break;
                }
            }
        }

        public String getNoproxy() {
            return this.noproxy;
        }

        public void setNoproxy(String noproxy) {
            this.noproxy = noproxy;
        }

        public String getDnsResolver() {
            return this.dnsResolver;
        }

        public void setDnsResolver(String dnsResolver) {
            this.dnsResolver = dnsResolver;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public List<String> getOptionsIgnored() {
            return Collections.unmodifiableList(this.optionsIgnored);
        }

        public void addOptionsIgnored(String option) {
            this.optionsIgnored.add(option);
        }

        public List<String> getOptionsNoSupport() {
            return Collections.unmodifiableList(this.optionsNoSupport);
        }

        public void addOptionsNoSupport(String option) {
            this.optionsNoSupport.add(option);
        }

        public Map<String, String> getProxyServer() {
            return Collections.unmodifiableMap(this.proxyServer);
        }

        public void setProxyServer(String key, String value) {
            this.proxyServer.put(key, value);
        }

        public boolean isKeepAlive() {
            return this.isKeepAlive;
        }

        public void setKeepAlive(boolean isKeepAlive) {
            this.isKeepAlive = isKeepAlive;
        }

        public Set<String> getDnsServers() {
            return Collections.unmodifiableSet(this.dnsServers);
        }

        public void addDnsServers(String dnsServer) {
            this.dnsServers.add(dnsServer);
        }

        public Map<String, String> getFormStringData() {
            return Collections.unmodifiableMap(this.formStringData);
        }

        public void addFormStringData(String key, String value) {
            this.formStringData.put(key, value);
        }

        public Map<String, String> getFormData() {
            return Collections.unmodifiableMap(this.formData);
        }

        public void addFormData(String key, String value) {
            this.formData.put(key, value);
        }

        public String getCaCert() {
            return this.caCert;
        }

        public void setCaCert(String caCert) {
            this.caCert = caCert;
        }

        public Authorization getAuthorization() {
            return this.authorization;
        }

        public double getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(double connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public double getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(double maxTime) {
            this.maxTime = maxTime;
        }

        public String getFilepathCookie() {
            return this.filepathCookie;
        }

        public void setFilepathCookie(String filepathCookie) {
            this.filepathCookie = filepathCookie;
        }

        public List<Cookie> getCookies(String url) {
            return Collections.unmodifiableList(BasicCurlParser.stringToCookie(this.cookies, url));
        }

        public void setCookies(String cookies) {
            this.cookies = cookies;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Request [compressed=");
            builder.append(this.compressed);
            builder.append(", url=");
            builder.append(this.url);
            builder.append(", method=");
            builder.append(this.method);
            builder.append(", headers=");
            builder.append(this.headers);
            builder.append("]");
            return builder.toString();
        }
    }
}

