/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosScheme;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.api.auth.DigestParameters;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.DNSCacheManager;
import org.apache.jmeter.protocol.http.control.DynamicKerberosSchemeFactory;
import org.apache.jmeter.protocol.http.control.DynamicSPNegoSchemeFactory;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPHCAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HttpWebdav;
import org.apache.jmeter.protocol.http.sampler.hc.LaxDeflateInputStream;
import org.apache.jmeter.protocol.http.sampler.hc.LazyLayeredConnectionSocketFactory;
import org.apache.jmeter.protocol.http.util.EncoderCache;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.protocol.http.util.SlowHCPlainConnectionSocketFactory;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.brotli.dec.BrotliInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPHC4Impl
extends HTTPHCAbstractImpl {
    private static final String CONTEXT_ATTRIBUTE_AUTH_MANAGER = "__jmeter.A_M__";
    private static final String JMETER_VARIABLE_USER_TOKEN = "__jmeter.U_T__";
    static final String CONTEXT_ATTRIBUTE_SAMPLER_RESULT = "__jmeter.S_R__";
    private static final String CONTEXT_ATTRIBUTE_HTTPCLIENT_TOKEN = "__jmeter.H_T__";
    private static final String CONTEXT_ATTRIBUTE_CLIENT_KEY = "__jmeter.C_K__";
    private static final String CONTEXT_ATTRIBUTE_SENT_BYTES = "__jmeter.S_B__";
    private static final String CONTEXT_ATTRIBUTE_METRICS = "__jmeter.M__";
    private static final boolean DEFLATE_RELAX_MODE = JMeterUtils.getPropDefault((String)"httpclient4.deflate_relax_mode", (boolean)false);
    private static final Logger log = LoggerFactory.getLogger(HTTPHC4Impl.class);
    private static final InputStreamFactory GZIP = new InputStreamFactory(){

        public InputStream create(InputStream instream) throws IOException {
            return new GZIPInputStream(instream);
        }
    };
    private static final InputStreamFactory DEFLATE = new InputStreamFactory(){

        public InputStream create(InputStream instream) throws IOException {
            return new LaxDeflateInputStream(instream, DEFLATE_RELAX_MODE);
        }
    };
    private static final InputStreamFactory BROTLI = new InputStreamFactory(){

        public InputStream create(InputStream instream) throws IOException {
            return new BrotliInputStream(instream);
        }
    };
    private static final int RETRY_COUNT = JMeterUtils.getPropDefault((String)"httpclient4.retrycount", (int)0);
    private static final boolean REQUEST_SENT_RETRY_ENABLED = JMeterUtils.getPropDefault((String)"httpclient4.request_sent_retry_enabled", (boolean)false);
    private static final int IDLE_TIMEOUT = JMeterUtils.getPropDefault((String)"httpclient4.idletimeout", (int)0);
    private static final int VALIDITY_AFTER_INACTIVITY_TIMEOUT = JMeterUtils.getPropDefault((String)"httpclient4.validate_after_inactivity", (int)1700);
    private static final int TIME_TO_LIVE = JMeterUtils.getPropDefault((String)"httpclient4.time_to_live", (int)2000);
    private static final boolean BASIC_AUTH_PREEMPTIVE = JMeterUtils.getPropDefault((String)"httpclient4.auth.preemptive", (boolean)true);
    private static final Pattern PORT_PATTERN = Pattern.compile("\\d+");
    private static final ConnectionKeepAliveStrategy IDLE_STRATEGY = new DefaultConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long duration = super.getKeepAliveDuration(response, context);
            if (duration <= 0L && IDLE_TIMEOUT > 0) {
                log.debug("Setting keepalive to {}", (Object)IDLE_TIMEOUT);
                return IDLE_TIMEOUT;
            }
            return duration;
        }
    };
    private static final String DIGEST_PARAMETERS = "__jmeter_DP__";
    private static final HttpRequestInterceptor PREEMPTIVE_AUTH_INTERCEPTOR = new PreemptiveAuthRequestInterceptor();
    private static final HttpRequestExecutor REQUEST_EXECUTOR = new HttpRequestExecutor(){

        protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
            HttpResponse response = super.doSendRequest(request, conn, context);
            HttpConnectionMetrics metrics = conn.getMetrics();
            long sentBytesCount = metrics.getSentBytesCount();
            context.setAttribute(HTTPHC4Impl.CONTEXT_ATTRIBUTE_SENT_BYTES, (Object)metrics.getSentBytesCount());
            context.setAttribute(HTTPHC4Impl.CONTEXT_ATTRIBUTE_METRICS, (Object)metrics);
            log.debug("Sent {} bytes", (Object)sentBytesCount);
            metrics.reset();
            return response;
        }
    };
    private static final String[] HEADERS_TO_SAVE = new String[]{"content-length", "content-encoding", "content-md5"};
    private static final HttpResponseInterceptor RESPONSE_CONTENT_ENCODING = new ResponseContentEncoding(HTTPHC4Impl.createLookupRegistry()){

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            org.apache.http.Header ceheader;
            ArrayList<org.apache.http.Header[]> headersToSave = null;
            HttpEntity entity = response.getEntity();
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            RequestConfig requestConfig = clientContext.getRequestConfig();
            if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
                headersToSave = new ArrayList<org.apache.http.Header[]>(3);
                for (String name : HEADERS_TO_SAVE) {
                    org.apache.http.Header[] hdr = response.getHeaders(name);
                    headersToSave.add(hdr);
                }
            }
            super.process(response, (HttpContext)clientContext);
            if (headersToSave != null) {
                Iterator iterator = headersToSave.iterator();
                while (iterator.hasNext()) {
                    org.apache.http.Header[] headers;
                    for (org.apache.http.Header headerToRestore : headers = (org.apache.http.Header[])iterator.next()) {
                        if (response.containsHeader(headerToRestore.getName())) break;
                        response.addHeader(headerToRestore);
                    }
                }
            }
        }
    };
    private static final ThreadLocal<Map<HttpClientKey, Pair<CloseableHttpClient, PoolingHttpClientConnectionManager>>> HTTPCLIENTS_CACHE_PER_THREAD_AND_HTTPCLIENTKEY = InheritableThreadLocal.withInitial(() -> new HashMap(5));
    private static final ConnectionSocketFactory CONNECTION_SOCKET_FACTORY;
    private static final ViewableFileBody[] EMPTY_FILE_BODIES;
    private volatile HttpUriRequest currentRequest;

    protected HTTPHC4Impl(HTTPSamplerBase testElement) {
        super(testElement);
    }

    private static Lookup<InputStreamFactory> createLookupRegistry() {
        return RegistryBuilder.create().register("br", (Object)BROTLI).register("gzip", (Object)GZIP).register("x-gzip", (Object)GZIP).register("deflate", (Object)DEFLATE).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        if (log.isDebugEnabled()) {
            log.debug("Start : sample {} method {} followingRedirect {} depth {}", new Object[]{url, method, areFollowingRedirect, frameDepth});
        }
        JMeterVariables jMeterVariables = JMeterContextService.getContext().getVariables();
        HTTPSampleResult res = this.createSampleResult(url, method);
        CloseableHttpClient httpClient = null;
        HttpRequestBase httpRequest = null;
        BasicHttpContext localContext = new BasicHttpContext();
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)localContext);
        clientContext.setAttribute(CONTEXT_ATTRIBUTE_AUTH_MANAGER, (Object)this.getAuthManager());
        try {
            httpClient = this.setupClient(jMeterVariables, url, clientContext);
            URI uri = url.toURI();
            httpRequest = this.createHttpRequest(uri, method, areFollowingRedirect);
            this.setupRequest(url, httpRequest, res);
        }
        catch (Exception e) {
            res.sampleStart();
            res.sampleEnd();
            this.errorResult(e, res);
            return res;
        }
        this.setupClientContextBeforeSample(jMeterVariables, (HttpContext)localContext);
        res.sampleStart();
        CacheManager cacheManager = this.getCacheManager();
        if (cacheManager != null && "GET".equalsIgnoreCase(method) && cacheManager.inCache(url, httpRequest.getAllHeaders())) {
            return this.updateSampleResultForResourceInCache(res);
        }
        CloseableHttpResponse httpResponse = null;
        try {
            HttpEntity entity;
            this.currentRequest = httpRequest;
            this.handleMethod(method, res, httpRequest, (HttpContext)localContext);
            localContext.setAttribute(CONTEXT_ATTRIBUTE_SAMPLER_RESULT, (Object)res);
            httpResponse = this.executeRequest(httpClient, httpRequest, (HttpContext)localContext, url);
            HttpRequest request = (HttpRequest)localContext.getAttribute("http.request");
            this.extractClientContextAfterSample(jMeterVariables, (HttpContext)localContext);
            if (localAddress != null) {
                request.addHeader("X-LocalAddress", localAddress.toString());
            }
            res.setRequestHeaders(this.getAllHeadersExceptCookie(request));
            org.apache.http.Header contentType = httpResponse.getLastHeader("Content-Type");
            if (contentType != null) {
                String ct = contentType.getValue();
                res.setContentType(ct);
                res.setEncodingAndType(ct);
            }
            if ((entity = httpResponse.getEntity()) != null) {
                res.setResponseData(this.readResponse((SampleResult)res, entity.getContent(), entity.getContentLength()));
            }
            res.sampleEnd();
            this.currentRequest = null;
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            res.setResponseCode(Integer.toString(statusCode));
            res.setResponseMessage(statusLine.getReasonPhrase());
            res.setSuccessful(this.isSuccessCode(statusCode));
            res.setResponseHeaders(this.getResponseHeaders((HttpResponse)httpResponse));
            if (res.isRedirect()) {
                org.apache.http.Header headerLocation = httpResponse.getLastHeader("Location");
                if (headerLocation == null) {
                    throw new IllegalArgumentException("Missing location header in redirect for " + httpRequest.getRequestLine());
                }
                String redirectLocation = headerLocation.getValue();
                res.setRedirectLocation(redirectLocation);
            }
            long headerBytes = (long)res.getResponseHeaders().length() + (long)httpResponse.getAllHeaders().length + 1L + 2L;
            HttpConnectionMetrics metrics = (HttpConnectionMetrics)localContext.getAttribute(CONTEXT_ATTRIBUTE_METRICS);
            long totalBytes = metrics.getReceivedBytesCount();
            res.setHeadersSize((int)headerBytes);
            res.setBodySize(totalBytes - headerBytes);
            res.setSentBytes((Long)localContext.getAttribute(CONTEXT_ATTRIBUTE_SENT_BYTES));
            if (log.isDebugEnabled()) {
                long total = (long)res.getHeadersSize() + res.getBodySizeAsLong();
                log.debug("ResponseHeadersSize={} Content-Length={} Total={}", new Object[]{res.getHeadersSize(), res.getBodySizeAsLong(), total});
            }
            if (this.getAutoRedirects()) {
                HttpUriRequest req = (HttpUriRequest)localContext.getAttribute("http.request");
                HttpHost target = (HttpHost)localContext.getAttribute("http.target_host");
                URI redirectURI = req.getURI();
                if (redirectURI.isAbsolute()) {
                    res.setURL(redirectURI.toURL());
                } else {
                    res.setURL(new URL(new URL(target.toURI()), redirectURI.toString()));
                }
            }
            this.saveConnectionCookies((HttpResponse)httpResponse, res.getURL(), this.getCookieManager());
            if (cacheManager != null) {
                cacheManager.saveDetails((HttpResponse)httpResponse, res);
            }
            res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
            if (!this.isSuccessCode(statusCode)) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
        catch (IOException e) {
            log.debug("IOException", (Throwable)e);
            if (res.getEndTime() == 0L) {
                res.sampleEnd();
            }
            if (res.getRequestHeaders() != null) {
                log.debug("Overwriting request old headers: {}", (Object)res.getRequestHeaders());
            }
            res.setRequestHeaders(this.getAllHeadersExceptCookie((HttpRequest)localContext.getAttribute("http.request")));
            this.errorResult(e, res);
            HTTPSampleResult hTTPSampleResult = res;
            JOrphanUtils.closeQuietly((Closeable)httpResponse);
            this.currentRequest = null;
            JMeterContextService.getContext().getSamplerContext().remove(CONTEXT_ATTRIBUTE_HTTPCLIENT_TOKEN);
            return hTTPSampleResult;
        }
        catch (RuntimeException e2) {
            log.debug("RuntimeException", (Throwable)e2);
            if (res.getEndTime() == 0L) {
                res.sampleEnd();
            }
            this.errorResult(e2, res);
            HTTPSampleResult hTTPSampleResult = res;
            {
                catch (Throwable throwable) {
                    JOrphanUtils.closeQuietly(httpResponse);
                    this.currentRequest = null;
                    JMeterContextService.getContext().getSamplerContext().remove(CONTEXT_ATTRIBUTE_HTTPCLIENT_TOKEN);
                    throw throwable;
                }
            }
            JOrphanUtils.closeQuietly((Closeable)httpResponse);
            this.currentRequest = null;
            JMeterContextService.getContext().getSamplerContext().remove(CONTEXT_ATTRIBUTE_HTTPCLIENT_TOKEN);
            return hTTPSampleResult;
        }
        JOrphanUtils.closeQuietly((Closeable)httpResponse);
        this.currentRequest = null;
        JMeterContextService.getContext().getSamplerContext().remove(CONTEXT_ATTRIBUTE_HTTPCLIENT_TOKEN);
        return res;
    }

    private HttpRequestBase createHttpRequest(URI uri, String method, boolean areFollowingRedirect) {
        Object result;
        if (method.equals("POST")) {
            result = new HttpPost(uri);
        } else if (method.equals("GET")) {
            result = !areFollowingRedirect && (!this.hasArguments() && this.getSendFileAsPostBody() || this.getSendParameterValuesAsPostBody()) ? new HttpGetWithEntity(uri) : new HttpGet(uri);
        } else if (method.equals("PUT")) {
            result = new HttpPut(uri);
        } else if (method.equals("HEAD")) {
            result = new HttpHead(uri);
        } else if (method.equals("TRACE")) {
            result = new HttpTrace(uri);
        } else if (method.equals("OPTIONS")) {
            result = new HttpOptions(uri);
        } else if (method.equals("DELETE")) {
            result = new HttpDelete(uri);
        } else if (method.equals("PATCH")) {
            result = new HttpPatch(uri);
        } else if (HttpWebdav.isWebdavMethod(method)) {
            result = new HttpWebdav(method, uri);
        } else {
            throw new IllegalArgumentException("Unexpected method: '" + method + "'");
        }
        return result;
    }

    private void extractClientContextAfterSample(JMeterVariables jMeterVariables, HttpContext localContext) {
        Object userToken = localContext.getAttribute("http.user-token");
        if (userToken != null) {
            log.debug("Extracted from HttpContext user token:{} storing it as JMeter variable:{}", userToken, (Object)JMETER_VARIABLE_USER_TOKEN);
            if (jMeterVariables != null) {
                jMeterVariables.putObject(JMETER_VARIABLE_USER_TOKEN, userToken);
            }
        }
    }

    private void setupClientContextBeforeSample(JMeterVariables jMeterVariables, HttpContext localContext) {
        Object userToken = null;
        if (jMeterVariables != null) {
            userToken = jMeterVariables.getObject(JMETER_VARIABLE_USER_TOKEN);
        }
        if (userToken != null) {
            log.debug("Found user token:{} as JMeter variable:{}, storing it in HttpContext", userToken, (Object)JMETER_VARIABLE_USER_TOKEN);
            localContext.setAttribute("http.user-token", userToken);
        } else {
            String userId = Thread.currentThread().getName();
            log.debug("Storing in HttpContext the user token: {}", (Object)userId);
            localContext.setAttribute("http.user-token", (Object)userId);
        }
    }

    protected void handleMethod(String method, HTTPSampleResult result, HttpRequestBase httpRequest, HttpContext localContext) throws IOException {
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            String entityBody = this.setupHttpEntityEnclosingRequestData((HttpEntityEnclosingRequestBase)httpRequest);
            result.setQueryString(entityBody);
        }
    }

    protected HTTPSampleResult createSampleResult(URL url, String method) {
        HTTPSampleResult res = new HTTPSampleResult();
        res.setSampleLabel(this.testElement.getName());
        res.setHTTPMethod(method);
        res.setURL(url);
        return res;
    }

    private CloseableHttpResponse executeRequest(CloseableHttpClient httpClient, HttpRequestBase httpRequest, HttpContext localContext, URL url) throws IOException {
        Subject subject;
        AuthManager authManager = this.getAuthManager();
        if (authManager != null && (subject = authManager.getSubjectForUrl(url)) != null) {
            try {
                return Subject.doAs(subject, () -> httpClient.execute((HttpUriRequest)httpRequest, localContext));
            }
            catch (PrivilegedActionException e) {
                log.error("Can't execute httpRequest with subject: {}", (Object)subject, (Object)e);
                throw new RuntimeException("Can't execute httpRequest with subject:" + subject, e);
            }
        }
        return httpClient.execute((HttpUriRequest)httpRequest, localContext);
    }

    private CloseableHttpClient setupClient(JMeterVariables jMeterVariables, URL url, HttpClientContext clientContext) throws GeneralSecurityException {
        boolean useProxy;
        Map<HttpClientKey, Pair<CloseableHttpClient, PoolingHttpClientConnectionManager>> mapHttpClientPerHttpClientKey = HTTPCLIENTS_CACHE_PER_THREAD_AND_HTTPCLIENTKEY.get();
        String host = url.getHost();
        String proxyHost = this.getProxyHost();
        int proxyPort = this.getProxyPortInt();
        String proxyPass = this.getProxyPass();
        String proxyUser = this.getProxyUser();
        boolean useStaticProxy = HTTPHC4Impl.isStaticProxy(host);
        boolean useDynamicProxy = this.isDynamicProxy(proxyHost, proxyPort);
        boolean bl = useProxy = useStaticProxy || useDynamicProxy;
        if (!useDynamicProxy) {
            proxyHost = PROXY_HOST;
            proxyPort = PROXY_PORT;
            proxyUser = PROXY_USER;
            proxyPass = PROXY_PASS;
        }
        HttpClientKey key = new HttpClientKey(url, useProxy, proxyHost, proxyPort, proxyUser, proxyPass);
        clientContext.setAttribute(CONTEXT_ATTRIBUTE_CLIENT_KEY, (Object)key);
        CloseableHttpClient httpClient = null;
        boolean concurrentDwn = this.testElement.isConcurrentDwn();
        if (concurrentDwn) {
            httpClient = (CloseableHttpClient)JMeterContextService.getContext().getSamplerContext().get(CONTEXT_ATTRIBUTE_HTTPCLIENT_TOKEN);
        }
        Pair<CloseableHttpClient, PoolingHttpClientConnectionManager> pair = mapHttpClientPerHttpClientKey.get(key);
        if (httpClient == null) {
            httpClient = pair != null ? (CloseableHttpClient)pair.getLeft() : null;
        }
        this.resetStateIfNeeded(jMeterVariables, clientContext, mapHttpClientPerHttpClientKey);
        if (httpClient == null) {
            DNSCacheManager resolver = this.testElement.getDNSResolver();
            if (resolver == null) {
                resolver = SystemDefaultDnsResolver.INSTANCE;
            }
            Registry registry = RegistryBuilder.create().register("https", (Object)new LazyLayeredConnectionSocketFactory()).register("http", (Object)CONNECTION_SOCKET_FACTORY).build();
            PoolingHttpClientConnectionManager pHCCM = new PoolingHttpClientConnectionManager((HttpClientConnectionOperator)new JMeterDefaultHttpClientConnectionOperator((Lookup<ConnectionSocketFactory>)registry, null, resolver), null, (long)TIME_TO_LIVE, TimeUnit.MILLISECONDS);
            pHCCM.setValidateAfterInactivity(VALIDITY_AFTER_INACTIVITY_TIMEOUT);
            if (concurrentDwn) {
                try {
                    int maxConcurrentDownloads = Integer.parseInt(this.testElement.getConcurrentPool());
                    pHCCM.setDefaultMaxPerRoute(Math.max(maxConcurrentDownloads, pHCCM.getDefaultMaxPerRoute()));
                }
                catch (NumberFormatException maxConcurrentDownloads) {
                    // empty catch block
                }
            }
            IgnoreSpecProvider cookieSpecProvider = new IgnoreSpecProvider();
            Registry cookieSpecRegistry = RegistryBuilder.create().register("ignoreCookies", (Object)cookieSpecProvider).build();
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)pHCCM).setSchemePortResolver((SchemePortResolver)new DefaultSchemePortResolver()).setDnsResolver((DnsResolver)resolver).setRequestExecutor(REQUEST_EXECUTOR).setSSLSocketFactory((LayeredConnectionSocketFactory)new LazyLayeredConnectionSocketFactory()).setDefaultCookieSpecRegistry((Lookup)cookieSpecRegistry).setDefaultSocketConfig(SocketConfig.DEFAULT).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setConnectionTimeToLive((long)TIME_TO_LIVE, TimeUnit.MILLISECONDS).setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(RETRY_COUNT, REQUEST_SENT_RETRY_ENABLED)).setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE);
            Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory()).register("NTLM", (Object)new NTLMSchemeFactory()).register("Negotiate", (Object)new DynamicSPNegoSchemeFactory(AuthManager.STRIP_PORT, AuthManager.USE_CANONICAL_HOST_NAME)).register("Kerberos", (Object)new DynamicKerberosSchemeFactory(AuthManager.STRIP_PORT, AuthManager.USE_CANONICAL_HOST_NAME)).build();
            builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
            if (IDLE_TIMEOUT > 0) {
                builder.setKeepAliveStrategy(IDLE_STRATEGY);
            }
            if (useProxy) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                builder.setProxy(proxy);
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                if (proxyUser.length() > 0) {
                    credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUser, proxyPass, LOCALHOST, PROXY_DOMAIN));
                }
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            builder.disableContentCompression().addInterceptorLast(RESPONSE_CONTENT_ENCODING);
            if (BASIC_AUTH_PREEMPTIVE) {
                builder.addInterceptorFirst(PREEMPTIVE_AUTH_INTERCEPTOR);
            }
            httpClient = builder.build();
            if (log.isDebugEnabled()) {
                log.debug("Created new HttpClient: @" + System.identityHashCode(httpClient) + " " + key.toString());
            }
            mapHttpClientPerHttpClientKey.put(key, (Pair<CloseableHttpClient, PoolingHttpClientConnectionManager>)Pair.of((Object)httpClient, (Object)pHCCM));
        } else if (log.isDebugEnabled()) {
            log.debug("Reusing the HttpClient: @" + System.identityHashCode(httpClient) + " " + key.toString());
        }
        if (concurrentDwn) {
            JMeterContextService.getContext().getSamplerContext().put(CONTEXT_ATTRIBUTE_HTTPCLIENT_TOKEN, httpClient);
        }
        return httpClient;
    }

    private void resetStateIfNeeded(JMeterVariables jMeterVariables, HttpClientContext clientContext, Map<HttpClientKey, Pair<CloseableHttpClient, PoolingHttpClientConnectionManager>> mapHttpClientPerHttpClientKey) {
        if (((Boolean)resetStateOnThreadGroupIteration.get()).booleanValue()) {
            this.closeCurrentConnections(mapHttpClientPerHttpClientKey);
            clientContext.removeAttribute("http.user-token");
            ((JsseSSLManager)SSLManager.getInstance()).resetContext();
            resetStateOnThreadGroupIteration.set(false);
        }
    }

    private void closeCurrentConnections(Map<HttpClientKey, Pair<CloseableHttpClient, PoolingHttpClientConnectionManager>> mapHttpClientPerHttpClientKey) {
        for (Pair<CloseableHttpClient, PoolingHttpClientConnectionManager> pair : mapHttpClientPerHttpClientKey.values()) {
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = (PoolingHttpClientConnectionManager)pair.getRight();
            poolingHttpClientConnectionManager.closeExpiredConnections();
            poolingHttpClientConnectionManager.closeIdleConnections(1L, TimeUnit.MICROSECONDS);
        }
    }

    protected void setupRequest(URL url, HttpRequestBase httpRequest, HTTPSampleResult res) throws IOException {
        int cto;
        RequestConfig.Builder rCB = RequestConfig.custom();
        InetAddress inetAddr = this.getIpSourceAddress();
        if (inetAddr != null) {
            rCB.setLocalAddress(inetAddr);
        } else if (localAddress != null) {
            rCB.setLocalAddress(localAddress);
        }
        int rto = this.getResponseTimeout();
        if (rto > 0) {
            rCB.setSocketTimeout(rto);
        }
        if ((cto = this.getConnectTimeout()) > 0) {
            rCB.setConnectTimeout(cto);
        }
        rCB.setRedirectsEnabled(this.getAutoRedirects());
        rCB.setMaxRedirects(HTTPSamplerBase.MAX_REDIRECTS);
        httpRequest.setConfig(rCB.build());
        if (this.getUseKeepAlive()) {
            httpRequest.setHeader("Connection", "keep-alive");
        } else {
            httpRequest.setHeader("Connection", "close");
        }
        this.setConnectionHeaders(httpRequest, url, this.getHeaderManager(), this.getCacheManager());
        String cookies = this.setConnectionCookie((HttpRequest)httpRequest, url, this.getCookieManager());
        if (res != null) {
            if (cookies != null && !cookies.isEmpty()) {
                res.setCookies(cookies);
            } else {
                res.setCookies(this.getOnlyCookieFromHeaders((HttpRequest)httpRequest));
            }
        }
    }

    protected void setDefaultRequestHeaders(HttpRequest request) {
    }

    private String getResponseHeaders(HttpResponse response) {
        org.apache.http.Header[] rh = response.getAllHeaders();
        StringBuilder headerBuf = new StringBuilder(40 * (rh.length + 1));
        headerBuf.append(response.getStatusLine());
        headerBuf.append("\n");
        for (org.apache.http.Header responseHeader : rh) {
            this.writeHeader(headerBuf, responseHeader);
        }
        return headerBuf.toString();
    }

    private void writeHeader(StringBuilder headerBuffer, org.apache.http.Header header) {
        if (header instanceof BufferedHeader) {
            CharArrayBuffer buffer = ((BufferedHeader)header).getBuffer();
            headerBuffer.append(buffer.buffer(), 0, buffer.length()).append('\n');
        } else {
            headerBuffer.append(header.getName()).append(": ").append(header.getValue()).append('\n');
        }
    }

    protected String setConnectionCookie(HttpRequest request, URL url, CookieManager cookieManager) {
        String cookieHeader = null;
        if (cookieManager != null && (cookieHeader = cookieManager.getCookieHeaderForURL(url)) != null) {
            request.setHeader("Cookie", cookieHeader);
        }
        return cookieHeader;
    }

    protected void setConnectionHeaders(HttpRequestBase request, URL url, HeaderManager headerManager, CacheManager cacheManager) {
        CollectionProperty headers;
        if (headerManager != null && (headers = headerManager.getHeaders()) != null) {
            for (JMeterProperty jMeterProperty : headers) {
                Header header = (Header)jMeterProperty.getObjectValue();
                String headerName = header.getName();
                if ("Content-Length".equalsIgnoreCase(headerName)) continue;
                String headerValue = header.getValue();
                if ("Host".equalsIgnoreCase(headerName)) {
                    int port = this.getPortFromHostHeader(headerValue, url.getPort());
                    headerValue = headerValue.replaceFirst(":\\d+$", "");
                    if (port != -1 && port == url.getDefaultPort()) {
                        port = -1;
                    }
                    if (port == -1) {
                        request.addHeader("Host", headerValue);
                        continue;
                    }
                    request.addHeader("Host", headerValue + ":" + port);
                    continue;
                }
                request.addHeader(headerName, headerValue);
            }
        }
        if (cacheManager != null) {
            cacheManager.setHeaders(url, request);
        }
    }

    private int getPortFromHostHeader(String hostHeaderValue, int defaultValue) {
        String portString;
        String[] hostParts = hostHeaderValue.split(":");
        if (hostParts.length > 1 && PORT_PATTERN.matcher(portString = hostParts[hostParts.length - 1]).matches()) {
            return Integer.parseInt(portString);
        }
        return defaultValue;
    }

    private String getAllHeadersExceptCookie(HttpRequest method) {
        return this.getFromHeadersMatchingPredicate(method, ALL_EXCEPT_COOKIE);
    }

    private String getOnlyCookieFromHeaders(HttpRequest method) {
        String cookieHeader = this.getFromHeadersMatchingPredicate(method, ONLY_COOKIE).trim();
        if (!cookieHeader.isEmpty()) {
            return cookieHeader.substring("Cookie:".length(), cookieHeader.length()).trim();
        }
        return "";
    }

    private String getFromHeadersMatchingPredicate(HttpRequest method, Predicate<String> predicate) {
        if (method != null) {
            org.apache.http.Header[] requestHeaders;
            StringBuilder hdrs = new StringBuilder(150);
            for (org.apache.http.Header requestHeader : requestHeaders = method.getAllHeaders()) {
                if (!predicate.test(requestHeader.getName())) continue;
                this.writeHeader(hdrs, requestHeader);
            }
            return hdrs.toString();
        }
        return "";
    }

    protected String setupHttpEntityEnclosingRequestData(HttpEntityEnclosingRequestBase entityEnclosingRequest) throws IOException {
        boolean haveContentEncoding;
        StringBuilder postedBody = new StringBuilder(1000);
        HTTPFileArg[] files = this.getHTTPFiles();
        String contentEncoding = this.getContentEncodingOrNull();
        boolean bl = haveContentEncoding = contentEncoding != null;
        if (this.getUseMultipart()) {
            Charset charset = haveContentEncoding ? Charset.forName(contentEncoding) : MIME.DEFAULT_CHARSET;
            if (log.isDebugEnabled()) {
                log.debug("Building multipart with:getDoBrowserCompatibleMultipart(): {}, with charset:{}, haveContentEncoding:{}", new Object[]{this.getDoBrowserCompatibleMultipart(), charset, haveContentEncoding});
            }
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            if (this.getDoBrowserCompatibleMultipart()) {
                multipartEntityBuilder.setLaxMode();
            } else {
                multipartEntityBuilder.setStrictMode();
            }
            for (JMeterProperty jMeterProperty : this.getArguments()) {
                String parameterName;
                HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                if (arg.isSkippable(parameterName = arg.getName())) continue;
                StringBody stringBody = new StringBody(arg.getValue(), ContentType.create((String)arg.getContentType(), (Charset)charset));
                FormBodyPart formPart = FormBodyPartBuilder.create((String)parameterName, (ContentBody)stringBody).build();
                multipartEntityBuilder.addPart(formPart);
            }
            ViewableFileBody[] fileBodies = new ViewableFileBody[files.length];
            for (int i = 0; i < files.length; ++i) {
                HTTPFileArg file = files[i];
                File reservedFile = FileServer.getFileServer().getResolvedFile(file.getPath());
                fileBodies[i] = new ViewableFileBody(reservedFile, ContentType.create((String)file.getMimeType()));
                multipartEntityBuilder.addPart(file.getParamName(), (ContentBody)fileBodies[i]);
            }
            HttpEntity entity = multipartEntityBuilder.build();
            entityEnclosingRequest.setEntity(entity);
            this.writeEntityToSB(postedBody, entity, fileBodies, contentEncoding);
        } else {
            boolean hasContentTypeHeader;
            org.apache.http.Header contentTypeHeader = entityEnclosingRequest.getFirstHeader("Content-Type");
            boolean bl2 = hasContentTypeHeader = contentTypeHeader != null && contentTypeHeader.getValue() != null && contentTypeHeader.getValue().length() > 0;
            if (!this.hasArguments() && this.getSendFileAsPostBody()) {
                HTTPFileArg file = files[0];
                if (!hasContentTypeHeader) {
                    if (file.getMimeType() != null && file.getMimeType().length() > 0) {
                        entityEnclosingRequest.setHeader("Content-Type", file.getMimeType());
                    } else if (ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                        entityEnclosingRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                }
                FileEntity fileRequestEntity = new FileEntity(new File(file.getPath()), (ContentType)null);
                entityEnclosingRequest.setEntity((HttpEntity)fileRequestEntity);
                postedBody.append("<actual file content, not shown here>");
            } else if (this.getSendParameterValuesAsPostBody()) {
                if (!hasContentTypeHeader) {
                    HTTPFileArg file;
                    HTTPFileArg hTTPFileArg = file = files.length > 0 ? files[0] : null;
                    if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
                        entityEnclosingRequest.setHeader("Content-Type", file.getMimeType());
                    } else if (ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                        entityEnclosingRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                }
                StringBuilder postBody = new StringBuilder();
                for (JMeterProperty jMeterProperty : this.getArguments()) {
                    HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                    if (haveContentEncoding) {
                        postBody.append(arg.getEncodedValue(contentEncoding));
                        continue;
                    }
                    postBody.append(arg.getEncodedValue());
                }
                StringEntity requestEntity = new StringEntity(postBody.toString(), contentEncoding);
                entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
                postedBody.append(postBody.toString());
            } else {
                if (!hasContentTypeHeader && ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                    entityEnclosingRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
                }
                String urlContentEncoding = contentEncoding;
                UrlEncodedFormEntity entity = this.createUrlEncodedFormEntity(urlContentEncoding);
                entityEnclosingRequest.setEntity((HttpEntity)entity);
                this.writeEntityToSB(postedBody, (HttpEntity)entity, EMPTY_FILE_BODIES, contentEncoding);
            }
        }
        return postedBody.toString();
    }

    private void writeEntityToSB(StringBuilder postedBody, HttpEntity entity, ViewableFileBody[] fileBodies, String contentEncoding) throws IOException {
        if (entity.isRepeatable()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (ViewableFileBody fileBody : fileBodies) {
                fileBody.hideFileData = true;
            }
            entity.writeTo((OutputStream)bos);
            for (ViewableFileBody fileBody : fileBodies) {
                fileBody.hideFileData = false;
            }
            bos.flush();
            postedBody.append(bos.toString(contentEncoding == null ? SampleResult.DEFAULT_HTTP_ENCODING : contentEncoding));
            bos.close();
        } else {
            postedBody.append("<Entity was not repeatable, cannot view what was sent>");
        }
    }

    protected String sendEntityData(HttpEntityEnclosingRequestBase entity) throws IOException {
        HTTPFileArg file;
        boolean hasEntityBody = false;
        HTTPFileArg[] files = this.getHTTPFiles();
        HTTPFileArg hTTPFileArg = file = files.length > 0 ? files[0] : null;
        if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
            String contentTypeValue = file.getMimeType();
            entity.setHeader("Content-Type", contentTypeValue);
        }
        String charset = this.getContentEncoding(HTTP.DEF_CONTENT_CHARSET.name());
        if (!this.hasArguments() && this.getSendFileAsPostBody()) {
            hasEntityBody = true;
            File reservedFile = FileServer.getFileServer().getResolvedFile(files[0].getPath());
            FileEntity fileRequestEntity = new FileEntity(reservedFile);
            entity.setEntity((HttpEntity)fileRequestEntity);
        } else if (this.getSendParameterValuesAsPostBody()) {
            hasEntityBody = true;
            Arguments arguments = this.getArguments();
            StringBuilder entityBodyContent = new StringBuilder(arguments.getArgumentCount() * 15);
            for (JMeterProperty jMeterProperty : arguments) {
                HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                if (charset != null) {
                    entityBodyContent.append(arg.getEncodedValue(charset));
                    continue;
                }
                entityBodyContent.append(arg.getEncodedValue());
            }
            StringEntity requestEntity = new StringEntity(entityBodyContent.toString(), charset);
            entity.setEntity((HttpEntity)requestEntity);
        } else if (this.hasArguments()) {
            hasEntityBody = true;
            entity.setEntity((HttpEntity)this.createUrlEncodedFormEntity(this.getContentEncodingOrNull()));
        }
        if (hasEntityBody) {
            HttpEntity entityEntry = entity.getEntity();
            StringBuilder entityBody = new StringBuilder(65);
            this.writeEntityToSB(entityBody, entityEntry, EMPTY_FILE_BODIES, charset);
            return entityBody.toString();
        }
        return "";
    }

    private UrlEncodedFormEntity createUrlEncodedFormEntity(String contentEncoding) throws UnsupportedEncodingException {
        PropertyIterator args = this.getArguments().iterator();
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        String urlContentEncoding = contentEncoding;
        if (urlContentEncoding == null || urlContentEncoding.length() == 0) {
            urlContentEncoding = EncoderCache.URL_ARGUMENT_ENCODING;
        }
        while (args.hasNext()) {
            String parameterName;
            HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
            if (arg.isSkippable(parameterName = arg.getName())) continue;
            String parameterValue = arg.getValue();
            if (!arg.isAlwaysEncoded()) {
                parameterName = URLDecoder.decode(parameterName, urlContentEncoding);
                parameterValue = URLDecoder.decode(parameterValue, urlContentEncoding);
            }
            nvps.add(new BasicNameValuePair(parameterName, parameterValue));
        }
        return new UrlEncodedFormEntity(nvps, urlContentEncoding);
    }

    private String getContentEncodingOrNull() {
        return this.getContentEncoding(null);
    }

    private String getContentEncoding(String dflt) {
        String ce = this.getContentEncoding();
        if (HTTPHC4Impl.isNullOrEmptyTrimmed(ce)) {
            return dflt;
        }
        return ce;
    }

    private void saveConnectionCookies(HttpResponse method, URL u, CookieManager cookieManager) {
        if (cookieManager != null) {
            org.apache.http.Header[] hdrs;
            for (org.apache.http.Header hdr : hdrs = method.getHeaders("set-cookie")) {
                cookieManager.addCookieFromHeader(hdr.getValue(), u);
            }
        }
    }

    @Override
    protected void notifyFirstSampleAfterLoopRestart() {
        log.debug("notifyFirstSampleAfterLoopRestart called with config(httpclient.reset_state_on_thread_group_iteration={})", (Object)RESET_STATE_ON_THREAD_GROUP_ITERATION);
        resetStateOnThreadGroupIteration.set(RESET_STATE_ON_THREAD_GROUP_ITERATION);
    }

    @Override
    protected void threadFinished() {
        log.debug("Thread Finished");
        this.closeThreadLocalConnections();
    }

    private void closeThreadLocalConnections() {
        Map<HttpClientKey, Pair<CloseableHttpClient, PoolingHttpClientConnectionManager>> mapHttpClientPerHttpClientKey = HTTPCLIENTS_CACHE_PER_THREAD_AND_HTTPCLIENTKEY.get();
        if (mapHttpClientPerHttpClientKey != null) {
            for (Pair<CloseableHttpClient, PoolingHttpClientConnectionManager> pair : mapHttpClientPerHttpClientKey.values()) {
                JOrphanUtils.closeQuietly((Closeable)((Closeable)pair.getLeft()));
                JOrphanUtils.closeQuietly((Closeable)((Closeable)pair.getRight()));
            }
            mapHttpClientPerHttpClientKey.clear();
        }
    }

    public boolean interrupt() {
        HttpUriRequest request = this.currentRequest;
        if (request != null) {
            this.currentRequest = null;
            try {
                request.abort();
            }
            catch (UnsupportedOperationException e) {
                log.warn("Could not abort pending request", (Throwable)e);
            }
        }
        return request != null;
    }

    static {
        EMPTY_FILE_BODIES = new ViewableFileBody[0];
        log.info("HTTP request retry count = {}", (Object)RETRY_COUNT);
        if (CPS_HTTP > 0) {
            log.info("Setting up HTTP SlowProtocol, cps={}", (Object)CPS_HTTP);
            CONNECTION_SOCKET_FACTORY = new SlowHCPlainConnectionSocketFactory(CPS_HTTP);
        } else {
            CONNECTION_SOCKET_FACTORY = PlainConnectionSocketFactory.getSocketFactory();
        }
    }

    private static class ViewableFileBody
    extends FileBody {
        private boolean hideFileData = false;

        public ViewableFileBody(File file, ContentType contentType) {
            super(file, contentType);
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.hideFileData) {
                out.write("<actual file content, not shown here>".getBytes());
            } else {
                super.writeTo(out);
            }
        }
    }

    private static final class HttpClientKey {
        private final String target;
        private final boolean hasProxy;
        private final String proxyHost;
        private final int proxyPort;
        private final String proxyUser;
        private final String proxyPass;
        private final int hashCode;

        public HttpClientKey(URL url, boolean hasProxy, String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
            this.target = url.getProtocol() + "://" + url.getAuthority();
            this.hasProxy = hasProxy;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUser = proxyUser;
            this.proxyPass = proxyPass;
            this.hashCode = this.getHash();
        }

        private int getHash() {
            int hash = 17;
            hash = hash * 31 + (this.hasProxy ? 1 : 0);
            if (this.hasProxy) {
                hash = hash * 31 + this.getHash(this.proxyHost);
                hash = hash * 31 + this.proxyPort;
                hash = hash * 31 + this.getHash(this.proxyUser);
                hash = hash * 31 + this.getHash(this.proxyPass);
            }
            hash = hash * 31 + this.target.hashCode();
            return hash;
        }

        private int getHash(String s) {
            return s == null ? 0 : s.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HttpClientKey)) {
                return false;
            }
            HttpClientKey other = (HttpClientKey)obj;
            if (this.hasProxy) {
                return this.hasProxy == other.hasProxy && this.proxyPort == other.proxyPort && this.proxyHost.equals(other.proxyHost) && this.proxyUser.equals(other.proxyUser) && this.proxyPass.equals(other.proxyPass) && this.target.equals(other.target);
            }
            return this.hasProxy == other.hasProxy && this.target.equals(other.target);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.target);
            if (this.hasProxy) {
                sb.append(" via ");
                sb.append(this.proxyUser);
                sb.append('@');
                sb.append(this.proxyHost);
                sb.append(':');
                sb.append(this.proxyPort);
            }
            return sb.toString();
        }
    }

    public static final class HttpDelete
    extends HttpEntityEnclosingRequestBase {
        public HttpDelete(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return "DELETE";
        }
    }

    public static final class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        public HttpGetWithEntity(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return "GET";
        }
    }

    private static final class JMeterDefaultHttpClientConnectionOperator
    extends DefaultHttpClientConnectionOperator {
        public JMeterDefaultHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
            super(socketFactoryRegistry, schemePortResolver, dnsResolver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, int connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
            try {
                super.connect(conn, host, localAddress, connectTimeout, socketConfig, context);
            }
            finally {
                SampleResult sample = (SampleResult)context.getAttribute(HTTPHC4Impl.CONTEXT_ATTRIBUTE_SAMPLER_RESULT);
                if (sample != null) {
                    sample.connectEnd();
                }
            }
        }
    }

    private static final class PreemptiveAuthRequestInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveAuthRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            HttpClientContext localContext = HttpClientContext.adapt((HttpContext)context);
            AuthManager authManager = (AuthManager)localContext.getAttribute(HTTPHC4Impl.CONTEXT_ATTRIBUTE_AUTH_MANAGER);
            if (authManager == null) {
                Credentials credentials = null;
                HttpClientKey key = (HttpClientKey)localContext.getAttribute(HTTPHC4Impl.CONTEXT_ATTRIBUTE_CLIENT_KEY);
                AuthScope authScope = null;
                CredentialsProvider credentialsProvider = localContext.getCredentialsProvider();
                if (key.hasProxy && !StringUtils.isEmpty((CharSequence)key.proxyUser)) {
                    authScope = new AuthScope(key.proxyHost, key.proxyPort);
                    credentials = credentialsProvider.getCredentials(authScope);
                }
                credentialsProvider.clear();
                if (credentials != null) {
                    credentialsProvider.setCredentials(authScope, credentials);
                }
                return;
            }
            URI requestURI = null;
            if (request instanceof HttpUriRequest) {
                requestURI = ((HttpUriRequest)request).getURI();
            } else {
                try {
                    requestURI = new URI(request.getRequestLine().getUri());
                }
                catch (URISyntaxException key) {
                    // empty catch block
                }
            }
            if (requestURI != null) {
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                URL url = requestURI.isAbsolute() ? requestURI.toURL() : new URL(targetHost.getSchemeName(), targetHost.getHostName(), targetHost.getPort(), requestURI.getPath());
                Authorization authorization = authManager.getAuthForURL(url);
                CredentialsProvider credentialsProvider = localContext.getCredentialsProvider();
                if (authorization != null) {
                    AuthScope authScope;
                    Credentials creds;
                    AuthCache authCache = localContext.getAuthCache();
                    if (authCache == null) {
                        authCache = new BasicAuthCache();
                        localContext.setAuthCache(authCache);
                    }
                    authManager.setupCredentials(authorization, url, localContext, credentialsProvider, HTTPHCAbstractImpl.LOCALHOST);
                    AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                    if (authState.getAuthScheme() == null && (creds = credentialsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort(), authorization.getRealm(), targetHost.getSchemeName()))) != null) {
                        this.fillAuthCache(targetHost, authorization, authCache, authScope);
                    }
                } else {
                    credentialsProvider.clear();
                }
            }
        }

        private void fillAuthCache(HttpHost targetHost, Authorization authorization, AuthCache authCache, AuthScope authScope) {
            if (authorization.getMechanism() == AuthManager.Mechanism.BASIC_DIGEST || authorization.getMechanism() == AuthManager.Mechanism.BASIC) {
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicAuth);
            } else if (authorization.getMechanism() == AuthManager.Mechanism.DIGEST) {
                JMeterVariables vars = JMeterContextService.getContext().getVariables();
                DigestParameters digestParameters = (DigestParameters)vars.getObject(HTTPHC4Impl.DIGEST_PARAMETERS);
                if (digestParameters != null) {
                    DigestScheme digestAuth = (DigestScheme)authCache.get(targetHost);
                    if (digestAuth == null) {
                        digestAuth = new DigestScheme();
                    }
                    digestAuth.overrideParamter("realm", authScope.getRealm());
                    digestAuth.overrideParamter("algorithm", digestParameters.getAlgorithm());
                    digestAuth.overrideParamter("charset", digestParameters.getCharset());
                    digestAuth.overrideParamter("nonce", digestParameters.getNonce());
                    digestAuth.overrideParamter("opaque", digestParameters.getOpaque());
                    digestAuth.overrideParamter("qop", digestParameters.getQop());
                    authCache.put(targetHost, (AuthScheme)digestAuth);
                }
            } else if (authorization.getMechanism() == AuthManager.Mechanism.KERBEROS) {
                KerberosScheme kerberosScheme = new KerberosScheme();
                authCache.put(targetHost, (AuthScheme)kerberosScheme);
            }
        }
    }
}

