/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieHandler;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.ClassTools;
import org.apache.jorphan.util.JMeterException;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieManager
extends ConfigTestElement
implements TestStateListener,
TestIterationListener,
Serializable {
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggerFactory.getLogger(CookieManager.class);
    private static final String CLEAR = "CookieManager.clearEachIteration";
    private static final String COOKIES = "CookieManager.cookies";
    private static final String POLICY = "CookieManager.policy";
    private static final String IMPLEMENTATION = "CookieManager.implementation";
    private static final String TAB = "\t";
    private static final boolean DELETE_NULL_COOKIES = JMeterUtils.getPropDefault((String)"CookieManager.delete_null_cookies", (boolean)true);
    static final boolean ALLOW_VARIABLE_COOKIES = JMeterUtils.getPropDefault((String)"CookieManager.allow_variable_cookies", (boolean)true);
    private static final String COOKIE_NAME_PREFIX = JMeterUtils.getPropDefault((String)"CookieManager.name.prefix", (String)"COOKIE_").trim();
    private static final boolean SAVE_COOKIES = JMeterUtils.getPropDefault((String)"CookieManager.save.cookies", (boolean)false);
    private static final boolean CHECK_COOKIES = JMeterUtils.getPropDefault((String)"CookieManager.check.cookies", (boolean)true);
    private transient CookieHandler cookieHandler;
    private transient CollectionProperty initialCookies;
    @Deprecated
    public static final String DEFAULT_POLICY = "compatibility";
    @Deprecated
    public static final String DEFAULT_IMPLEMENTATION = "org.apache.jmeter.protocol.http.control.HC3CookieHandler";

    public CookieManager() {
        this.clearCookies();
    }

    public Object clone() {
        CookieManager clone = (CookieManager)super.clone();
        clone.initialCookies = this.initialCookies;
        clone.cookieHandler = this.cookieHandler;
        return clone;
    }

    public String getPolicy() {
        return this.getPropertyAsString(POLICY, DEFAULT_POLICY);
    }

    public void setCookiePolicy(String policy) {
        this.setProperty(POLICY, policy, DEFAULT_POLICY);
    }

    public CollectionProperty getCookies() {
        return (CollectionProperty)this.getProperty(COOKIES);
    }

    public int getCookieCount() {
        return this.getCookies().size();
    }

    public boolean getClearEachIteration() {
        return this.getPropertyAsBoolean(CLEAR);
    }

    public void setClearEachIteration(boolean clear) {
        this.setProperty((JMeterProperty)new BooleanProperty(CLEAR, clear));
    }

    public String getImplementation() {
        return this.getPropertyAsString(IMPLEMENTATION, DEFAULT_IMPLEMENTATION);
    }

    public void setImplementation(String implementation) {
        this.setProperty(IMPLEMENTATION, implementation, DEFAULT_IMPLEMENTATION);
    }

    public void save(String authFile) throws IOException {
        File file = new File(authFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + authFile);
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            writer.println("# JMeter generated Cookie file");
            long now = System.currentTimeMillis();
            for (JMeterProperty jMeterProperty : this.getCookies()) {
                Cookie cook = (Cookie)jMeterProperty.getObjectValue();
                long expiresMillis = cook.getExpiresMillis();
                if (expiresMillis != 0L && expiresMillis <= now) continue;
                writer.println(this.cookieToString(cook));
            }
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFile(String cookieFile) throws IOException {
        File file = new File(cookieFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + cookieFile);
        }
        BufferedReader reader = null;
        if (!file.canRead()) {
            throw new IOException("The file you specified cannot be read.");
        }
        reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            CollectionProperty cookies = this.getCookies();
            while ((line = reader.readLine()) != null) {
                try {
                    if (line.startsWith("#") || JOrphanUtils.isBlank((String)line)) continue;
                    String[] st = JOrphanUtils.split((String)line, (String)TAB, (boolean)false);
                    boolean _domain = false;
                    int _path = 2;
                    int _secure = 3;
                    int _expires = 4;
                    int _name = 5;
                    int _value = 6;
                    int _fields = 7;
                    if (st.length != 7) {
                        throw new IOException("Expected 7 fields, found " + st.length + " in " + line);
                    }
                    if (st[2].length() == 0) {
                        st[2] = "/";
                    }
                    boolean secure = Boolean.parseBoolean(st[3]);
                    long expires = Long.parseLong(st[4]);
                    if (expires == Long.MAX_VALUE) {
                        expires = 0L;
                    }
                    Cookie cookie = new Cookie(st[5], st[6], st[0], st[2], secure, expires);
                    cookies.addItem((Object)cookie);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Error parsing cookie line\n\t'" + line + "'\n\t" + e);
                    return;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    private String cookieToString(Cookie c) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(c.getDomain());
        sb.append(TAB).append("TRUE");
        sb.append(TAB).append(c.getPath());
        sb.append(TAB).append(JOrphanUtils.booleanToSTRING((boolean)c.getSecure()));
        sb.append(TAB).append(c.getExpires());
        sb.append(TAB).append(c.getName());
        sb.append(TAB).append(c.getValue());
        return sb.toString();
    }

    public void recoverRunningVersion() {
    }

    public void setRunningVersion(boolean running) {
    }

    public void add(Cookie c) {
        String cv = c.getValue();
        String cn = c.getName();
        this.removeMatchingCookies(c);
        if (DELETE_NULL_COOKIES && (null == cv || cv.length() == 0)) {
            if (log.isDebugEnabled()) {
                log.debug("Dropping cookie with null value " + c.toString());
            }
        } else {
            JMeterContext context;
            if (log.isDebugEnabled()) {
                log.debug("Add cookie to store " + c.toString());
            }
            this.getCookies().addItem((Object)c);
            if (SAVE_COOKIES && (context = this.getThreadContext()).isSamplingStarted()) {
                context.getVariables().put(COOKIE_NAME_PREFIX + cn, cv);
            }
        }
    }

    public void clear() {
        super.clear();
        this.clearCookies();
    }

    private void clearCookies() {
        log.debug("Clear all cookies from store");
        this.setProperty((JMeterProperty)new CollectionProperty(COOKIES, new ArrayList()));
    }

    public void remove(int index) {
        this.getCookies().remove(index);
    }

    public Cookie get(int i) {
        return (Cookie)this.getCookies().get(i).getObjectValue();
    }

    public String getCookieHeaderForURL(URL url) {
        return this.cookieHandler.getCookieHeaderForURL(this.getCookies(), url, ALLOW_VARIABLE_COOKIES);
    }

    public void addCookieFromHeader(String cookieHeader, URL url) {
        this.cookieHandler.addCookieFromHeader(this, CHECK_COOKIES, cookieHeader, url);
    }

    private boolean match(Cookie a, Cookie b) {
        return a.getName().equals(b.getName()) && a.getPath().equals(b.getPath()) && a.getDomain().equals(b.getDomain());
    }

    void removeMatchingCookies(Cookie newCookie) {
        PropertyIterator iter = this.getCookies().iterator();
        while (iter.hasNext()) {
            Cookie cookie = (Cookie)iter.next().getObjectValue();
            if (cookie == null || !this.match(cookie, newCookie)) continue;
            if (log.isDebugEnabled()) {
                log.debug("New Cookie = " + newCookie.toString() + " removing matching Cookie " + cookie.toString());
            }
            iter.remove();
        }
    }

    public void testStarted() {
        this.initialCookies = this.getCookies();
        try {
            this.cookieHandler = (CookieHandler)ClassTools.construct((String)this.getImplementation(), (String)this.getPolicy());
        }
        catch (JMeterException e) {
            log.error("Unable to load or invoke class: " + this.getImplementation(), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Policy: " + this.getPolicy() + " Clear: " + this.getClearEachIteration());
        }
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded(String host) {
    }

    public void testIterationStart(LoopIterationEvent event) {
        if (this.getClearEachIteration()) {
            log.debug("Initialise cookies from pre-defined list");
            this.setProperty((JMeterProperty)this.initialCookies.clone());
        }
    }

    CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    static {
        log.info("Settings: Delete null: " + DELETE_NULL_COOKIES + " Check: " + CHECK_COOKIES + " Allow variable: " + ALLOW_VARIABLE_COOKIES + " Save: " + SAVE_COOKIES + " Prefix: " + COOKIE_NAME_PREFIX);
    }
}

