/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.TextBoxDialoger;
import org.apache.jmeter.protocol.http.config.MultipartUrlConfig;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RequestView;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jmeter.visualizers.SearchTextExtension;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.log.Logger;

public class RequestViewHTTP
implements RequestView {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String KEY_LABEL = "view_results_table_request_tab_http";
    private static final String CHARSET_DECODE = StandardCharsets.ISO_8859_1.name();
    private static final String PARAM_CONCATENATE = "&";
    private JPanel paneParsed;
    private ObjectTableModel requestModel = new ObjectTableModel(COLUMNS_REQUEST, SamplerResultTab.RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private ObjectTableModel paramsModel = new ObjectTableModel(COLUMNS_PARAMS, SamplerResultTab.RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private ObjectTableModel headersModel = new ObjectTableModel(COLUMNS_HEADERS, SamplerResultTab.RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private static final String[] COLUMNS_REQUEST = new String[]{" ", " "};
    private static final String[] COLUMNS_PARAMS = new String[]{"view_results_table_request_params_key", "view_results_table_request_params_value"};
    private static final String[] COLUMNS_HEADERS = new String[]{"view_results_table_request_headers_key", "view_results_table_request_headers_value"};
    private JTable tableRequest = null;
    private JTable tableParams = null;
    private JTable tableHeaders = null;
    private static final TableCellRenderer[] RENDERERS_REQUEST = new TableCellRenderer[]{null, null};
    private static final TableCellRenderer[] RENDERERS_PARAMS = new TableCellRenderer[]{null, null};
    private static final TableCellRenderer[] RENDERERS_HEADERS = new TableCellRenderer[]{null, null};
    private SearchTextExtension searchTextExtension;

    public void init() {
        this.paneParsed = new JPanel(new BorderLayout(0, 5));
        this.paneParsed.add(this.createRequestPane());
        this.searchTextExtension = new SearchTextExtension();
        this.searchTextExtension.init(this.paneParsed);
        JPanel searchPanel = this.searchTextExtension.createSearchTextExtensionPane();
        searchPanel.setBorder(null);
        this.searchTextExtension.setSearchProvider((SearchTextExtension.ISearchTextExtensionProvider)new RequestViewHttpSearchProvider());
        searchPanel.setVisible(true);
        this.paneParsed.add((Component)searchPanel, "Last");
    }

    public void clearData() {
        this.requestModel.clearData();
        this.paramsModel.clearData();
        this.headersModel.clearData();
    }

    public void setSamplerResult(Object objectResult) {
        this.searchTextExtension.resetTextToFind();
        if (objectResult instanceof HTTPSampleResult) {
            String cookie;
            HTTPSampleResult sampleResult = (HTTPSampleResult)((Object)objectResult);
            this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_method"), (Object)sampleResult.getHTTPMethod()));
            LinkedHashMap lhm = JMeterUtils.parseHeaders((String)sampleResult.getRequestHeaders());
            for (Map.Entry entry : lhm.entrySet()) {
                this.headersModel.addRow((Object)new SamplerResultTab.RowResult((String)entry.getKey(), entry.getValue()));
            }
            URL hUrl = sampleResult.getURL();
            if (hUrl != null) {
                this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_protocol"), (Object)hUrl.getProtocol()));
                this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_host"), (Object)hUrl.getHost()));
                int port = hUrl.getPort() == -1 ? hUrl.getDefaultPort() : hUrl.getPort();
                this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_port"), (Object)port));
                this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_path"), (Object)hUrl.getPath()));
                String queryGet = hUrl.getQuery() == null ? "" : hUrl.getQuery();
                boolean isMultipart = this.isMultipart(lhm);
                String queryPost = sampleResult.getQueryString();
                if (!isMultipart && StringUtils.isNotBlank((CharSequence)queryPost)) {
                    if (queryGet.length() > 0) {
                        queryGet = queryGet + PARAM_CONCATENATE;
                    }
                    queryGet = queryGet + queryPost;
                }
                if (StringUtils.isNotBlank((CharSequence)queryGet)) {
                    Set<Map.Entry<String, String[]>> keys = RequestViewHTTP.getQueryMap(queryGet).entrySet();
                    for (Map.Entry<String, String[]> entry : keys) {
                        for (String value : entry.getValue()) {
                            this.paramsModel.addRow((Object)new SamplerResultTab.RowResult(entry.getKey(), (Object)value));
                        }
                    }
                }
                if (isMultipart && StringUtils.isNotBlank((CharSequence)queryPost)) {
                    String contentType = (String)lhm.get("Content-Type");
                    String boundaryString = this.extractBoundary(contentType);
                    MultipartUrlConfig urlconfig = new MultipartUrlConfig(boundaryString);
                    urlconfig.parseArguments(queryPost);
                    for (JMeterProperty prop : urlconfig.getArguments()) {
                        Argument arg = (Argument)prop.getObjectValue();
                        this.paramsModel.addRow((Object)new SamplerResultTab.RowResult(arg.getName(), (Object)arg.getValue()));
                    }
                }
            }
            if ((cookie = sampleResult.getCookies()) != null && cookie.length() > 0) {
                this.headersModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getParsedLabel((String)"view_results_table_request_http_cookie"), (Object)sampleResult.getCookies()));
            }
        } else {
            this.requestModel.addRow((Object)new SamplerResultTab.RowResult("", (Object)JMeterUtils.getResString((String)"view_results_table_request_http_nohttp")));
        }
    }

    private String extractBoundary(String contentType) {
        String boundaryString = contentType.substring(contentType.toLowerCase(Locale.ENGLISH).indexOf("boundary=") + "boundary=".length());
        String[] split = boundaryString.split(";");
        if (split.length > 1) {
            boundaryString = split[0];
        }
        return boundaryString;
    }

    private boolean isMultipart(LinkedHashMap<String, String> headers) {
        String contentType = headers.get("Content-Type");
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public static Map<String, String[]> getQueryMap(String query) {
        String[] params;
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String param : params = query.split(PARAM_CONCATENATE)) {
            String[] known;
            String[] paramSplit = param.split("=");
            String name = RequestViewHTTP.decodeQuery(paramSplit[0]);
            if (name.trim().startsWith("<?")) {
                map.put(" ", new String[]{query});
                return map;
            }
            if (param.startsWith("=") && paramSplit.length == 1 || paramSplit.length > 2) {
                map.put(" ", new String[]{query});
                return map;
            }
            String value = "";
            if (paramSplit.length > 1) {
                value = RequestViewHTTP.decodeQuery(paramSplit[1]);
            }
            if ((known = (String[])map.get(name)) == null) {
                known = new String[]{value};
            } else {
                String[] tmp = new String[known.length + 1];
                tmp[tmp.length - 1] = value;
                System.arraycopy(known, 0, tmp, 0, known.length);
                known = tmp;
            }
            map.put(name, known);
        }
        return map;
    }

    public static String decodeQuery(String query) {
        if (query != null && query.length() > 0) {
            try {
                return URLDecoder.decode(query, CHARSET_DECODE);
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                log.warn("Error decoding query, maybe your request parameters should be encoded:" + query, (Throwable)e);
                return query;
            }
        }
        return "";
    }

    public JPanel getPanel() {
        return this.paneParsed;
    }

    private Component createRequestPane() {
        this.tableRequest = new JTable((TableModel)this.requestModel);
        JMeterUtils.applyHiDPI((JTable)this.tableRequest);
        this.tableRequest.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableRequest.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableRequest));
        this.setFirstColumnPreferredAndMaxWidth(this.tableRequest);
        RendererUtils.applyRenderers((JTable)this.tableRequest, (TableCellRenderer[])RENDERERS_REQUEST);
        this.tableParams = new JTable((TableModel)this.paramsModel);
        JMeterUtils.applyHiDPI((JTable)this.tableParams);
        this.tableParams.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableParams.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableParams));
        TableColumn column = this.tableParams.getColumnModel().getColumn(0);
        column.setPreferredWidth(160);
        this.tableParams.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        RendererUtils.applyRenderers((JTable)this.tableParams, (TableCellRenderer[])RENDERERS_PARAMS);
        this.tableHeaders = new JTable((TableModel)this.headersModel);
        JMeterUtils.applyHiDPI((JTable)this.tableHeaders);
        this.tableHeaders.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableHeaders.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableHeaders));
        this.setFirstColumnPreferredAndMaxWidth(this.tableHeaders);
        this.tableHeaders.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        RendererUtils.applyRenderers((JTable)this.tableHeaders, (TableCellRenderer[])RENDERERS_HEADERS);
        JSplitPane topSplit = new JSplitPane(0, GuiUtils.makeScrollPane((Component)this.tableParams), GuiUtils.makeScrollPane((Component)this.tableHeaders));
        topSplit.setOneTouchExpandable(true);
        topSplit.setResizeWeight(0.5);
        topSplit.setBorder(null);
        JSplitPane paneParsed = new JSplitPane(0, GuiUtils.makeScrollPane((Component)this.tableRequest), topSplit);
        paneParsed.setOneTouchExpandable(true);
        paneParsed.setResizeWeight(0.25);
        paneParsed.setBorder(null);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(paneParsed);
        return panel;
    }

    private void setFirstColumnPreferredAndMaxWidth(JTable table) {
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setMaxWidth(300);
        column.setPreferredWidth(160);
    }

    public String getLabel() {
        return JMeterUtils.getResString((String)KEY_LABEL);
    }

    private class RequestViewHttpSearchProvider
    implements SearchTextExtension.ISearchTextExtensionProvider {
        private int lastPosition = -1;

        private RequestViewHttpSearchProvider() {
        }

        public void resetTextToFind() {
            this.lastPosition = -1;
            if (RequestViewHTTP.this.tableParams != null) {
                RequestViewHTTP.this.tableParams.clearSelection();
            }
        }

        public boolean executeAndShowTextFind(Pattern pattern) {
            boolean found = false;
            if (RequestViewHTTP.this.tableParams != null) {
                RequestViewHTTP.this.tableParams.clearSelection();
                block0: for (int i = this.lastPosition + 1; i < RequestViewHTTP.this.tableParams.getRowCount(); ++i) {
                    for (int j = 0; j < COLUMNS_PARAMS.length; ++j) {
                        Matcher matcher;
                        Object o = RequestViewHTTP.this.tableParams.getModel().getValueAt(i, j);
                        if (!(o instanceof String) || (matcher = pattern.matcher((String)o)) == null || !matcher.find()) continue;
                        found = true;
                        RequestViewHTTP.this.tableParams.setRowSelectionInterval(i, i);
                        RequestViewHTTP.this.tableParams.scrollRectToVisible(RequestViewHTTP.this.tableParams.getCellRect(i, 0, true));
                        this.lastPosition = i;
                        break block0;
                    }
                }
                if (!found) {
                    this.resetTextToFind();
                }
            }
            return found;
        }
    }
}

