/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.util.JMeterUtils;

public class HTTPFileImpl
extends HTTPAbstractImpl {
    private static final int MAX_BYTES_TO_STORE_PER_REQUEST = JMeterUtils.getPropDefault((String)"httpsampler.max_bytes_to_store_per_request", (int)0xA00000);

    protected HTTPFileImpl(HTTPSamplerBase base) {
        super(base);
    }

    public boolean interrupt() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        HTTPSampleResult res = new HTTPSampleResult();
        res.setHTTPMethod("GET");
        res.setURL(url);
        res.setSampleLabel(url.toString());
        InputStream is = null;
        res.sampleStart();
        int bufferSize = 4096;
        try {
            HTTPSampleResult hTTPSampleResult;
            Object object;
            ByteArrayOutputStream bos;
            block24: {
                block25: {
                    bos = new ByteArrayOutputStream(bufferSize);
                    object = null;
                    URLConnection conn = url.openConnection();
                    is = conn.getInputStream();
                    byte[] readBuffer = new byte[bufferSize];
                    int bytesReadInBuffer = 0;
                    long totalBytes = 0L;
                    boolean storeInBOS = true;
                    while ((bytesReadInBuffer = is.read(readBuffer)) > -1) {
                        if (storeInBOS) {
                            if (totalBytes + (long)bytesReadInBuffer <= (long)MAX_BYTES_TO_STORE_PER_REQUEST) {
                                bos.write(readBuffer, 0, bytesReadInBuffer);
                            } else {
                                bos.write(readBuffer, 0, (int)((long)MAX_BYTES_TO_STORE_PER_REQUEST - totalBytes));
                                storeInBOS = false;
                            }
                        }
                        totalBytes += (long)bytesReadInBuffer;
                    }
                    byte[] responseData = bos.toByteArray();
                    res.sampleEnd();
                    res.setResponseData(responseData);
                    res.setBodySize(totalBytes);
                    res.setResponseCodeOK();
                    res.setResponseMessageOK();
                    res.setSuccessful(true);
                    StringBuilder ctb = new StringBuilder("text/html");
                    String contentEncoding = this.getContentEncoding();
                    if (contentEncoding.length() > 0) {
                        ctb.append("; charset=");
                        ctb.append(contentEncoding);
                    }
                    String ct = ctb.toString();
                    res.setContentType(ct);
                    res.setEncodingAndType(ct);
                    hTTPSampleResult = res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
                    if (bos == null) break block24;
                    if (object == null) break block25;
                    try {
                        bos.close();
                    }
                    catch (Throwable x2) {
                        ((Throwable)object).addSuppressed(x2);
                    }
                    break block24;
                }
                bos.close();
            }
            IOUtils.closeQuietly((InputStream)is);
            return hTTPSampleResult;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (bos != null) {
                            if (object != null) {
                                try {
                                    bos.close();
                                }
                                catch (Throwable x2) {
                                    ((Throwable)object).addSuppressed(x2);
                                }
                            } else {
                                bos.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (FileNotFoundException e) {
                    object = this.errorResult(e, res);
                    IOUtils.closeQuietly(is);
                    return object;
                }
                catch (IOException e) {
                    object = this.errorResult(e, res);
                    return object;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }
}

