/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config;

import java.io.Serializable;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArgs;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class MultipartUrlConfig
implements Serializable {
    private static final long serialVersionUID = 240L;
    private final String boundary;
    private final Arguments args = new Arguments();
    private final HTTPFileArgs files = new HTTPFileArgs();

    @Deprecated
    public MultipartUrlConfig() {
        this(null);
    }

    public MultipartUrlConfig(String boundary) {
        this.boundary = boundary;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public Arguments getArguments() {
        return this.args;
    }

    public void addArgument(String name, String value) {
        Arguments myArgs = this.getArguments();
        myArgs.addArgument((Argument)new HTTPArgument(name, value));
    }

    public void addArgument(String name, String value, String metadata) {
        Arguments myArgs = this.getArguments();
        myArgs.addArgument((Argument)new HTTPArgument(name, value, metadata));
    }

    public HTTPFileArgs getHTTPFileArgs() {
        return this.files;
    }

    private void addNonEncodedArgument(String name, String value) {
        Arguments myArgs = this.getArguments();
        HTTPArgument arg = new HTTPArgument(name, value, false);
        arg.setAlwaysEncoded(false);
        myArgs.addArgument((Argument)arg);
    }

    public void parseArguments(String queryString) {
        String[] parts;
        for (String part : parts = JOrphanUtils.split((String)queryString, (String)("--" + this.getBoundary()))) {
            String contentDisposition = this.getHeaderValue("Content-disposition", part);
            String contentType = this.getHeaderValue("Content-type", part);
            if (contentDisposition == null || !contentDisposition.contains("form-data")) continue;
            String namePrefix = "name=\"";
            int index = contentDisposition.indexOf("name=\"") + "name=\"".length();
            String name = contentDisposition.substring(index, contentDisposition.indexOf(34, index));
            String filenamePrefix = "filename=\"";
            if (contentDisposition.contains("filename=\"")) {
                index = contentDisposition.indexOf("filename=\"") + "filename=\"".length();
                String path = contentDisposition.substring(index, contentDisposition.indexOf(34, index));
                if (path == null || path.length() <= 0) continue;
                this.files.addHTTPFileArg(path, name, contentType);
                continue;
            }
            String CRLF = "\r\n";
            String CRLFCRLF = "\r\n\r\n";
            String LF = "\n";
            String LFLF = "\n\n";
            int indexEmptyCrLfCrLfLinePos = part.indexOf("\r\n\r\n");
            int indexEmptyLfLfLinePos = part.indexOf("\n\n");
            String value = null;
            if (indexEmptyCrLfCrLfLinePos > -1) {
                value = part.substring(indexEmptyCrLfCrLfLinePos + "\r\n\r\n".length(), part.lastIndexOf("\r\n"));
            } else if (indexEmptyLfLfLinePos > -1) {
                value = part.substring(indexEmptyLfLfLinePos + "\n\n".length(), part.lastIndexOf("\n"));
            }
            this.addNonEncodedArgument(name, value);
        }
    }

    private String getHeaderValue(String headerName, String multiPart) {
        Pattern pattern;
        String regularExpression = headerName + "\\s*:\\s*(.*)$";
        Perl5Matcher localMatcher = JMeterUtils.getMatcher();
        if (localMatcher.contains(multiPart, pattern = JMeterUtils.getPattern((String)regularExpression, (int)32777))) {
            return localMatcher.getMatch().group(1).trim();
        }
        return null;
    }
}

