/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.protocol.http.sampler.SoapSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class SoapSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private JLabeledTextField urlField;
    private JLabeledTextField soapAction;
    private JCheckBox sendSoapAction;
    private JCheckBox useKeepAlive;
    private JLabeledTextArea soapXml;
    private FilePanel soapXmlFile = new FilePanel();

    public SoapSamplerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "soap_sampler_title";
    }

    public TestElement createTestElement() {
        SoapSampler sampler = new SoapSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement s) {
        super.configureTestElement(s);
        if (s instanceof SoapSampler) {
            SoapSampler sampler = (SoapSampler)s;
            sampler.setURLData(this.urlField.getText());
            sampler.setXmlData(this.soapXml.getText());
            sampler.setXmlFile(this.soapXmlFile.getFilename());
            sampler.setSOAPAction(this.soapAction.getText());
            sampler.setSendSOAPAction(this.sendSoapAction.isSelected());
            sampler.setUseKeepAlive(this.useKeepAlive.isSelected());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.urlField.setText("");
        this.soapAction.setText("");
        this.soapXml.setText("");
        this.sendSoapAction.setSelected(true);
        this.soapXmlFile.setFilename("");
        this.useKeepAlive.setSelected(false);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.urlField = new JLabeledTextField(JMeterUtils.getResString((String)"url"), 10);
        this.soapXml = new JLabeledTextArea(JMeterUtils.getResString((String)"soap_data_title"));
        this.soapAction = new JLabeledTextField("", 10);
        this.sendSoapAction = new JCheckBox(JMeterUtils.getResString((String)"soap_send_action"), true);
        this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel soapActionPanel = new JPanel();
        soapActionPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        soapActionPanel.add((Component)this.urlField, c);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        soapActionPanel.add((Component)this.sendSoapAction, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        soapActionPanel.add((Component)this.soapAction, c);
        c.fill = 2;
        c.gridwidth = 2;
        c.gridy = 2;
        c.gridx = 0;
        soapActionPanel.add((Component)this.useKeepAlive, c);
        mainPanel.add((Component)soapActionPanel, "North");
        mainPanel.add((Component)this.soapXml, "Center");
        mainPanel.add((Component)this.soapXmlFile, "South");
        this.sendSoapAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoapSamplerGui.this.soapAction.setEnabled(SoapSamplerGui.this.sendSoapAction.isSelected());
            }
        });
        this.add(mainPanel, "Center");
    }

    public void configure(TestElement el) {
        super.configure(el);
        SoapSampler sampler = (SoapSampler)el;
        this.urlField.setText(sampler.getURLData());
        this.sendSoapAction.setSelected(sampler.getSendSOAPAction());
        this.soapAction.setText(sampler.getSOAPAction());
        this.soapXml.setText(sampler.getXmlData());
        this.soapXmlFile.setFilename(sampler.getXmlFile());
        this.useKeepAlive.setSelected(sampler.getUseKeepAlive());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

