/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.CharUtils;
import org.apache.jmeter.protocol.http.config.MultipartUrlConfig;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.gui.HeaderPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HttpRequestHdr {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String PROXY_CONNECTION = "proxy-connection";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_LENGTH = "content-length";
    private String method = "";
    private String paramHttps = "";
    private String url = "";
    private String version = "";
    private byte[] rawPostData;
    private final Map<String, Header> headers = new HashMap<String, Header>();
    private final String httpSamplerName;
    private HeaderManager headerManager;

    public HttpRequestHdr() {
        this.httpSamplerName = "";
    }

    public HttpRequestHdr(String httpSamplerName) {
        this.httpSamplerName = httpSamplerName;
    }

    public byte[] parse(InputStream in) throws IOException {
        int x;
        boolean inHeaders = true;
        int readLength = 0;
        int dataLength = 0;
        boolean firstLine = true;
        ByteArrayOutputStream clientRequest = new ByteArrayOutputStream();
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        while ((inHeaders || readLength < dataLength) && (x = in.read()) != -1) {
            line.write(x);
            clientRequest.write(x);
            if (firstLine && !CharUtils.isAscii((char)((char)x))) {
                throw new IllegalArgumentException("Only ASCII supported in headers (perhaps SSL was used?)");
            }
            if (inHeaders && (byte)x == 10) {
                if (line.size() < 3) {
                    inHeaders = false;
                    firstLine = false;
                }
                if (firstLine) {
                    this.parseFirstLine(line.toString());
                    firstLine = false;
                } else {
                    int contentLen = this.parseLine(line.toString());
                    if (contentLen > 0) {
                        dataLength = contentLen;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Client Request Line: " + line.toString());
                }
                line.reset();
                continue;
            }
            if (inHeaders) continue;
            ++readLength;
        }
        this.rawPostData = line.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug("rawPostData in default JRE encoding: " + new String(this.rawPostData));
            log.debug("Request: " + clientRequest.toString());
        }
        return clientRequest.toByteArray();
    }

    private void parseFirstLine(String firstLine) {
        if (log.isDebugEnabled()) {
            log.debug("browser request: " + firstLine);
        }
        StringTokenizer tz = new StringTokenizer(firstLine);
        this.method = this.getToken(tz).toUpperCase(Locale.ENGLISH);
        this.url = this.getToken(tz);
        this.version = this.getToken(tz);
        if (log.isDebugEnabled()) {
            log.debug("parser input:  " + firstLine);
            log.debug("parsed method: " + this.method);
            log.debug("parsed url:    " + this.url);
            log.debug("parsed version:" + this.version);
        }
        if (this.getMethod().startsWith("CONNECT")) {
            this.paramHttps = this.url;
        }
        if (this.url.startsWith("/")) {
            this.url = "https://" + this.paramHttps + this.url;
        }
        log.debug("First Line: " + this.url);
    }

    private int parseLine(String nextLine) {
        int colon = nextLine.indexOf(58);
        if (colon <= 0) {
            return 0;
        }
        String name = nextLine.substring(0, colon).trim();
        String value = nextLine.substring(colon + 1).trim();
        this.headers.put(name.toLowerCase(Locale.ENGLISH), new Header(name, value));
        if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private HeaderManager createHeaderManager() {
        HeaderManager manager = new HeaderManager();
        for (String key : this.headers.keySet()) {
            if (key.equals(PROXY_CONNECTION) || key.equals(CONTENT_LENGTH) || key.equalsIgnoreCase("Connection")) continue;
            manager.add(this.headers.get(key));
        }
        manager.setName(JMeterUtils.getResString((String)"header_manager_title"));
        manager.setProperty("TestElement.test_class", HeaderManager.class.getName());
        manager.setProperty("TestElement.gui_class", HeaderPanel.class.getName());
        return manager;
    }

    public HeaderManager getHeaderManager() {
        if (this.headerManager == null) {
            this.headerManager = this.createHeaderManager();
        }
        return this.headerManager;
    }

    public String getContentType() {
        Header contentTypeHeader = this.headers.get(CONTENT_TYPE);
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    private boolean isMultipart(String contentType) {
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public MultipartUrlConfig getMultipartConfig(String contentType) {
        if (this.isMultipart(contentType)) {
            String boundaryString = contentType.substring(contentType.toLowerCase(Locale.ENGLISH).indexOf("boundary=") + "boundary=".length());
            return new MultipartUrlConfig(boundaryString);
        }
        return null;
    }

    public String serverName() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if (0 < (i = str.indexOf("/"))) {
            str = str.substring(0, i);
        }
        if (0 < (i = str.lastIndexOf(":"))) {
            str = str.substring(0, i);
        }
        if (str.startsWith("[") && str.endsWith("]")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public int serverPort() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if (0 < (i = str.indexOf("/"))) {
            str = str.substring(0, i);
        }
        if (0 < (i = str.lastIndexOf(":"))) {
            return Integer.parseInt(str.substring(i + 1).trim());
        }
        return 0;
    }

    public String getPath() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if ((i = str.indexOf("/")) < 0) {
            return "";
        }
        return str.substring(i);
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    private String getToken(StringTokenizer tk) {
        if (tk.hasMoreTokens()) {
            return tk.nextToken();
        }
        return "";
    }

    public String getUrlWithoutQuery(URL _url) {
        String fullUrl;
        String urlWithoutQuery = fullUrl = _url.toString();
        String query = _url.getQuery();
        if (query != null) {
            urlWithoutQuery = urlWithoutQuery.substring(0, urlWithoutQuery.length() - query.length() - 1);
        }
        return urlWithoutQuery;
    }

    public String getHttpSamplerName() {
        return this.httpSamplerName;
    }

    public byte[] getRawPostData() {
        return this.rawPostData;
    }

    public String getProtocol(HTTPSamplerBase sampler) {
        if (this.url.indexOf("//") > -1) {
            String protocol = this.url.substring(0, this.url.indexOf(":"));
            if (log.isDebugEnabled()) {
                log.debug("Proxy: setting protocol to : " + protocol);
            }
            return protocol;
        }
        if (sampler.getPort() == 443) {
            if (log.isDebugEnabled()) {
                log.debug("Proxy: setting protocol to https");
            }
            return HTTPS;
        }
        if (log.isDebugEnabled()) {
            log.debug("Proxy setting default protocol to: http");
        }
        return HTTP;
    }
}

