/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HeaderPanel
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String ADD_COMMAND = "Add";
    private static final String DELETE_COMMAND = "Delete";
    private static final String LOAD_COMMAND = "Load";
    private static final String SAVE_COMMAND = "Save";
    private InnerTableModel tableModel;
    private HeaderManager headerManager = new HeaderManager();
    private JTable headerTable;
    private JButton addButton;
    private JButton deleteButton;
    private JButton loadButton;
    private JButton saveButton;

    public HeaderPanel() {
        this.tableModel = new InnerTableModel(this.headerManager);
        this.init();
    }

    public TestElement createTestElement() {
        this.configureTestElement((TestElement)this.headerManager);
        return (TestElement)this.headerManager.clone();
    }

    public void modifyTestElement(TestElement el) {
        if (this.headerTable.isEditing()) {
            this.headerTable.getCellEditor().stopCellEditing();
        }
        el.clear();
        el.addTestElement((TestElement)this.headerManager);
        this.configureTestElement(el);
    }

    public void clearGui() {
        super.clearGui();
        this.tableModel.clearData();
        this.deleteButton.setEnabled(false);
        this.saveButton.setEnabled(false);
    }

    public void configure(TestElement el) {
        this.headerManager.clear();
        super.configure(el);
        this.headerManager.addTestElement(el);
        boolean hasRows = this.tableModel.getRowCount() > 0;
        this.deleteButton.setEnabled(hasRows);
        this.saveButton.setEnabled(hasRows);
    }

    public String getLabelResource() {
        return "header_manager_title";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.createHeaderTablePanel(), "Center");
    }

    public void actionPerformed(ActionEvent e) {
        block22: {
            String action = e.getActionCommand();
            if (action.equals(DELETE_COMMAND)) {
                if (this.tableModel.getRowCount() > 0) {
                    int rowSelected;
                    if (this.headerTable.isEditing()) {
                        TableCellEditor cellEditor = this.headerTable.getCellEditor(this.headerTable.getEditingRow(), this.headerTable.getEditingColumn());
                        cellEditor.cancelCellEditing();
                    }
                    if ((rowSelected = this.headerTable.getSelectedRow()) != -1) {
                        this.tableModel.removeRow(rowSelected);
                        this.tableModel.fireTableDataChanged();
                        if (this.tableModel.getRowCount() == 0) {
                            this.deleteButton.setEnabled(false);
                            this.saveButton.setEnabled(false);
                        } else {
                            int rowToSelect = rowSelected;
                            if (rowSelected >= this.tableModel.getRowCount()) {
                                rowToSelect = rowSelected - 1;
                            }
                            this.headerTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                        }
                    }
                }
            } else if (action.equals(ADD_COMMAND)) {
                if (this.headerTable.isEditing()) {
                    TableCellEditor cellEditor = this.headerTable.getCellEditor(this.headerTable.getEditingRow(), this.headerTable.getEditingColumn());
                    cellEditor.stopCellEditing();
                }
                this.tableModel.addNewRow();
                this.tableModel.fireTableDataChanged();
                if (!this.deleteButton.isEnabled()) {
                    this.deleteButton.setEnabled(true);
                }
                if (!this.saveButton.isEnabled()) {
                    this.saveButton.setEnabled(true);
                }
                int rowToSelect = this.tableModel.getRowCount() - 1;
                this.headerTable.setRowSelectionInterval(rowToSelect, rowToSelect);
            } else if (action.equals(LOAD_COMMAND)) {
                try {
                    JFileChooser chooser = FileDialoger.promptToOpenFile();
                    if (chooser == null) break block22;
                    this.headerManager.addFile(chooser.getSelectedFile().getAbsolutePath());
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() > 0) {
                        this.deleteButton.setEnabled(true);
                        this.saveButton.setEnabled(true);
                    }
                }
                catch (IOException ex) {
                    log.error("Could not load headers", (Throwable)ex);
                }
            } else if (action.equals(SAVE_COMMAND)) {
                try {
                    JFileChooser chooser = FileDialoger.promptToSaveFile(null);
                    if (chooser != null) {
                        this.headerManager.save(chooser.getSelectedFile().getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    log.error("Could not save headers", (Throwable)ex);
                }
            }
        }
    }

    public JPanel createHeaderTablePanel() {
        this.headerTable = new JTable(this.tableModel);
        this.headerTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.headerTable.setSelectionMode(0);
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"headers_stored")));
        panel.add((Component)new JScrollPane(this.headerTable), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.tableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, true);
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        this.loadButton = this.createButton("load", 'L', LOAD_COMMAND, true);
        this.saveButton = this.createButton("save", 'S', SAVE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        return buttonPanel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InnerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 240L;
        private HeaderManager manager;

        public InnerTableModel(HeaderManager man) {
            this.manager = man;
        }

        public void clearData() {
            this.manager.clear();
            this.fireTableDataChanged();
        }

        public void removeRow(int row) {
            this.manager.remove(row);
        }

        public void addNewRow() {
            this.manager.add();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        @Override
        public int getRowCount() {
            return this.manager.getHeaders().size();
        }

        @Override
        public int getColumnCount() {
            return this.manager.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return this.manager.getColumnName(column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            Header head = this.manager.getHeader(row);
            if (column == 0) {
                return head.getName();
            }
            if (column == 1) {
                return head.getValue();
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Header header = this.manager.getHeader(row);
            if (column == 0) {
                header.setName((String)value);
            } else if (column == 1) {
                header.setValue((String)value);
            }
        }
    }
}

