/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.ArrayUtils;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.sampler.WebServiceSampler;
import org.apache.jmeter.protocol.http.util.WSDLHelper;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class WebServiceSamplerGui
extends AbstractSamplerGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private final JLabeledTextField domain = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_domain"));
    private final JLabeledTextField protocol = new JLabeledTextField(JMeterUtils.getResString((String)"protocol"), 4);
    private final JLabeledTextField port = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_port"), 4);
    private final JLabeledTextField path = new JLabeledTextField(JMeterUtils.getResString((String)"path"));
    private final JLabeledTextField soapAction = new JLabeledTextField(JMeterUtils.getResString((String)"webservice_soap_action"));
    private JCheckBox maintainSession = new JCheckBox(JMeterUtils.getResString((String)"webservice_maintain_session"), true);
    private JTextArea soapXml;
    private final JLabeledTextField wsdlField = new JLabeledTextField(JMeterUtils.getResString((String)"wsdl_url"));
    private final JButton wsdlButton = new JButton(JMeterUtils.getResString((String)"load_wsdl"));
    private final JButton selectButton = new JButton(JMeterUtils.getResString((String)"configure_wsdl"));
    private JLabeledChoice wsdlMethods = null;
    private transient WSDLHelper HELPER = null;
    private final FilePanel soapXmlFile = new FilePanel(JMeterUtils.getResString((String)"get_xml_from_file"), ".xml");
    private final JLabeledTextField randomXmlFile = new JLabeledTextField(JMeterUtils.getResString((String)"get_xml_from_random"));
    private final JLabeledTextField connectTimeout = new JLabeledTextField(JMeterUtils.getResString((String)"webservice_timeout"), 4);
    private JCheckBox memCache = new JCheckBox(JMeterUtils.getResString((String)"memory_cache"), true);
    private JCheckBox readResponse = new JCheckBox(JMeterUtils.getResString((String)"read_soap_response"));
    private JCheckBox useProxy = new JCheckBox(JMeterUtils.getResString((String)"webservice_use_proxy"));
    private JTextField proxyHost;
    private JTextField proxyPort;
    private String readToolTip = JMeterUtils.getResString((String)"read_response_note") + " " + JMeterUtils.getResString((String)"read_response_note2") + " " + JMeterUtils.getResString((String)"read_response_note3");
    private String proxyToolTip = JMeterUtils.getResString((String)"webservice_proxy_note") + " " + JMeterUtils.getResString((String)"webservice_proxy_note2") + " " + JMeterUtils.getResString((String)"webservice_proxy_note3");

    public WebServiceSamplerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "webservice_sampler_title";
    }

    public TestElement createTestElement() {
        WebServiceSampler sampler = new WebServiceSampler();
        this.configureTestElement((TestElement)sampler);
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement s) {
        WebServiceSampler sampler = (WebServiceSampler)s;
        this.configureTestElement((TestElement)sampler);
        sampler.setDomain(this.domain.getText());
        sampler.setProperty("HTTPSampler.port", this.port.getText());
        sampler.setProtocol(this.protocol.getText());
        sampler.setPath(this.path.getText());
        sampler.setWsdlURL(this.wsdlField.getText());
        sampler.setMethod("POST");
        sampler.setSoapAction(this.soapAction.getText());
        sampler.setMaintainSession(this.maintainSession.isSelected());
        sampler.setXmlData(this.soapXml.getText());
        sampler.setXmlFile(this.soapXmlFile.getFilename());
        sampler.setXmlPathLoc(this.randomXmlFile.getText());
        sampler.setTimeout(this.connectTimeout.getText());
        sampler.setMemoryCache(this.memCache.isSelected());
        sampler.setReadResponse(this.readResponse.isSelected());
        sampler.setUseProxy(this.useProxy.isSelected());
        sampler.setProxyHost(this.proxyHost.getText());
        sampler.setProxyPort(this.proxyPort.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.wsdlMethods.setValues(new String[0]);
        this.domain.setText("");
        this.protocol.setText("");
        this.port.setText("");
        this.path.setText("");
        this.soapAction.setText("");
        this.maintainSession.setSelected(true);
        this.soapXml.setText("");
        this.wsdlField.setText("");
        this.randomXmlFile.setText("");
        this.connectTimeout.setText("");
        this.proxyHost.setText("");
        this.proxyPort.setText("");
        this.memCache.setSelected(true);
        this.readResponse.setSelected(false);
        this.useProxy.setSelected(false);
        this.soapXmlFile.setFilename("");
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)this.createTopPanel(), "North");
        mainPanel.add((Component)this.createMessagePanel(), "Center");
        mainPanel.add((Component)this.createBottomPanel(), "South");
        this.add(mainPanel);
    }

    private final JPanel createTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        JPanel wsdlHelper = new JPanel();
        wsdlHelper.setLayout(new BoxLayout(wsdlHelper, 1));
        wsdlHelper.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"webservice_configuration_wizard")));
        JPanel wsdlEntry = new JPanel();
        wsdlEntry.setLayout(new BoxLayout(wsdlEntry, 0));
        EmptyBorder margin = new EmptyBorder(0, 5, 0, 5);
        wsdlEntry.setBorder(margin);
        wsdlHelper.add(wsdlEntry);
        wsdlEntry.add((Component)this.wsdlField);
        wsdlEntry.add(this.wsdlButton);
        this.wsdlButton.addActionListener(this);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new FlowLayout(0));
        JLabel selectLabel = new JLabel(JMeterUtils.getResString((String)"webservice_methods"));
        this.wsdlMethods = new JLabeledChoice();
        wsdlHelper.add(listPanel);
        listPanel.add(selectLabel);
        listPanel.add((Component)this.wsdlMethods);
        listPanel.add(this.selectButton);
        this.selectButton.addActionListener(this);
        topPanel.add(wsdlHelper);
        JPanel urlPane = new JPanel();
        urlPane.setLayout(new FlowLayout(0, 0, 0));
        urlPane.add((Component)this.protocol);
        urlPane.add(Box.createRigidArea(new Dimension(5, 0)));
        urlPane.add((Component)this.domain);
        urlPane.add(Box.createRigidArea(new Dimension(5, 0)));
        urlPane.add((Component)this.port);
        urlPane.add(Box.createRigidArea(new Dimension(5, 0)));
        urlPane.add((Component)this.connectTimeout);
        topPanel.add(urlPane);
        topPanel.add(this.createParametersPanel());
        return topPanel;
    }

    private final JPanel createParametersPanel() {
        JPanel paramsPanel = new JPanel();
        paramsPanel.setLayout(new BoxLayout(paramsPanel, 0));
        paramsPanel.add((Component)this.path);
        paramsPanel.add(Box.createHorizontalGlue());
        paramsPanel.add((Component)this.soapAction);
        paramsPanel.add(Box.createHorizontalGlue());
        paramsPanel.add(this.maintainSession);
        return paramsPanel;
    }

    private final JPanel createMessagePanel() {
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new BorderLayout(5, 0));
        msgPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"webservice_message_soap")));
        JPanel soapXmlPane = new JPanel();
        soapXmlPane.setLayout(new BorderLayout(5, 0));
        soapXmlPane.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"soap_data_title")));
        soapXmlPane.setPreferredSize(new Dimension(4, 4));
        this.soapXml = new JTextArea();
        this.soapXml.setLineWrap(true);
        this.soapXml.setWrapStyleWord(true);
        this.soapXml.setTabSize(4);
        soapXmlPane.add((Component)new JScrollPane(this.soapXml), "Center");
        msgPanel.add((Component)soapXmlPane, "Center");
        JPanel southPane = new JPanel();
        southPane.setLayout(new BoxLayout(southPane, 1));
        southPane.add((Component)this.soapXmlFile);
        JPanel randomXmlPane = new JPanel();
        randomXmlPane.setLayout(new BorderLayout(5, 0));
        randomXmlPane.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"webservice_get_xml_from_random_title")));
        randomXmlPane.add((Component)this.randomXmlFile, "Center");
        southPane.add(randomXmlPane);
        msgPanel.add((Component)southPane, "South");
        return msgPanel;
    }

    private final JPanel createBottomPanel() {
        JPanel optionPane = new JPanel();
        optionPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"option")));
        optionPane.setLayout(new FlowLayout(0, 0, 0));
        HorizontalPanel ckboxPane = new HorizontalPanel();
        ckboxPane.add((Component)this.memCache, "West");
        ckboxPane.add((Component)this.readResponse, "Center");
        this.readResponse.setToolTipText(this.readToolTip);
        optionPane.add((Component)ckboxPane);
        optionPane.add(this.getProxyServerPanel());
        return optionPane;
    }

    private final JPanel getProxyServerPanel() {
        JPanel proxyServer = new JPanel();
        proxyServer.setLayout(new FlowLayout(0, 0, 0));
        proxyServer.add(this.useProxy);
        this.useProxy.addActionListener(this);
        this.useProxy.setToolTipText(this.proxyToolTip);
        proxyServer.add(Box.createRigidArea(new Dimension(5, 0)));
        proxyServer.add(this.getProxyHostPanel());
        proxyServer.add(Box.createRigidArea(new Dimension(5, 0)));
        proxyServer.add(this.getProxyPortPanel());
        return proxyServer;
    }

    private JPanel getProxyHostPanel() {
        this.proxyHost = new JTextField(12);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_domain"));
        label.setLabelFor(this.proxyHost);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyHost, "Center");
        return panel;
    }

    private JPanel getProxyPortPanel() {
        this.proxyPort = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.proxyPort);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPort, "Center");
        return panel;
    }

    public void configure(TestElement el) {
        super.configure(el);
        WebServiceSampler sampler = (WebServiceSampler)el;
        this.wsdlField.setText(sampler.getWsdlURL());
        String wsdlText = this.wsdlField.getText();
        if (wsdlText != null && wsdlText.length() > 0) {
            this.fillWsdlMethods(this.wsdlField.getText(), true, sampler.getSoapAction());
        }
        this.protocol.setText(sampler.getProtocol());
        this.domain.setText(sampler.getDomain());
        this.port.setText(sampler.getPropertyAsString("HTTPSampler.port"));
        this.path.setText(sampler.getPath());
        this.soapAction.setText(sampler.getSoapAction());
        this.maintainSession.setSelected(sampler.getMaintainSession());
        this.soapXml.setText(sampler.getXmlData());
        this.soapXml.setCaretPosition(0);
        this.soapXmlFile.setFilename(sampler.getXmlFile());
        this.randomXmlFile.setText(sampler.getXmlPathLoc());
        this.connectTimeout.setText(sampler.getTimeout());
        this.memCache.setSelected(sampler.getMemoryCache());
        this.readResponse.setSelected(sampler.getReadResponse());
        this.useProxy.setSelected(sampler.getUseProxy());
        if (sampler.getProxyHost().length() == 0) {
            this.proxyHost.setEnabled(false);
        } else {
            this.proxyHost.setText(sampler.getProxyHost());
        }
        if (sampler.getProxyPort() == 0) {
            this.proxyPort.setEnabled(false);
        } else {
            this.proxyPort.setText(String.valueOf(sampler.getProxyPort()));
        }
    }

    public void configureFromWSDL() {
        if (this.HELPER != null) {
            if (this.HELPER.getBinding() != null) {
                this.protocol.setText(this.HELPER.getProtocol());
                this.domain.setText(this.HELPER.getBindingHost());
                if (this.HELPER.getBindingPort() > 0) {
                    this.port.setText(String.valueOf(this.HELPER.getBindingPort()));
                } else {
                    this.port.setText("80");
                }
                this.path.setText(this.HELPER.getBindingPath());
            }
            this.soapAction.setText(this.HELPER.getSoapAction(this.wsdlMethods.getText()));
        }
    }

    public String[] browseWSDL(String url, boolean silent) {
        try {
            WebServiceSampler sampler = (WebServiceSampler)this.createTestElement();
            AuthManager manager = sampler.getAuthManager();
            this.HELPER = new WSDLHelper(url, manager);
            this.HELPER.parse();
            return this.HELPER.getWebMethods();
        }
        catch (Exception exception) {
            if (!silent) {
                JOptionPane.showConfirmDialog((Component)((Object)this), JMeterUtils.getResString((String)"wsdl_helper_error") + "\n" + exception, JMeterUtils.getResString((String)"warning"), -1, 0);
            }
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.selectButton) {
            this.configureFromWSDL();
        } else if (eventSource == this.useProxy) {
            boolean use = this.useProxy.isSelected();
            if (use) {
                this.proxyHost.setEnabled(true);
                this.proxyPort.setEnabled(true);
            } else {
                this.proxyHost.setEnabled(false);
                this.proxyPort.setEnabled(false);
            }
        } else if (eventSource == this.wsdlButton) {
            String wsdlText = this.wsdlField.getText();
            if (wsdlText != null && wsdlText.length() > 0) {
                this.fillWsdlMethods(wsdlText, false, null);
            } else {
                JOptionPane.showConfirmDialog((Component)((Object)this), JMeterUtils.getResString((String)"wsdl_url_error"), JMeterUtils.getResString((String)"warning"), -1, 0);
            }
        }
    }

    private void fillWsdlMethods(String wsdlText, boolean silent, String soapAction) {
        String[] wsdlData = this.browseWSDL(wsdlText, silent);
        if (wsdlData != null) {
            String selected;
            this.wsdlMethods.setValues(wsdlData);
            if (this.HELPER != null && soapAction != null && (selected = this.HELPER.getSoapActionName(soapAction)) != null) {
                this.wsdlMethods.setText(selected);
            }
            this.wsdlMethods.repaint();
        }
    }
}

