/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.MultipartUrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class HttpTestSampleGui
extends AbstractSamplerGui
implements ItemListener {
    private static final long serialVersionUID = 240L;
    private MultipartUrlConfigGui urlConfigGui;
    private JCheckBox getImages;
    private JCheckBox concurrentDwn;
    private JTextField concurrentPool;
    private JCheckBox isMon;
    private JCheckBox useMD5;
    private JLabeledTextField embeddedRE;
    private JLabeledTextField sourceIpAddr;
    private final boolean isAJP;

    public HttpTestSampleGui() {
        this.isAJP = false;
        this.init();
    }

    protected HttpTestSampleGui(boolean ajp) {
        this.isAJP = ajp;
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        HTTPSamplerBase samplerBase = (HTTPSamplerBase)element;
        this.urlConfigGui.configure(element);
        this.getImages.setSelected(samplerBase.isImageParser());
        this.concurrentDwn.setSelected(samplerBase.isConcurrentDwn());
        this.concurrentPool.setText(samplerBase.getConcurrentPool());
        this.isMon.setSelected(samplerBase.isMonitor());
        this.useMD5.setSelected(samplerBase.useMD5());
        this.embeddedRE.setText(samplerBase.getEmbeddedUrlRE());
        if (!this.isAJP) {
            this.sourceIpAddr.setText(samplerBase.getIpSource());
        }
    }

    public TestElement createTestElement() {
        HTTPSamplerProxy sampler = new HTTPSamplerProxy();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        sampler.clear();
        this.urlConfigGui.modifyTestElement(sampler);
        HTTPSamplerBase samplerBase = (HTTPSamplerBase)sampler;
        samplerBase.setImageParser(this.getImages.isSelected());
        this.enableConcurrentDwn(this.getImages.isSelected());
        samplerBase.setConcurrentDwn(this.concurrentDwn.isSelected());
        samplerBase.setConcurrentPool(this.concurrentPool.getText());
        samplerBase.setMonitor(this.isMon.isSelected());
        samplerBase.setMD5(this.useMD5.isSelected());
        samplerBase.setEmbeddedUrlRE(this.embeddedRE.getText());
        if (!this.isAJP) {
            samplerBase.setIpSource(this.sourceIpAddr.getText());
        }
        this.configureTestElement(sampler);
    }

    public String getLabelResource() {
        return "web_testing_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.urlConfigGui = new MultipartUrlConfigGui(true, !this.isAJP);
        this.add(this.urlConfigGui, "Center");
        this.add(this.createOptionalTasksPanel(), "South");
    }

    protected JPanel createOptionalTasksPanel() {
        VerticalPanel optionalTasksPanel = new VerticalPanel();
        optionalTasksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"optional_tasks")));
        HorizontalPanel checkBoxPanel = new HorizontalPanel();
        this.getImages = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        this.getImages.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    HttpTestSampleGui.this.enableConcurrentDwn(true);
                } else {
                    HttpTestSampleGui.this.enableConcurrentDwn(false);
                }
            }
        });
        this.concurrentDwn = new JCheckBox(JMeterUtils.getResString((String)"web_testing_concurrent_download"));
        this.concurrentDwn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (HttpTestSampleGui.this.getImages.isSelected() && e.getStateChange() == 1) {
                    HttpTestSampleGui.this.concurrentPool.setEnabled(true);
                } else {
                    HttpTestSampleGui.this.concurrentPool.setEnabled(false);
                }
            }
        });
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setMaximumSize(new Dimension(30, 20));
        this.isMon = new JCheckBox(JMeterUtils.getResString((String)"monitor_is_title"));
        this.useMD5 = new JCheckBox(JMeterUtils.getResString((String)"response_save_as_md5"));
        checkBoxPanel.add(this.getImages);
        checkBoxPanel.add(this.concurrentDwn);
        checkBoxPanel.add(this.concurrentPool);
        checkBoxPanel.add(this.isMon);
        checkBoxPanel.add(this.useMD5);
        optionalTasksPanel.add((Component)checkBoxPanel);
        this.embeddedRE = new JLabeledTextField(JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"), 30);
        optionalTasksPanel.add((Component)this.embeddedRE, "Center");
        if (!this.isAJP) {
            this.sourceIpAddr = new JLabeledTextField(JMeterUtils.getResString((String)"web_testing2_source_ip"));
            optionalTasksPanel.add((Component)this.sourceIpAddr, "East");
        }
        return optionalTasksPanel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void clearGui() {
        super.clearGui();
        this.getImages.setSelected(false);
        this.concurrentDwn.setSelected(false);
        this.concurrentPool.setText(String.valueOf(4));
        this.enableConcurrentDwn(false);
        this.isMon.setSelected(false);
        this.useMD5.setSelected(false);
        this.urlConfigGui.clear();
        this.embeddedRE.setText("");
        if (!this.isAJP) {
            this.sourceIpAddr.setText("");
        }
    }

    private void enableConcurrentDwn(boolean enable) {
        if (enable) {
            this.concurrentDwn.setEnabled(true);
            if (this.concurrentDwn.isSelected()) {
                this.concurrentPool.setEnabled(true);
            }
        } else {
            this.concurrentDwn.setEnabled(false);
            this.concurrentPool.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.enableConcurrentDwn(true);
        } else {
            this.enableConcurrentDwn(false);
        }
    }
}

