/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.DOMPool;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.io.TextFile;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.messaging.Message;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceSampler
extends HTTPSamplerBase {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String XML_DATA = "HTTPSamper.xml_data";
    private static final String SOAP_ACTION = "Soap.Action";
    private static final String XML_DATA_FILE = "WebServiceSampler.xml_data_file";
    private static final String XML_PATH_LOC = "WebServiceSampler.xml_path_loc";
    private static final String MEMORY_CACHE = "WebServiceSampler.memory_cache";
    private static final String READ_RESPONSE = "WebServiceSampler.read_response";
    private static final String USE_PROXY = "WebServiceSampler.use_proxy";
    private static final String PROXY_HOST = "WebServiceSampler.proxy_host";
    private static final String PROXY_PORT = "WebServiceSampler.proxy_port";
    private static final String WSDL_URL = "WebserviceSampler.wsdl_url";
    private static final String TIMEOUT = "WebserviceSampler.timeout";
    private static final String PROXY_USER = JMeterUtils.getPropDefault((String)"http.proxyUser", (String)"");
    private static final String PROXY_PASS = JMeterUtils.getPropDefault((String)"http.proxyPass", (String)"");
    private static final String ENCODING = "UTF-8";
    private final Random RANDOM = new Random();
    private String fileContents = null;

    public void setXmlPathLoc(String path) {
        this.setProperty(XML_PATH_LOC, path);
    }

    public String getXmlPathLoc() {
        return this.getPropertyAsString(XML_PATH_LOC);
    }

    public void setXmlFile(String filename) {
        this.setProperty(XML_DATA_FILE, filename);
    }

    public String getXmlFile() {
        return this.getPropertyAsString(XML_DATA_FILE);
    }

    protected String getRandomFileName() {
        if (this.getXmlPathLoc() != null) {
            File src = new File(this.getXmlPathLoc());
            if (src.isDirectory() && src.list() != null) {
                File[] fileList = src.listFiles((FileFilter)new JMeterFileFilter(new String[]{".xml"}, false));
                File one = fileList[this.RANDOM.nextInt(fileList.length)];
                return one.getAbsolutePath();
            }
            return this.getXmlFile();
        }
        return this.getXmlFile();
    }

    public void setXmlData(String data) {
        this.setProperty(XML_DATA, data);
    }

    public String getXmlData() {
        return this.getPropertyAsString(XML_DATA);
    }

    public void setSoapAction(String data) {
        this.setProperty(SOAP_ACTION, data);
    }

    public String getSoapAction() {
        return this.getPropertyAsString(SOAP_ACTION);
    }

    public void setMemoryCache(boolean cache) {
        this.setProperty(MEMORY_CACHE, String.valueOf(cache));
    }

    public boolean getMemoryCache() {
        return this.getPropertyAsBoolean(MEMORY_CACHE);
    }

    public void setReadResponse(boolean read) {
        this.setProperty(READ_RESPONSE, String.valueOf(read));
    }

    public boolean getReadResponse() {
        return this.getPropertyAsBoolean(READ_RESPONSE);
    }

    public void setUseProxy(boolean proxy) {
        this.setProperty(USE_PROXY, String.valueOf(proxy));
    }

    public boolean getUseProxy() {
        return this.getPropertyAsBoolean(USE_PROXY);
    }

    public void setProxyHost(String host) {
        this.setProperty(PROXY_HOST, host);
    }

    @Override
    public String getProxyHost() {
        this.checkProxy();
        return this.getPropertyAsString(PROXY_HOST);
    }

    public void setProxyPort(String port) {
        this.setProperty(PROXY_PORT, port);
    }

    public int getProxyPort() {
        this.checkProxy();
        return this.getPropertyAsInt(PROXY_PORT);
    }

    public void setWsdlURL(String url) {
        this.setProperty(WSDL_URL, url);
    }

    public String getWsdlURL() {
        return this.getPropertyAsString(WSDL_URL);
    }

    private void checkProxy() {
        if (JMeter.isNonGUI()) {
            this.setUseProxy(true);
            String port = this.getPropertyAsString(PROXY_PORT);
            String host = this.getPropertyAsString(PROXY_HOST);
            if ((host == null || host.length() == 0) && (host = System.getProperty("http.proxyHost")) != null) {
                this.setProxyHost(host);
            }
            if ((port == null || port.length() == 0) && (port = System.getProperty("http.proxyPort")) != null) {
                this.setProxyPort(port);
            }
        }
    }

    private Element createDocument() throws SAXException, IOException {
        Document doc = null;
        String next = this.getRandomFileName();
        if (next.length() > 0 && this.getMemoryCache()) {
            doc = DOMPool.getDocument(next);
            if (doc == null && (doc = this.openDocument(next)) != null) {
                DOMPool.putDocument(next, doc);
            }
        } else {
            doc = this.openDocument(next);
        }
        if (doc == null) {
            return null;
        }
        return doc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document openDocument(String file) throws SAXException, IOException {
        Document doc;
        block6: {
            DocumentBuilder XDB = XMLParserUtils.getXMLDocBuilder();
            XDB.setErrorHandler(null);
            doc = null;
            if (file.length() > 0) {
                if (this.getReadResponse()) {
                    TextFile tfile = new TextFile(file);
                    this.fileContents = tfile.getText();
                }
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    doc = XDB.parse(fileInputStream);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    IOUtils.closeQuietly((InputStream)fileInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fileInputStream);
                {
                    break block6;
                }
            }
            this.fileContents = this.getXmlData();
            if (this.fileContents != null && this.fileContents.length() > 0) {
                doc = XDB.parse(new InputSource(new StringReader(this.fileContents)));
            } else {
                log.warn("No post data provided!");
            }
        }
        return doc;
    }

    @Override
    protected HTTPSampleResult sample(URL u, String s, boolean b, int i) {
        throw new RuntimeException("Not implemented - should not be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SampleResult sample() {
        SampleResult result = new SampleResult();
        result.setSuccessful(false);
        result.setResponseCode("000");
        result.setSampleLabel(this.getName());
        try {
            block39: {
                try {
                    result.setURL(this.getUrl());
                    Element rdoc = this.createDocument();
                    if (rdoc == null) {
                        throw new SOAPException("Could not create document", null);
                    }
                    result.setDataEncoding(ENCODING);
                    result.setContentType("text/xml");
                    result.setDataType("text");
                    result.setSamplerData(this.fileContents);
                    Envelope msgEnv = Envelope.unmarshall((Node)rdoc);
                    Message msg = new Message();
                    result.sampleStart();
                    SOAPHTTPConnection spconn = null;
                    spconn = this.getHeaderManager() != null && this.getHeaderManager().getSOAPHeader() != null ? (SOAPHTTPConnection)this.getHeaderManager().getSOAPHeader() : new SOAPHTTPConnection();
                    spconn.setTimeout(this.getTimeoutAsInt());
                    if (this.getAuthManager() != null) {
                        if (this.getAuthManager().getAuthForURL(this.getUrl()) != null) {
                            AuthManager authmanager = this.getAuthManager();
                            Authorization auth = authmanager.getAuthForURL(this.getUrl());
                            spconn.setUserName(auth.getUser());
                            spconn.setPassword(auth.getPass());
                        } else {
                            log.warn("the URL for the auth was null. Username and password not set");
                        }
                    }
                    String phost = "";
                    int pport = 0;
                    if (this.getUseProxy()) {
                        if (this.getProxyHost().length() > 0 && this.getProxyPort() > 0) {
                            phost = this.getProxyHost();
                            pport = this.getProxyPort();
                        } else if (System.getProperty("http.proxyHost") != null || System.getProperty("http.proxyPort") != null) {
                            phost = System.getProperty("http.proxyHost");
                            pport = Integer.parseInt(System.getProperty("http.proxyPort"));
                        }
                        if (phost.length() > 0 && pport > 0) {
                            spconn.setProxyHost(phost);
                            spconn.setProxyPort(pport);
                            if (PROXY_USER.length() > 0 && PROXY_PASS.length() > 0) {
                                spconn.setProxyUserName(PROXY_USER);
                                spconn.setProxyPassword(PROXY_PASS);
                            }
                        }
                    }
                    spconn.setMaintainSession(true);
                    msg.setSOAPTransport((SOAPTransport)spconn);
                    msg.send(this.getUrl(), this.getSoapAction(), msgEnv);
                    Hashtable headers = spconn.getHeaders();
                    result.setResponseHeaders(this.convertSoapHeaders(headers));
                    if (this.getHeaderManager() != null) {
                        this.getHeaderManager().setSOAPHeader(spconn);
                    }
                    BufferedReader br = null;
                    if (spconn.receive() != null) {
                        br = spconn.receive();
                        SOAPContext sc = spconn.getResponseSOAPContext();
                        String contentType = sc.getContentType();
                        result.setContentType(contentType);
                        result.setEncodingAndType(contentType);
                        int length = 0;
                        if (this.getReadResponse()) {
                            StringWriter sw = new StringWriter();
                            length = IOUtils.copy((Reader)br, (Writer)sw);
                            result.sampleEnd();
                            result.setResponseData(sw.toString().getBytes(result.getDataEncodingWithDefault()));
                        } else {
                            length = br.read();
                            result.sampleEnd();
                            result.setResponseData(JMeterUtils.getResString((String)"read_response_message"), null);
                        }
                        if (length > 0) {
                            result.setSuccessful(true);
                            result.setResponseCodeOK();
                            result.setResponseMessageOK();
                        } else {
                            result.setSuccessful(false);
                            result.setResponseCode("999");
                            result.setResponseMessage("Empty response");
                        }
                    } else {
                        result.sampleEnd();
                        result.setSuccessful(false);
                        String contentType = spconn.getResponseSOAPContext().getContentType();
                        result.setContentType(contentType);
                        result.setEncodingAndType(contentType);
                        result.setResponseData(spconn.getResponseSOAPContext().toString().getBytes(result.getDataEncodingWithDefault()));
                    }
                    if (br == null) break block39;
                    br.close();
                }
                catch (IllegalArgumentException exception) {
                    String message = exception.getMessage();
                    log.warn(message);
                    result.setResponseMessage(message);
                    Object var15_27 = null;
                    if (result.getStartTime() == 0L) {
                        result.sampleStart();
                    }
                    if (result.getEndTime() != 0L) return result;
                    result.sampleEnd();
                    return result;
                }
                catch (SAXException exception) {
                    log.warn(exception.toString());
                    result.setResponseMessage(exception.getMessage());
                    Object var15_28 = null;
                    if (result.getStartTime() == 0L) {
                        result.sampleStart();
                    }
                    if (result.getEndTime() != 0L) return result;
                    result.sampleEnd();
                    return result;
                }
                catch (SOAPException exception) {
                    log.warn(exception.toString());
                    result.setResponseMessage(exception.getMessage());
                    Object var15_29 = null;
                    if (result.getStartTime() == 0L) {
                        result.sampleStart();
                    }
                    if (result.getEndTime() != 0L) return result;
                    result.sampleEnd();
                    return result;
                }
                catch (MalformedURLException exception) {
                    String message = exception.getMessage();
                    log.warn(message);
                    result.setResponseMessage(message);
                    Object var15_30 = null;
                    if (result.getStartTime() == 0L) {
                        result.sampleStart();
                    }
                    if (result.getEndTime() != 0L) return result;
                    result.sampleEnd();
                    return result;
                }
                catch (IOException exception) {
                    String message = exception.getMessage();
                    log.warn(message);
                    result.setResponseMessage(message);
                    Object var15_31 = null;
                    if (result.getStartTime() == 0L) {
                        result.sampleStart();
                    }
                    if (result.getEndTime() != 0L) return result;
                    result.sampleEnd();
                    return result;
                }
                catch (NoClassDefFoundError error) {
                    log.error("Missing class: ", (Throwable)error);
                    result.setResponseMessage(error.toString());
                    Object var15_32 = null;
                    if (result.getStartTime() == 0L) {
                        result.sampleStart();
                    }
                    if (result.getEndTime() != 0L) return result;
                    result.sampleEnd();
                    return result;
                }
                catch (Exception exception) {
                    if ("javax.mail.MessagingException".equals(exception.getClass().getName())) {
                        log.warn(exception.toString());
                        result.setResponseMessage(exception.getMessage());
                    } else {
                        log.error("Problem processing the SOAP request", (Throwable)exception);
                        result.setResponseMessage(exception.toString());
                    }
                    Object var15_33 = null;
                    if (result.getStartTime() == 0L) {
                        result.sampleStart();
                    }
                    if (result.getEndTime() != 0L) return result;
                    result.sampleEnd();
                    return result;
                }
            }
            Object var15_26 = null;
            if (result.getStartTime() == 0L) {
                result.sampleStart();
            }
            if (result.getEndTime() != 0L) return result;
            result.sampleEnd();
            return result;
        }
        catch (Throwable throwable) {
            Object var15_34 = null;
            if (result.getStartTime() == 0L) {
                result.sampleStart();
            }
            if (result.getEndTime() != 0L) throw throwable;
            result.sampleEnd();
            throw throwable;
        }
    }

    @Override
    public void addEncodedArgument(String name, String value, String metaData) {
    }

    public String convertSoapHeaders(Map<String, String> ht) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : ht.entrySet()) {
            buf.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return buf.toString();
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT);
    }

    public int getTimeoutAsInt() {
        return this.getPropertyAsInt(TIMEOUT);
    }

    public void setTimeout(String text) {
        this.setProperty(TIMEOUT, text);
    }
}

