/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.protocol.http.control.HttpMirrorServer;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;

public class HttpMirrorControl
extends AbstractTestElement {
    private static final long serialVersionUID = 233L;
    private transient HttpMirrorServer server;
    static final int DEFAULT_PORT = 8081;
    public static final String DEFAULT_PORT_S = Integer.toString(8081);
    public static final String PORT = "HttpMirrorControlGui.port";
    public static final String MAX_POOL_SIZE = "HttpMirrorControlGui.maxPoolSize";
    public static final String MAX_QUEUE_SIZE = "HttpMirrorControlGui.maxQueueSize";
    public static final int DEFAULT_MAX_POOL_SIZE = 0;
    public static final int DEFAULT_MAX_QUEUE_SIZE = 25;

    public HttpMirrorControl() {
        this.initPort(8081);
    }

    public HttpMirrorControl(int port) {
        this.initPort(port);
    }

    private void initPort(int port) {
        this.setProperty((JMeterProperty)new IntegerProperty(PORT, port));
    }

    public void setPort(int port) {
        this.initPort(port);
    }

    public void setPort(String port) {
        this.setProperty(PORT, port);
    }

    public int getPort() {
        return this.getPropertyAsInt(PORT);
    }

    public String getPortString() {
        return this.getPropertyAsString(PORT);
    }

    public String getMaxPoolSizeAsString() {
        return this.getPropertyAsString(MAX_POOL_SIZE);
    }

    private int getMaxPoolSize() {
        return this.getPropertyAsInt(MAX_POOL_SIZE, 0);
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.setProperty(MAX_POOL_SIZE, maxPoolSize);
    }

    public String getMaxQueueSizeAsString() {
        return this.getPropertyAsString(MAX_QUEUE_SIZE);
    }

    private int getMaxQueueSize() {
        return this.getPropertyAsInt(MAX_QUEUE_SIZE, 25);
    }

    public void setMaxQueueSize(String maxQueueSize) {
        this.setProperty(MAX_QUEUE_SIZE, maxQueueSize);
    }

    public int getDefaultPort() {
        return 8081;
    }

    public void startHttpMirror() {
        this.server = new HttpMirrorServer(this.getPort(), this.getMaxPoolSize(), this.getMaxQueueSize());
        this.server.start();
        GuiPackage instance = GuiPackage.getInstance();
        if (instance != null) {
            instance.register((Stoppable)this.server);
        }
    }

    public void stopHttpMirror() {
        if (this.server != null) {
            this.server.stopServer();
            GuiPackage instance = GuiPackage.getInstance();
            if (instance != null) {
                instance.unregister((Stoppable)this.server);
            }
            try {
                this.server.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.server = null;
        }
    }

    public boolean canRemove() {
        return null == this.server;
    }

    public boolean isServerAlive() {
        return this.server != null && this.server.isAlive();
    }
}

