/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public abstract class HTTPHCAbstractImpl
extends HTTPAbstractImpl {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected static final String PROXY_HOST = System.getProperty("http.proxyHost", "");
    protected static final String NONPROXY_HOSTS = System.getProperty("http.nonProxyHosts", "");
    protected static final int PROXY_PORT = Integer.parseInt(System.getProperty("http.proxyPort", "0"));
    protected static final boolean PROXY_DEFINED = PROXY_HOST.length() > 0 && PROXY_PORT > 0;
    protected static final String PROXY_USER = JMeterUtils.getPropDefault((String)"http.proxyUser", (String)"");
    protected static final String PROXY_PASS = JMeterUtils.getPropDefault((String)"http.proxyPass", (String)"");
    protected static final String PROXY_DOMAIN = JMeterUtils.getPropDefault((String)"http.proxyDomain", (String)"");
    protected static final InetAddress localAddress;
    protected static final String localHost;
    protected static final Set<String> nonProxyHostFull;
    protected static final List<String> nonProxyHostSuffix;
    protected static final int nonProxyHostSuffixSize;
    protected static final int CPS_HTTP;
    protected static final int CPS_HTTPS;
    protected static final boolean USE_LOOPBACK;
    protected static final String HTTP_VERSION;
    protected static final int SO_TIMEOUT;
    protected static final boolean USE_CACHED_SSL_CONTEXT;

    protected HTTPHCAbstractImpl(HTTPSamplerBase testElement) {
        super(testElement);
    }

    protected static boolean isNonProxy(String host) {
        return nonProxyHostFull.contains(host) || HTTPHCAbstractImpl.isPartialMatch(host);
    }

    protected static boolean isPartialMatch(String host) {
        for (int i = 0; i < nonProxyHostSuffixSize; ++i) {
            if (!host.endsWith(nonProxyHostSuffix.get(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean isDynamicProxy(String proxyHost, int proxyPort) {
        return !JOrphanUtils.isBlank((String)proxyHost) && proxyPort > 0;
    }

    protected static boolean isStaticProxy(String host) {
        return PROXY_DEFINED && !HTTPHCAbstractImpl.isNonProxy(host);
    }

    protected static boolean isNullOrEmptyTrimmed(String value) {
        return JOrphanUtils.isBlank((String)value);
    }

    static {
        nonProxyHostFull = new HashSet<String>();
        nonProxyHostSuffix = new ArrayList<String>();
        CPS_HTTP = JMeterUtils.getPropDefault((String)"httpclient.socket.http.cps", (int)0);
        CPS_HTTPS = JMeterUtils.getPropDefault((String)"httpclient.socket.https.cps", (int)0);
        USE_LOOPBACK = JMeterUtils.getPropDefault((String)"httpclient.loopback", (boolean)false);
        HTTP_VERSION = JMeterUtils.getPropDefault((String)"httpclient.version", (String)"1.1");
        SO_TIMEOUT = JMeterUtils.getPropDefault((String)"httpclient.timeout", (int)-1);
        USE_CACHED_SSL_CONTEXT = JMeterUtils.getPropDefault((String)"https.use.cached.ssl.context", (boolean)true);
        if (NONPROXY_HOSTS.length() > 0) {
            StringTokenizer s = new StringTokenizer(NONPROXY_HOSTS, "|");
            while (s.hasMoreTokens()) {
                String t = s.nextToken();
                if (t.indexOf(42) == 0) {
                    nonProxyHostSuffix.add(t.substring(1));
                    continue;
                }
                nonProxyHostFull.add(t);
            }
        }
        nonProxyHostSuffixSize = nonProxyHostSuffix.size();
        InetAddress inet = null;
        String localHostOrIP = JMeterUtils.getPropDefault((String)"httpclient.localaddress", (String)"");
        if (localHostOrIP.length() > 0) {
            try {
                inet = InetAddress.getByName(localHostOrIP);
                log.info("Using localAddress " + inet.getHostAddress());
            }
            catch (UnknownHostException e) {
                log.warn(e.getLocalizedMessage());
            }
        } else {
            localHostOrIP = JMeterUtils.getLocalHostName();
        }
        localAddress = inet;
        localHost = localHostOrIP;
        log.info("Local host = " + localHost);
    }
}

