/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.HTMLParser;
import org.apache.jmeter.protocol.http.parser.HtmlParsingUtils;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.scanners.ScriptScanner;
import org.htmlparser.tags.AppletTag;
import org.htmlparser.tags.BaseHrefTag;
import org.htmlparser.tags.BodyTag;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.FrameTag;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.InputTag;
import org.htmlparser.tags.ObjectTag;
import org.htmlparser.tags.ScriptTag;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.ParserException;

class HtmlParserHTMLParser
extends HTMLParser {
    private static final Logger log = LoggingManager.getLoggerForClass();

    protected HtmlParserHTMLParser() {
        log.info("Using htmlparser version: " + Parser.getVersion());
    }

    @Override
    protected boolean isReusable() {
        return true;
    }

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(byte[] html, URL baseUrl, URLCollection urls, String encoding) throws HTMLParseException {
        if (log.isDebugEnabled()) {
            log.debug("Parsing html of: " + baseUrl);
        }
        Parser htmlParser = null;
        try {
            String contents = new String(html, encoding);
            htmlParser = new Parser();
            htmlParser.setInputHTML(contents);
        }
        catch (Exception e) {
            throw new HTMLParseException(e);
        }
        try {
            this.parseNodes(htmlParser.elements(), new URLPointer(baseUrl), urls);
            log.debug("End   : parseNodes");
        }
        catch (ParserException e) {
            throw new HTMLParseException(e);
        }
        return urls.iterator();
    }

    /*
     * Unable to fully structure code
     */
    private void parseNodes(NodeIterator e, URLPointer baseUrl, URLCollection urls) throws HTMLParseException, ParserException {
        while (e.hasMoreNodes()) {
            node = e.nextNode();
            if (!(node instanceof Tag)) continue;
            tag = (Tag)node;
            tagname = tag.getTagName();
            binUrlStr = null;
            if (tag instanceof BodyTag) {
                binUrlStr = tag.getAttribute("background");
            } else if (tag instanceof BaseHrefTag) {
                baseHref = (BaseHrefTag)tag;
                baseref = baseHref.getBaseUrl();
                try {
                    if (baseref.equals("")) ** GOTO lbl54
                    URLPointer.access$102(baseUrl, ConversionUtils.makeRelativeURL(URLPointer.access$100(baseUrl), baseref));
                }
                catch (MalformedURLException e1) {
                    throw new HTMLParseException(e1);
                }
            } else if (tag instanceof ImageTag) {
                image = (ImageTag)tag;
                binUrlStr = image.getImageURL();
            } else if (tag instanceof AppletTag) {
                applet = (AppletTag)tag;
                binUrlStr = applet.getAppletClass();
            } else if (tag instanceof ObjectTag) {
                applet = (ObjectTag)tag;
                data = applet.getAttribute("codebase");
                if (!StringUtils.isEmpty((CharSequence)data)) {
                    binUrlStr = data;
                }
                if (!StringUtils.isEmpty((CharSequence)(data = applet.getAttribute("data")))) {
                    binUrlStr = data;
                }
            } else if (tag instanceof InputTag) {
                if ("image".equalsIgnoreCase(tag.getAttribute("type"))) {
                    binUrlStr = tag.getAttribute("src");
                }
            } else if (tag instanceof ScriptTag) {
                binUrlStr = tag.getAttribute("src");
            } else if (tag instanceof FrameTag || tagname.equalsIgnoreCase("iframe")) {
                binUrlStr = tag.getAttribute("src");
            } else if (tagname.equalsIgnoreCase("embed") || tagname.equalsIgnoreCase("bgsound")) {
                binUrlStr = tag.getAttribute("src");
            } else if (tagname.equalsIgnoreCase("link")) {
                if ("stylesheet".equalsIgnoreCase(tag.getAttribute("rel"))) {
                    binUrlStr = tag.getAttribute("href");
                }
            } else {
                binUrlStr = tag.getAttribute("background");
            }
lbl54:
            // 12 sources

            if (binUrlStr != null) {
                urls.addURL(binUrlStr, URLPointer.access$100(baseUrl));
            }
            if ((styleTagStr = tag.getAttribute("style")) != null) {
                HtmlParsingUtils.extractStyleURLs(URLPointer.access$100(baseUrl), urls, styleTagStr);
            }
            if (!(tag instanceof CompositeTag)) continue;
            composite = (CompositeTag)tag;
            this.parseNodes((NodeIterator)composite.elements(), baseUrl, urls);
        }
    }

    static {
        ScriptScanner.STRICT = false;
    }

    private static class URLPointer {
        private URL url;

        private URLPointer(URL newUrl) {
            this.url = newUrl;
        }

        static /* synthetic */ URL access$102(URLPointer x0, URL x1) {
            x0.url = x1;
            return x0.url;
        }

        static /* synthetic */ URL access$100(URLPointer x0) {
            return x0.url;
        }
    }
}

