/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;

public class SetProperty
extends AbstractFunction {
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__setProperty";
    private static final int MIN_PARAMETER_COUNT = 2;
    private static final int MAX_PARAMETER_COUNT = 3;
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String propertyName = ((CompoundVariable)this.values[0]).execute();
        String propertyValue = ((CompoundVariable)this.values[1]).execute();
        boolean returnValue = false;
        if (this.values.length > 2) {
            returnValue = ((CompoundVariable)this.values[2]).execute().equalsIgnoreCase("true");
        }
        if (returnValue) {
            return (String)JMeterUtils.setProperty((String)propertyName, (String)propertyValue);
        }
        JMeterUtils.setProperty((String)propertyName, (String)propertyValue);
        return "";
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 2, 3);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"property_name_param"));
        desc.add(JMeterUtils.getResString((String)"property_value_param"));
        desc.add(JMeterUtils.getResString((String)"property_returnvalue_param"));
    }
}

