/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;

public class Variable
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__V";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 1;
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String variableName = ((CompoundVariable)this.values[0]).execute();
        String variableValue = this.getVariables().get(variableName);
        return variableValue == null ? variableName : variableValue;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 1);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"variable_name_param"));
    }
}

