/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.jexl.Script;
import org.apache.commons.jexl.ScriptFactory;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlFunction
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String KEY = "__jexl";
    private static final List<String> desc = new LinkedList<String>();
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String str = "";
        CompoundVariable var = (CompoundVariable)this.values[0];
        String exp = var.execute();
        String varName = "";
        if (this.values.length > 1) {
            varName = ((CompoundVariable)this.values[1]).execute().trim();
        }
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        try {
            Script script = ScriptFactory.createScript((String)exp);
            JexlContext jc = JexlHelper.createContext();
            Map jexlVars = jc.getVars();
            jexlVars.put("log", log);
            jexlVars.put("ctx", jmctx);
            jexlVars.put("vars", vars);
            jexlVars.put("props", JMeterUtils.getJMeterProperties());
            jexlVars.put("threadName", Thread.currentThread().getName());
            jexlVars.put("sampler", currentSampler);
            jexlVars.put("sampleResult", previousResult);
            jexlVars.put("OUT", System.out);
            Object o = script.execute(jc);
            if (o != null) {
                str = o.toString();
            }
            if (vars != null && varName.length() > 0) {
                vars.put(varName, str);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while evaluating the expression \"" + exp + "\"\n", (Throwable)e);
        }
        return str;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public String getReferenceKey() {
        return KEY;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray();
    }

    static {
        desc.add(JMeterUtils.getResString((String)"jexl_expression"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

