/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.influxdb;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.visualizers.backend.influxdb.AbstractInfluxdbMetricsSender;
import org.apache.jmeter.visualizers.backend.influxdb.InfluxdbMetricsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UdpMetricsSender
extends AbstractInfluxdbMetricsSender {
    private static final Logger log = LoggerFactory.getLogger(UdpMetricsSender.class);
    private final Object lock = new Object();
    private InetAddress hostAddress;
    private int udpPort;
    private List<InfluxdbMetricsSender.MetricTuple> metrics = new ArrayList<InfluxdbMetricsSender.MetricTuple>();

    UdpMetricsSender() {
    }

    @Override
    public void setup(String influxdbUrl, String influxDBToken) throws Exception {
        try {
            log.debug("Setting up with url:{}", (Object)influxdbUrl);
            String[] urlComponents = influxdbUrl.split(":");
            if (urlComponents.length != 2) {
                throw new IllegalArgumentException("Influxdb url '" + influxdbUrl + "' is wrong. The format shoule be <host/ip>:<port>");
            }
            this.hostAddress = InetAddress.getByName(urlComponents[0]);
            this.udpPort = Integer.parseInt(urlComponents[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Influxdb url '" + influxdbUrl + "' is wrong. The format shoule be <host/ip>:<port>", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(String mesurement, String tag, String field) {
        Object object = this.lock;
        synchronized (object) {
            this.metrics.add(new InfluxdbMetricsSender.MetricTuple(mesurement, tag, field, System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAndSendMetrics() {
        List<InfluxdbMetricsSender.MetricTuple> tempMetrics;
        Object object = this.lock;
        synchronized (object) {
            if (this.metrics.isEmpty()) {
                return;
            }
            tempMetrics = this.metrics;
            this.metrics = new ArrayList<InfluxdbMetricsSender.MetricTuple>(tempMetrics.size());
        }
        List<InfluxdbMetricsSender.MetricTuple> copyMetrics = tempMetrics;
        if (!copyMetrics.isEmpty()) {
            StringBuilder sb = new StringBuilder(copyMetrics.size() * 35);
            for (InfluxdbMetricsSender.MetricTuple metric : copyMetrics) {
                sb.append(metric.measurement).append(metric.tag).append(" ").append(metric.field).append(" ").append(metric.timestamp + "000000").append("\n");
            }
            try (DatagramSocket ds = new DatagramSocket();){
                byte[] buf = sb.toString().getBytes();
                DatagramPacket dp = new DatagramPacket(buf, buf.length, this.hostAddress, this.udpPort);
                ds.send(dp);
            }
            catch (SocketException e) {
                log.error("Cannot open udp port!", (Throwable)e);
                return;
            }
            catch (IOException e) {
                log.error("Error in transferring udp package", (Throwable)e);
            }
            finally {
                copyMetrics.clear();
            }
        }
    }

    @Override
    public void destroy() {
    }
}

