/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.report.utils.MetricUtils;
import org.apache.jmeter.samplers.SampleResult;

public class ErrorMetric {
    private String responseCode = "";
    private String responseMessage = "";

    public ErrorMetric() {
    }

    public ErrorMetric(SampleResult result) {
        if (MetricUtils.isSuccessCode((String)this.responseCode) || StringUtils.isEmpty((CharSequence)this.responseCode) && !StringUtils.isEmpty((CharSequence)result.getFirstAssertionFailureMessage())) {
            this.responseCode = "Assertion failed";
            this.responseMessage = result.getFirstAssertionFailureMessage();
        } else {
            this.responseCode = result.getResponseCode();
            this.responseMessage = result.getResponseMessage();
        }
    }

    public String getResponseCode() {
        if (this.responseCode.isEmpty()) {
            return "0";
        }
        return this.responseCode.trim();
    }

    public String getResponseMessage() {
        if (this.responseMessage.isEmpty()) {
            return "None";
        }
        return this.responseMessage.trim();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ErrorMetric)) {
            return false;
        }
        ErrorMetric otherError = (ErrorMetric)other;
        return this.getResponseCode().equalsIgnoreCase(otherError.getResponseCode()) && this.getResponseMessage().equalsIgnoreCase(otherError.getResponseMessage());
    }

    public int hashCode() {
        return this.getResponseCode().toLowerCase().hashCode() + this.getResponseMessage().toLowerCase().hashCode();
    }
}

