/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.jmespath.gui;

import javax.swing.JCheckBox;
import org.apache.jmeter.assertions.gui.JSONPathAssertionGui;
import org.apache.jmeter.assertions.jmespath.JMESPathAssertion;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class JMESPathAssertionGui
extends JSONPathAssertionGui {
    private static final long serialVersionUID = 3719848809836264945L;
    private static final String JMES_ASSERTION_PATH = "jmespath_assertion_path";
    private static final String JMES_ASSERTION_VALIDATION = "jmespath_assertion_validation";
    private static final String JMES_ASSERTION_REGEX = "jmespath_assertion_regex";
    private static final String JMES_ASSERTION_EXPECTED_VALUE = "jmespath_assertion_expected_value";
    private static final String JMES_ASSERTION_NULL = "jmespath_assertion_null";
    private static final String JMES_ASSERTION_INVERT = "jmespath_assertion_invert";
    private static final String JMES_ASSERTION_TITLE = "jmespath_assertion_title";

    @Override
    protected final void initFields() {
        this.jsonPath = new JLabeledTextField(JMeterUtils.getResString((String)JMES_ASSERTION_PATH));
        this.jsonValue = new JLabeledTextArea(JMeterUtils.getResString((String)JMES_ASSERTION_EXPECTED_VALUE));
        this.jsonValidation = new JCheckBox(JMeterUtils.getResString((String)JMES_ASSERTION_VALIDATION));
        this.expectNull = new JCheckBox(JMeterUtils.getResString((String)JMES_ASSERTION_NULL));
        this.invert = new JCheckBox(JMeterUtils.getResString((String)JMES_ASSERTION_INVERT));
        this.isRegex = new JCheckBox(JMeterUtils.getResString((String)JMES_ASSERTION_REGEX));
    }

    @Override
    public TestElement createTestElement() {
        JMESPathAssertion jmesAssertion = new JMESPathAssertion();
        this.modifyTestElement((TestElement)jmesAssertion);
        return jmesAssertion;
    }

    @Override
    public String getLabelResource() {
        return JMES_ASSERTION_TITLE;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JMESPathAssertion) {
            JMESPathAssertion jmesAssertion = (JMESPathAssertion)element;
            jmesAssertion.setJmesPath(this.jsonPath.getText());
            jmesAssertion.setExpectedValue(this.jsonValue.getText());
            jmesAssertion.setJsonValidationBool(this.jsonValidation.isSelected());
            jmesAssertion.setExpectNull(this.expectNull.isSelected());
            jmesAssertion.setInvert(this.invert.isSelected());
            jmesAssertion.setIsRegex(this.isRegex.isSelected());
        }
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JMESPathAssertion) {
            JMESPathAssertion jmesAssertion = (JMESPathAssertion)element;
            this.jsonPath.setText(jmesAssertion.getJmesPath());
            this.jsonValue.setText(jmesAssertion.getExpectedValue());
            this.jsonValidation.setSelected(jmesAssertion.isJsonValidationBool());
            this.expectNull.setSelected(jmesAssertion.isExpectNull());
            this.invert.setSelected(jmesAssertion.isInvert());
            this.isRegex.setSelected(jmesAssertion.isUseRegex());
        }
    }
}

