/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.BackendListener;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;
import org.apache.jorphan.reflect.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=4)
public class BackendListenerGui
extends AbstractListenerGui
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BackendListenerGui.class);
    private JComboBox<String> classnameCombo;
    private JTextField queueSize;
    private ArgumentsPanel argsPanel;
    private String className;

    public BackendListenerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "backend_listener";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel classnameRequestPanel = new JPanel(new BorderLayout(0, 5));
        classnameRequestPanel.add((Component)this.createClassnamePanel(), "North");
        classnameRequestPanel.add((Component)this.createParameterPanel(), "Center");
        this.add(classnameRequestPanel, "Center");
        this.className = ((String)this.classnameCombo.getSelectedItem()).trim();
    }

    private JPanel createClassnamePanel() {
        List possibleClasses = new ArrayList();
        try {
            possibleClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{BackendListenerClient.class});
            possibleClasses.remove(BackendListener.class.getName() + "$ErrorBackendListenerClient");
        }
        catch (Exception e) {
            log.debug("Exception getting interfaces.", (Throwable)e);
        }
        JLabel label = new JLabel(JMeterUtils.getResString((String)"backend_listener_classname"));
        this.classnameCombo = new JComboBox<String>(possibleClasses.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        this.classnameCombo.addActionListener(this);
        this.classnameCombo.setEditable(false);
        label.setLabelFor(this.classnameCombo);
        HorizontalPanel classNamePanel = new HorizontalPanel();
        classNamePanel.add((Component)label);
        classNamePanel.add(this.classnameCombo);
        this.queueSize = new JTextField("5000", 5);
        this.queueSize.setName("Queue Size");
        JLabel queueSizeLabel = new JLabel(JMeterUtils.getResString((String)"backend_listener_queue_size"));
        queueSizeLabel.setLabelFor(this.queueSize);
        HorizontalPanel queueSizePanel = new HorizontalPanel();
        queueSizePanel.add((Component)queueSizeLabel, (Object)"West");
        queueSizePanel.add((Component)this.queueSize);
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)classNamePanel, "North");
        panel.add((Component)queueSizePanel, "Center");
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.classnameCombo) {
            String newClassName = ((String)this.classnameCombo.getSelectedItem()).trim();
            try {
                BackendListenerClient client = this.createBackendListenerClient(newClassName);
                BackendListenerClient oldClient = this.createBackendListenerClient(this.className);
                Arguments currArgs = new Arguments();
                this.argsPanel.modifyTestElement((TestElement)currArgs);
                Map currArgsMap = currArgs.getArgumentsAsMap();
                HashMap<String, String> userArgMap = new HashMap<String, String>();
                userArgMap.putAll(currArgsMap);
                Arguments defaultArgs = this.extractDefaultArguments(client, userArgMap, oldClient.getDefaultParameters());
                Arguments newArgs = this.copyDefaultArguments(currArgsMap, defaultArgs);
                userArgMap.forEach((arg_0, arg_1) -> ((Arguments)newArgs).addArgument(arg_0, arg_1));
                this.className = newClassName;
                this.argsPanel.configure((TestElement)newArgs);
            }
            catch (Exception e) {
                log.error("Error getting argument list for {}", (Object)newClassName, (Object)e);
            }
        }
    }

    private Arguments copyDefaultArguments(Map<String, String> currArgsMap, Arguments defaultArgs) {
        Arguments newArgs = new Arguments();
        if (defaultArgs != null) {
            for (JMeterProperty jMeterProperty : defaultArgs.getArguments()) {
                String newVal;
                Argument arg = (Argument)jMeterProperty.getObjectValue();
                String name = arg.getName();
                String value = arg.getValue();
                if (currArgsMap.containsKey(name) && StringUtils.isNotBlank((CharSequence)(newVal = currArgsMap.get(name)))) {
                    value = newVal;
                }
                newArgs.addArgument(name, value);
            }
        }
        return newArgs;
    }

    private Arguments extractDefaultArguments(BackendListenerClient client, Map<String, String> userArgMap, Arguments currentUserArguments) {
        Arguments defaultArgs = null;
        try {
            defaultArgs = client.getDefaultParameters();
            if (currentUserArguments != null) {
                userArgMap.keySet().removeAll(currentUserArguments.getArgumentsAsMap().keySet());
            }
        }
        catch (AbstractMethodError e) {
            log.warn("BackendListenerClient doesn't implement getDefaultParameters.  Default parameters won't be shown.  Please update your client class: {}", (Object)client.getClass().getName());
        }
        return defaultArgs;
    }

    private BackendListenerClient createBackendListenerClient(String newClassName) throws ReflectiveOperationException {
        return (BackendListenerClient)Class.forName(newClassName, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private JPanel createParameterPanel() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"backend_listener_paramtable"));
        return this.argsPanel;
    }

    public void configure(TestElement config) {
        super.configure(config);
        this.argsPanel.configure((TestElement)((Arguments)config.getProperty("arguments").getObjectValue()));
        this.className = config.getPropertyAsString("classname");
        if (BackendListenerGui.checkContainsClassName(this.classnameCombo.getModel(), this.className)) {
            this.classnameCombo.setSelectedItem(this.className);
        } else {
            log.error("Error setting class: '{}' in BackendListener: {}, check for a missing jar in your jmeter 'search_paths' and 'plugin_dependency_paths' properties", (Object)this.className, (Object)this.getName());
        }
        this.queueSize.setText(((BackendListener)config).getQueueSize());
    }

    private static boolean checkContainsClassName(ComboBoxModel<?> model, String className) {
        int size = model.getSize();
        HashSet<String> set = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            set.add((String)model.getElementAt(i));
        }
        return set.contains(className);
    }

    public TestElement createTestElement() {
        BackendListener config = new BackendListener();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        this.configureTestElement(config);
        BackendListener backendListener = (BackendListener)config;
        backendListener.setArguments((Arguments)this.argsPanel.createTestElement());
        backendListener.setClassname(String.valueOf(this.classnameCombo.getSelectedItem()));
        backendListener.setQueueSize(this.queueSize.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.argsPanel.clearGui();
        this.classnameCombo.setSelectedIndex(0);
        this.queueSize.setText("5000");
    }
}

