/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.Document;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexExtractor
extends AbstractScopedTestElement
implements PostProcessor,
Serializable {
    private static final long serialVersionUID = 242L;
    private static final Logger log = LoggerFactory.getLogger(RegexExtractor.class);
    private static final String MATCH_AGAINST = "RegexExtractor.useHeaders";
    public static final String USE_HDRS = "true";
    public static final String USE_REQUEST_HDRS = "request_headers";
    public static final String USE_BODY = "false";
    public static final String USE_BODY_UNESCAPED = "unescaped";
    public static final String USE_BODY_AS_DOCUMENT = "as_document";
    public static final String USE_URL = "URL";
    public static final String USE_CODE = "code";
    public static final String USE_MESSAGE = "message";
    private static final String REGEX = "RegexExtractor.regex";
    private static final String REFNAME = "RegexExtractor.refname";
    private static final String MATCH_NUMBER = "RegexExtractor.match_number";
    private static final String DEFAULT = "RegexExtractor.default";
    private static final String DEFAULT_EMPTY_VALUE = "RegexExtractor.default_empty_value";
    private static final String TEMPLATE = "RegexExtractor.template";
    private static final String REF_MATCH_NR = "_matchNr";
    private static final String UNDERSCORE = "_";
    private static final boolean DEFAULT_VALUE_FOR_DEFAULT_EMPTY_VALUE = false;
    private transient List<Object> template;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        this.initTemplate();
        JMeterContext context = this.getThreadContext();
        SampleResult previousResult = context.getPreviousResult();
        if (previousResult == null) {
            return;
        }
        log.debug("RegexExtractor processing result");
        JMeterVariables vars = context.getVariables();
        String refName = this.getRefName();
        int matchNumber = this.getMatchNumber();
        String defaultValue = this.getDefaultValue();
        if (defaultValue.length() > 0 || this.isEmptyDefaultValue()) {
            vars.put(refName, defaultValue);
        }
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        String regex = this.getRegex();
        Pattern pattern = null;
        try {
            pattern = JMeterUtils.getPatternCache().getPattern(regex, 32768);
            List<MatchResult> matches = this.processMatches(pattern, regex, previousResult, matchNumber, vars);
            int prevCount = 0;
            String prevString = vars.get(refName + REF_MATCH_NR);
            if (prevString != null) {
                vars.remove(refName + REF_MATCH_NR);
                try {
                    prevCount = Integer.parseInt(prevString);
                }
                catch (NumberFormatException nfe) {
                    log.warn("Could not parse number: '{}'", (Object)prevString);
                }
            }
            int matchCount = 0;
            try {
                String refName_n;
                int i;
                MatchResult match;
                if (matchNumber >= 0) {
                    match = this.getCorrectMatch(matches, matchNumber);
                    if (match != null) {
                        vars.put(refName, this.generateResult(match));
                        this.saveGroups(vars, refName, match);
                    } else {
                        this.removeGroups(vars, refName);
                    }
                } else {
                    this.removeGroups(vars, refName);
                    matchCount = matches.size();
                    vars.put(refName + REF_MATCH_NR, Integer.toString(matchCount));
                    for (i = 1; i <= matchCount; ++i) {
                        match = this.getCorrectMatch(matches, i);
                        if (match == null) continue;
                        refName_n = refName + UNDERSCORE + i;
                        vars.put(refName_n, this.generateResult(match));
                        this.saveGroups(vars, refName_n, match);
                    }
                }
                for (i = matchCount + 1; i <= prevCount; ++i) {
                    refName_n = refName + UNDERSCORE + i;
                    vars.remove(refName_n);
                    this.removeGroups(vars, refName_n);
                }
            }
            catch (RuntimeException e) {
                log.warn("Error while generating result");
            }
        }
        catch (MalformedCachePatternException e) {
            log.error("Error in pattern: '{}'", (Object)regex);
        }
        finally {
            JMeterUtils.clearMatcherMemory((Perl5Matcher)matcher, (Pattern)pattern);
        }
    }

    private String getInputString(SampleResult result) {
        String inputString = this.useUrl() ? result.getUrlAsString() : (this.useHeaders() ? result.getResponseHeaders() : (this.useRequestHeaders() ? result.getRequestHeaders() : (this.useCode() ? result.getResponseCode() : (this.useMessage() ? result.getResponseMessage() : (this.useUnescapedBody() ? StringEscapeUtils.unescapeHtml4((String)result.getResponseDataAsString()) : (this.useBodyAsDocument() ? Document.getTextFromDocument((byte[])result.getResponseData()) : result.getResponseDataAsString()))))));
        log.debug("Input = '{}'", (Object)inputString);
        return inputString;
    }

    private List<MatchResult> processMatches(Pattern pattern, String regex, SampleResult result, int matchNumber, JMeterVariables vars) {
        log.debug("Regex = '{}'", (Object)regex);
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        ArrayList<MatchResult> matches = new ArrayList<MatchResult>();
        int found = 0;
        if (this.isScopeVariable()) {
            String inputString = vars.get(this.getVariableName());
            if (inputString == null) {
                if (log.isWarnEnabled()) {
                    log.warn("No variable '{}' found to process by RegexExtractor '{}', skipping processing", (Object)this.getVariableName(), (Object)this.getName());
                }
                return Collections.emptyList();
            }
            this.matchStrings(matchNumber, matcher, pattern, matches, found, inputString);
        } else {
            List sampleList = this.getSampleList(result);
            for (SampleResult sr : sampleList) {
                String inputString = this.getInputString(sr);
                found = this.matchStrings(matchNumber, matcher, pattern, matches, found, inputString);
                if (matchNumber <= 0 || found != matchNumber) continue;
                break;
            }
        }
        return matches;
    }

    private int matchStrings(int matchNumber, Perl5Matcher matcher, Pattern pattern, List<MatchResult> matches, int found, String inputString) {
        PatternMatcherInput input = new PatternMatcherInput(inputString);
        while ((matchNumber <= 0 || found != matchNumber) && matcher.contains(input, pattern)) {
            log.debug("RegexExtractor: Match found!");
            matches.add(matcher.getMatch());
            ++found;
        }
        return found;
    }

    private void saveGroups(JMeterVariables vars, String basename, MatchResult match) {
        StringBuilder buf = new StringBuilder();
        buf.append(basename);
        buf.append("_g");
        int pfxlen = buf.length();
        String prevString = vars.get(buf.toString());
        int previous = 0;
        if (prevString != null) {
            try {
                previous = Integer.parseInt(prevString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Could not parse number: '{}'.", (Object)prevString);
            }
        }
        int groups = match.groups();
        for (int x = 0; x < groups; ++x) {
            buf.append(x);
            vars.put(buf.toString(), match.group(x));
            buf.setLength(pfxlen);
        }
        vars.put(buf.toString(), Integer.toString(groups - 1));
        for (int i = groups; i <= previous; ++i) {
            buf.append(i);
            vars.remove(buf.toString());
            buf.setLength(pfxlen);
        }
    }

    private void removeGroups(JMeterVariables vars, String basename) {
        int groups;
        StringBuilder buf = new StringBuilder();
        buf.append(basename);
        buf.append("_g");
        int pfxlen = buf.length();
        try {
            groups = Integer.parseInt(vars.get(buf.toString()));
        }
        catch (NumberFormatException e) {
            groups = 0;
        }
        vars.remove(buf.toString());
        for (int i = 0; i <= groups; ++i) {
            buf.append(i);
            vars.remove(buf.toString());
            buf.setLength(pfxlen);
        }
    }

    private String generateResult(MatchResult match) {
        StringBuilder result = new StringBuilder();
        for (Object obj : this.template) {
            if (log.isDebugEnabled()) {
                log.debug("RegexExtractor: Template piece {} ({})", obj, obj.getClass());
            }
            if (obj instanceof Integer) {
                result.append(match.group(((Integer)obj).intValue()));
                continue;
            }
            result.append(obj);
        }
        log.debug("Regex Extractor result = '{}'", (Object)result);
        return result.toString();
    }

    private void initTemplate() {
        if (this.template != null) {
            return;
        }
        ArrayList<Object> combined = new ArrayList<Object>();
        String rawTemplate = this.getTemplate();
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        Pattern templatePattern = JMeterUtils.getPatternCache().getPattern("\\$(\\d+)\\$", 0);
        if (log.isDebugEnabled()) {
            log.debug("Pattern = '{}', template = '{}'", (Object)templatePattern.getPattern(), (Object)rawTemplate);
        }
        int beginOffset = 0;
        PatternMatcherInput pinput = new PatternMatcherInput(rawTemplate);
        while (matcher.contains(pinput, templatePattern)) {
            MatchResult currentResult = matcher.getMatch();
            int beginMatch = currentResult.beginOffset(0);
            if (beginMatch > beginOffset) {
                combined.add(rawTemplate.substring(beginOffset, beginMatch));
            }
            combined.add(Integer.valueOf(currentResult.group(1)));
            beginOffset = currentResult.endOffset(0);
        }
        if (beginOffset < rawTemplate.length()) {
            combined.add(rawTemplate.substring(beginOffset, rawTemplate.length()));
        }
        if (log.isDebugEnabled()) {
            log.debug("Template item count: {}", (Object)combined.size());
            int i = 0;
            for (Object e : combined) {
                log.debug("Template item-{}: {} '{}'", new Object[]{i++, e.getClass(), e});
            }
        }
        this.template = combined;
    }

    private MatchResult getCorrectMatch(List<MatchResult> matches, int entry) {
        int matchSize = matches.size();
        if (matchSize <= 0 || entry > matchSize) {
            return null;
        }
        if (entry == 0) {
            return matches.get(JMeterUtils.getRandomInt((int)matchSize));
        }
        return matches.get(entry - 1);
    }

    public void setRegex(String regex) {
        this.setProperty(REGEX, regex);
    }

    public String getRegex() {
        return this.getPropertyAsString(REGEX);
    }

    public void setRefName(String refName) {
        this.setProperty(REFNAME, refName);
    }

    public String getRefName() {
        return this.getPropertyAsString(REFNAME);
    }

    public void setMatchNumber(int matchNumber) {
        this.setProperty((JMeterProperty)new IntegerProperty(MATCH_NUMBER, matchNumber));
    }

    public void setMatchNumber(String matchNumber) {
        this.setProperty(MATCH_NUMBER, matchNumber);
    }

    public int getMatchNumber() {
        return this.getPropertyAsInt(MATCH_NUMBER);
    }

    public String getMatchNumberAsString() {
        return this.getPropertyAsString(MATCH_NUMBER);
    }

    public void setDefaultValue(String defaultValue) {
        this.setProperty(DEFAULT, defaultValue);
    }

    public void setDefaultEmptyValue(boolean defaultEmptyValue) {
        this.setProperty(DEFAULT_EMPTY_VALUE, defaultEmptyValue, false);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }

    public boolean isEmptyDefaultValue() {
        return this.getPropertyAsBoolean(DEFAULT_EMPTY_VALUE, false);
    }

    public void setTemplate(String template) {
        this.setProperty(TEMPLATE, template);
    }

    public String getTemplate() {
        return this.getPropertyAsString(TEMPLATE);
    }

    public boolean useHeaders() {
        return USE_HDRS.equalsIgnoreCase(this.getPropertyAsString(MATCH_AGAINST));
    }

    public boolean useRequestHeaders() {
        return USE_REQUEST_HDRS.equalsIgnoreCase(this.getPropertyAsString(MATCH_AGAINST));
    }

    public boolean useBody() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return prop.length() == 0 || USE_BODY.equalsIgnoreCase(prop);
    }

    public boolean useUnescapedBody() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_BODY_UNESCAPED.equalsIgnoreCase(prop);
    }

    public boolean useBodyAsDocument() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_BODY_AS_DOCUMENT.equalsIgnoreCase(prop);
    }

    public boolean useUrl() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_URL.equalsIgnoreCase(prop);
    }

    public boolean useCode() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_CODE.equalsIgnoreCase(prop);
    }

    public boolean useMessage() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_MESSAGE.equalsIgnoreCase(prop);
    }

    public void setUseField(String actionCommand) {
        this.setProperty(MATCH_AGAINST, actionCommand);
    }
}

